/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.impl.ExcludedChunkListKt;
import com.intellij.openapi.util.ClearableLazyValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0003H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/platform/impl/ExcludedChunkList;", "", "excludedListDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "excludedChunks", "Lcom/intellij/openapi/util/ClearableLazyValue;", "", "", "getStoragePath", "isChunkExcluded", "", "chunkId", "markChunksAsExcluded", "", "chunkIds", "", "readExcludedChunks", "intellij.indexing.shared"})
public final class ExcludedChunkList {
    private final ClearableLazyValue<Set<String>> excludedChunks;
    private final Path excludedListDir;

    public final void markChunksAsExcluded(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Set<String> set = Collections.singleton(chunkId);
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.singleton(chunkId)");
        this.markChunksAsExcluded((Collection<String>)set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final synchronized void markChunksAsExcluded(@NotNull Collection<String> chunkIds) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(chunkIds, (String)"chunkIds");
        Iterable $this$filterNot$iv = chunkIds;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (((Set)this.excludedChunks.getValue()).contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List chunkIdsToExclude = (List)destination$iv$iv;
        try {
            Files.createDirectories(this.excludedListDir, new FileAttribute[0]);
            Files.write(this.getStoragePath(), (Iterable<? extends CharSequence>)chunkIdsToExclude, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            ExcludedChunkListKt.access$getLog$p().error("Can't add chunk ids to excluded chunk list", (Throwable)e);
            try {
                Files.createDirectories(this.excludedListDir, new FileAttribute[0]);
                Path path = this.getStoragePath();
                Object object = this.excludedChunks.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"excludedChunks.value");
                Files.write(path, (Iterable<? extends CharSequence>)CollectionsKt.union((Iterable)((Iterable)object), (Iterable)chunkIdsToExclude), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e2) {
                ExcludedChunkListKt.access$getLog$p().error("Can't add chunk ids to excluded chunk list", (Throwable)e2);
            }
        }
        finally {
            this.excludedChunks.drop();
        }
        ExcludedChunkListKt.access$getLog$p().info("Chunks " + chunkIds + " added as excluded");
    }

    public final synchronized boolean isChunkExcluded(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return ((Set)this.excludedChunks.getValue()).contains(chunkId);
    }

    private final Set<String> readExcludedChunks() {
        try {
            Path storagePath = this.getStoragePath();
            if (!Files.exists(storagePath, new LinkOption[0])) {
                return SetsKt.emptySet();
            }
            List<String> list = Files.readAllLines(storagePath, StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(stora\u2026, StandardCharsets.UTF_8)");
            return CollectionsKt.toHashSet((Iterable)list);
        }
        catch (IOException e) {
            ExcludedChunkListKt.access$getLog$p().error("Excluded chunk list is corrupted", (Throwable)e);
            return SetsKt.emptySet();
        }
    }

    private final Path getStoragePath() {
        Path path = this.excludedListDir.resolve("excluded-chunks.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"excludedListDir.resolve(\"excluded-chunks.txt\")");
        return path;
    }

    public ExcludedChunkList(@NotNull Path excludedListDir) {
        Intrinsics.checkNotNullParameter((Object)excludedListDir, (String)"excludedListDir");
        this.excludedListDir = excludedListDir;
        ClearableLazyValue clearableLazyValue = ClearableLazyValue.create((Supplier)new Supplier(this){
            final /* synthetic */ ExcludedChunkList this$0;

            @Nullable
            public final Set<String> get() {
                return ExcludedChunkList.access$readExcludedChunks(this.this$0);
            }
            {
                this.this$0 = excludedChunkList;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue, (String)"ClearableLazyValue.creat\u2026 readExcludedChunks()\n  }");
        this.excludedChunks = clearableLazyValue;
    }

    public static final /* synthetic */ Set access$readExcludedChunks(ExcludedChunkList $this) {
        return $this.readExcludedChunks();
    }
}

