/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdkSupport {
    @NotNull
    public static JavaSdk getSupportedSdkType() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        if (javaSdk == null) {
            JdkSupport.$$$reportNull$$$0(0);
        }
        return javaSdk;
    }

    public static boolean isJdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            JdkSupport.$$$reportNull$$$0(1);
        }
        return JavaSdk.getInstance() == sdk.getSdkType();
    }

    @Nullable
    public static String computeJdkFingerprint(@NotNull Sdk sdk) {
        if (sdk == null) {
            JdkSupport.$$$reportNull$$$0(2);
        }
        if (!JdkSupport.isJdk(sdk)) {
            return null;
        }
        byte[] fingerprintVersion = new byte[]{1, 0, 0, 0};
        MessageDigest hasher = DigestUtil.sha1();
        hasher.update(fingerprintVersion);
        String path = sdk.getHomePath();
        if (path == null) {
            return null;
        }
        Path homePath = Paths.get(path, new String[0]);
        if (WslDistributionManager.isWslPath((String)sdk.getHomePath())) {
            return null;
        }
        if (!PathKt.isDirectory((Path)homePath)) {
            return null;
        }
        boolean hasRelease = JdkSupport.hashIfExists(hasher, homePath, "release");
        boolean hasVersion = JdkSupport.hashIfExists(hasher, homePath, "version.txt");
        boolean hasLib = JdkSupport.hashIfExists(hasher, homePath, "lib");
        JdkSupport.hashIfExists(hasher, homePath, "jmod");
        if (!(hasRelease || hasVersion || hasLib)) {
            return null;
        }
        return StringUtil.toHexString((byte[])hasher.digest());
    }

    private static boolean hashIfExists(@NotNull MessageDigest hasher, @NotNull Path homePath, @NotNull String rel) {
        Path relPath;
        if (hasher == null) {
            JdkSupport.$$$reportNull$$$0(3);
        }
        if (homePath == null) {
            JdkSupport.$$$reportNull$$$0(4);
        }
        if (rel == null) {
            JdkSupport.$$$reportNull$$$0(5);
        }
        if (!PathKt.exists((Path)(relPath = homePath.resolve(rel)))) {
            return false;
        }
        if (PathKt.isFile((Path)relPath)) {
            hasher.update(rel.getBytes(StandardCharsets.UTF_8));
            DigestUtil.updateContentHash((MessageDigest)hasher, (Path)relPath);
            return true;
        }
        if (PathKt.isDirectory((Path)relPath)) {
            try (Stream<Path> stream = Files.walk(relPath, new FileVisitOption[0]);){
                stream.filter(file2 -> PathKt.isFile((Path)file2)).map(file2 -> Pair.create((Object)homePath.relativize((Path)file2).toString(), (Object)file2)).sorted(Pair.comparingByFirst()).forEach(pair -> {
                    String relativeName = (String)pair.first;
                    Path file2 = (Path)pair.second;
                    if (!PathKt.isFile((Path)file2)) {
                        return;
                    }
                    if (relativeName.endsWith("modules") || relativeName.endsWith(".jar") || relativeName.endsWith(".zip") || relativeName.endsWith(".jmod")) {
                        hasher.update(relativeName.getBytes(StandardCharsets.UTF_8));
                        DigestUtil.updateContentHash((MessageDigest)hasher, (Path)file2);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to walk " + relPath + ". " + e.getMessage(), e);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/java/jdk/JdkSupport";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedSdkType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/java/jdk/JdkSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isJdk";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeJdkFingerprint";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hashIfExists";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

