/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download.permanentToken;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenConnectionTestKt;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenEnsureParams;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenWrapper;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenWrapperKt;
import com.intellij.indexing.shared.download.permanentToken.SharedIndexAuthPermanentNotifications;
import com.intellij.indexing.shared.download.permanentToken.TokenStatus;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u0006\u0010 \u001a\u00020\u0017J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenWrapper;", "Lcom/intellij/openapi/Disposable;", "tokenName", "", "urls", "", "(Ljava/lang/String;Ljava/util/Set;)V", "notifications", "Lcom/intellij/indexing/shared/download/permanentToken/SharedIndexAuthPermanentNotifications;", "refreshTokenStore", "Lcom/intellij/credentialStore/CredentialAttributes;", "getRefreshTokenStore", "()Lcom/intellij/credentialStore/CredentialAttributes;", "refreshTokenStore$delegate", "Lkotlin/Lazy;", "tokenCache", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/indexing/shared/download/permanentToken/TokenStatus;", "getTokenName", "()Ljava/lang/String;", "getUrls", "()Ljava/util/Set;", "dispose", "", "ensureToken", "", "request", "Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenEnsureParams;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readToken", "readTokenInternal", "resetToken", "setToken", "password", "intellij.indexing.shared"})
public final class PermanentTokenWrapper
implements Disposable {
    private final SharedIndexAuthPermanentNotifications notifications;
    private final AtomicReference<TokenStatus> tokenCache;
    private final Lazy refreshTokenStore$delegate;
    @NotNull
    private final String tokenName;
    @NotNull
    private final Set<String> urls;

    private final CredentialAttributes getRefreshTokenStore() {
        Lazy lazy = this.refreshTokenStore$delegate;
        PermanentTokenWrapper permanentTokenWrapper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CredentialAttributes)lazy.getValue();
    }

    public void dispose() {
    }

    public final void resetToken() {
        PasswordSafe.Companion.getInstance().set(this.getRefreshTokenStore(), null);
        this.tokenCache.set(TokenStatus.NO_TOKEN.INSTANCE);
    }

    public final void setToken(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Credentials credentials = new Credentials(CollectionsKt.joinToString$default((Iterable)this.urls, null, null, null, (int)0, null, null, (int)63, null), password);
        PasswordSafe.Companion.getInstance().set(this.getRefreshTokenStore(), credentials);
        this.tokenCache.set(new TokenStatus.Token(password));
    }

    @Nullable
    public final String readToken() {
        return this.tokenCache.updateAndGet(new UnaryOperator(this){
            final /* synthetic */ PermanentTokenWrapper this$0;

            public final TokenStatus apply(@Nullable TokenStatus cache2) {
                return cache2 == null || cache2 instanceof TokenStatus.FAILED ? PermanentTokenWrapper.access$readTokenInternal(this.this$0) : cache2;
            }
            {
                this.this$0 = permanentTokenWrapper;
            }
        }).getToken();
    }

    private final TokenStatus readTokenInternal() {
        String refreshToken;
        block10: {
            block9: {
                Credentials credentials;
                Credentials credentials2;
                try {
                    credentials2 = PasswordSafe.Companion.getInstance().get(this.getRefreshTokenStore());
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    PermanentTokenWrapperKt.access$getLOG$p().warn("Failed to access PasswordSafe for " + this.getRefreshTokenStore().getServiceName(), t);
                    return TokenStatus.FAILED.INSTANCE;
                }
                Object object = credentials = credentials2;
                if (Intrinsics.areEqual((Object)object, (Object)CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED())) {
                    PermanentTokenWrapperKt.access$getLOG$p().info("Failed to access to credentials store for " + this.getRefreshTokenStore().getServiceName() + ". Access denied");
                    return TokenStatus.FAILED.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)object, (Object)CredentialStoreKt.getCANNOT_UNLOCK_KEYCHAIN())) {
                    PermanentTokenWrapperKt.access$getLOG$p().info("Failed to access to credentials store " + this.getRefreshTokenStore().getServiceName() + ". Cannot unlock keychain");
                    return TokenStatus.FAILED.INSTANCE;
                }
                if (object == null) {
                    return TokenStatus.NO_TOKEN.INSTANCE;
                }
                refreshToken = credentials.getPasswordAsString();
                if (refreshToken == null) break block9;
                object = refreshToken;
                boolean bl = false;
                boolean bl2 = false;
                if (!StringsKt.isBlank((CharSequence)object)) break block10;
            }
            return TokenStatus.NO_TOKEN.INSTANCE;
        }
        return new TokenStatus.Token(refreshToken);
    }

    public final boolean ensureToken(@NotNull PermanentTokenEnsureParams request, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string2 = this.readToken();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String token = string3;
            boolean bl3 = false;
            boolean hasConnection = PermanentTokenConnectionTestKt.testConnection(request, token, true, indicator);
            if (hasConnection) {
                return true;
            }
            this.resetToken();
        }
        if (Disposer.isDisposed((Disposable)request.getLifetime())) {
            return false;
        }
        this.notifications.showNotification(request);
        return false;
    }

    @NotNull
    public final String getTokenName() {
        return this.tokenName;
    }

    @NotNull
    public final Set<String> getUrls() {
        return this.urls;
    }

    public PermanentTokenWrapper(@NotNull String tokenName, @NotNull Set<String> urls) {
        Intrinsics.checkNotNullParameter((Object)tokenName, (String)"tokenName");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        this.tokenName = tokenName;
        this.urls = urls;
        this.notifications = new SharedIndexAuthPermanentNotifications(this);
        this.tokenCache = new AtomicReference<Object>(null);
        Disposer.register((Disposable)this, (Disposable)this.notifications);
        String clazzName = this.getClass().getName();
        PluginId pluginId = PluginManager.getPluginByClassName((String)clazzName);
        DumbAwareAction resetAction2 = new DumbAwareAction(this){
            final /* synthetic */ PermanentTokenWrapper this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.resetToken();
                    PermanentTokenWrapper.access$getNotifications$p(this.this$0).ensureNotificationPossible();
                    Project project = e.getProject();
                    if (project == null) break block1;
                    Project project2 = project;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project it = project2;
                    boolean bl3 = false;
                    boolean $i$f$service = false;
                    Class<SharedIndexDownloadService> serviceClass$iv = SharedIndexDownloadService.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    SharedIndexDownloadService sharedIndexDownloadService = (SharedIndexDownloadService)object;
                    Project project3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
                    sharedIndexDownloadService.rescanNow(project3);
                }
            }
            {
                this.this$0 = this$0;
                this.addSynonym(new Supplier(this){
                    final /* synthetic */ resetAction.1 this$0;

                    public final String get() {
                        return SharedIndexesBundle.message("action.text.synonym1.permanent.reset", this.this$0.this$0.getTokenName());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                this.addSynonym(new Supplier(this){
                    final /* synthetic */ resetAction.1 this$0;

                    public final String get() {
                        return SharedIndexesBundle.message("action.text.synonym2.permanent.reset", this.this$0.this$0.getTokenName());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Presentation presentation = this.getTemplatePresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
                presentation.setText(SharedIndexesBundle.message("action.text.permanent.reset", this$0.getTokenName()));
                Presentation presentation2 = this.getTemplatePresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
                presentation2.setDescription(SharedIndexesBundle.message("action.description.permanent.reset", this$0.getTokenName(), NlsMessages.formatNarrowAndList((Collection)this$0.getUrls())));
            }
        };
        final String resetActionId = clazzName + ":reset-" + UtilKt.sha256(this.tokenName);
        ActionManager.getInstance().registerAction(resetActionId, (AnAction)resetAction2, pluginId);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                ActionManager.getInstance().unregisterAction(resetActionId);
            }
        });
        this.refreshTokenStore$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CredentialAttributes>(this){
            final /* synthetic */ PermanentTokenWrapper this$0;

            @NotNull
            public final CredentialAttributes invoke() {
                return new CredentialAttributes("intellij-shared-indexes-token-" + this.this$0.getTokenName(), null, null, false, 14, null);
            }
            {
                this.this$0 = permanentTokenWrapper;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ TokenStatus access$readTokenInternal(PermanentTokenWrapper $this) {
        return $this.readTokenInternal();
    }

    public static final /* synthetic */ SharedIndexAuthPermanentNotifications access$getNotifications$p(PermanentTokenWrapper $this) {
        return $this.notifications;
    }
}

