/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexListLookupResult;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexUrlDecision;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/download/UrlSiblingsChecker;", "Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;", "listUrl", "", "siblings", "", "(Ljava/lang/String;Ljava/util/Set;)V", "getListUrl", "()Ljava/lang/String;", "getSiblings", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "testUrl", "Lcom/intellij/indexing/shared/download/SharedIndexUrlDecision;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "url", "toString", "intellij.indexing.shared"})
final class UrlSiblingsChecker
implements SharedIndexListLookupResult {
    @NotNull
    private final String listUrl;
    @NotNull
    private final Set<String> siblings;

    @Override
    @NotNull
    public SharedIndexUrlDecision testUrl(@NotNull SharedIndexLookupRequest request, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String prefix = StringsKt.trim((String)this.listUrl, (char[])new char[]{'/'}) + "/";
        if (!StringsKt.startsWith$default((String)url, (String)prefix, (boolean)false, (int)2, null)) {
            return SharedIndexUrlDecision.UNKNOWN;
        }
        String sibling = StringsKt.trim((String)StringsKt.removePrefix((String)url, (CharSequence)prefix), (char[])new char[]{'/'});
        if (StringsKt.contains$default((CharSequence)sibling, (CharSequence)"/", (boolean)false, (int)2, null)) {
            return SharedIndexUrlDecision.UNKNOWN;
        }
        if (this.siblings.contains(sibling)) {
            return SharedIndexUrlDecision.TRY;
        }
        return SharedIndexUrlDecision.SKIP;
    }

    @NotNull
    public final String getListUrl() {
        return this.listUrl;
    }

    @NotNull
    public final Set<String> getSiblings() {
        return this.siblings;
    }

    public UrlSiblingsChecker(@NotNull String listUrl, @NotNull Set<String> siblings) {
        Intrinsics.checkNotNullParameter((Object)listUrl, (String)"listUrl");
        Intrinsics.checkNotNullParameter(siblings, (String)"siblings");
        this.listUrl = listUrl;
        this.siblings = siblings;
    }

    @NotNull
    public final String component1() {
        return this.listUrl;
    }

    @NotNull
    public final Set<String> component2() {
        return this.siblings;
    }

    @NotNull
    public final UrlSiblingsChecker copy(@NotNull String listUrl, @NotNull Set<String> siblings) {
        Intrinsics.checkNotNullParameter((Object)listUrl, (String)"listUrl");
        Intrinsics.checkNotNullParameter(siblings, (String)"siblings");
        return new UrlSiblingsChecker(listUrl, siblings);
    }

    public static /* synthetic */ UrlSiblingsChecker copy$default(UrlSiblingsChecker urlSiblingsChecker, String string2, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = urlSiblingsChecker.listUrl;
        }
        if ((n & 2) != 0) {
            set = urlSiblingsChecker.siblings;
        }
        return urlSiblingsChecker.copy(string2, set);
    }

    @NotNull
    public String toString() {
        return "UrlSiblingsChecker(listUrl=" + this.listUrl + ", siblings=" + this.siblings + ")";
    }

    public int hashCode() {
        String string2 = this.listUrl;
        Set<String> set = this.siblings;
        return (string2 != null ? string2.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof UrlSiblingsChecker)) break block3;
                UrlSiblingsChecker urlSiblingsChecker = (UrlSiblingsChecker)object;
                if (!Intrinsics.areEqual((Object)this.listUrl, (Object)urlSiblingsChecker.listUrl) || !Intrinsics.areEqual(this.siblings, urlSiblingsChecker.siblings)) break block3;
            }
            return true;
        }
        return false;
    }
}

