/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.download.SharedIndexAuthHolder;
import com.intellij.indexing.shared.download.SharedIndexDownloadJson;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadJson;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "avoidCaching", "", "url", "downloadJsonXz", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "testConnection", "", "headers", "", "intellij.indexing.shared"})
public final class SharedIndexDownloadJson {
    private final Logger LOG;

    @VisibleForTesting
    public final boolean testConnection(@NotNull String url, @NotNull Map<String, String> headers, @NotNull ProgressIndicator indicator) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            try {
                indicator.checkCanceled();
                HttpRequests.request((String)url).productNameAsUserAgent().accept("application/octet-stream, application/xz").tuner(new HttpRequests.ConnectionTuner(headers){
                    final /* synthetic */ Map $headers;

                    /*
                     * WARNING - void declaration
                     */
                    public final void tune(@NotNull URLConnection tuner) {
                        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
                        Map $this$forEach$iv = this.$headers;
                        boolean $i$f$forEach = false;
                        Map map = $this$forEach$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void k;
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$k$v = element$iv = iterator.next();
                            boolean bl2 = false;
                            Map.Entry<K, V> entry = $dstr$k$v;
                            boolean bl3 = false;
                            String string2 = (String)entry.getKey();
                            entry = $dstr$k$v;
                            bl3 = false;
                            String v = (String)entry.getValue();
                            tuner.addRequestProperty((String)k, v);
                        }
                    }
                    {
                        this.$headers = map;
                    }
                }).throwStatusCodeException(true).connect((HttpRequests.RequestProcessor)testConnection.2.INSTANCE);
            }
            catch (HttpRequests.HttpStatusException e) {
                return false;
            }
            finally {
                if (e.getStatusCode() < 400) break block4;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public final ObjectNode downloadJsonXz(@NotNull SharedIndexLookupRequest request, @NotNull String url, @NotNull ProgressIndicator indicator) {
        Object object;
        byte[] byArray;
        boolean bl;
        block34: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.LOG.debug("Checking " + url + " for " + request + "...");
            boolean $i$f$service = false;
            Class<SharedIndexAuthHolder> serviceClass$iv = SharedIndexAuthHolder.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            Map<String, String> headers = ((SharedIndexAuthHolder)object2).resolveHeaders(url, request, indicator);
            Logger LOG$iv = this.LOG;
            boolean $i$f$handleHttpDownloadExceptions = false;
            try {
                bl = false;
                byArray = HttpRequests.request((String)this.avoidCaching(url)).productNameAsUserAgent().accept("application/octet-stream, application/xz").tuner(new HttpRequests.ConnectionTuner(this, url, headers, indicator){
                    final /* synthetic */ SharedIndexDownloadJson this$0;
                    final /* synthetic */ String $url$inlined;
                    final /* synthetic */ Map $headers$inlined;
                    final /* synthetic */ ProgressIndicator $indicator$inlined;
                    {
                        this.this$0 = sharedIndexDownloadJson;
                        this.$url$inlined = string2;
                        this.$headers$inlined = map;
                        this.$indicator$inlined = progressIndicator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void tune(@NotNull URLConnection tuner) {
                        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
                        Map $this$forEach$iv = this.$headers$inlined;
                        boolean $i$f$forEach = false;
                        Map map = $this$forEach$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void k;
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$k$v = element$iv = iterator.next();
                            boolean bl2 = false;
                            Map.Entry<K, V> entry = $dstr$k$v;
                            boolean bl3 = false;
                            String string2 = (String)entry.getKey();
                            entry = $dstr$k$v;
                            bl3 = false;
                            String v = (String)entry.getValue();
                            tuner.addRequestProperty((String)k, v);
                        }
                    }
                }).throwStatusCodeException(true).readBytes(indicator);
                break block34;
            }
            catch (ConnectException e$iv) {
                LOG$iv.debug("Cannot connect to the host for " + url + " for " + request + ". " + e$iv.getMessage(), (Throwable)e$iv);
            }
            catch (UnknownHostException e$iv) {
                LOG$iv.debug("Cannot resolve host for " + url + " for " + request + ". " + e$iv.getMessage(), (Throwable)e$iv);
            }
            catch (SocketTimeoutException e$iv) {
                if (LOG$iv.isDebugEnabled()) {
                    LOG$iv.warn("Connection expired by timeout at " + url + " for " + request + ". Error: " + e$iv.getMessage() + '.', (Throwable)e$iv);
                } else {
                    LOG$iv.warn("Connection expired by timeout at " + url + " for " + request + ". Error: " + e$iv.getMessage() + '.');
                }
            }
            catch (HttpRequests.HttpStatusException e$iv) {
                if (e$iv.getStatusCode() < 500) {
                    LOG$iv.debug("No data available for " + url + " for " + request + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                } else {
                    LOG$iv.info("No data available for " + url + " for " + request + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                }
            }
            catch (IOException e$iv) {
                if (LOG$iv.isDebugEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url).append(" for ").append(request).append(". Error: ");
                    String string2 = e$iv.getMessage();
                    if (string2 == null) {
                        Throwable throwable = e$iv.getCause();
                        string2 = throwable != null ? throwable.getMessage() : null;
                    }
                    LOG$iv.warn(stringBuilder.append(string2 != null ? (Serializable)((Object)string2) : (Serializable)e$iv.getClass()).toString(), (Throwable)e$iv);
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url).append(" for ").append(request).append(". Error: ");
                    String string3 = e$iv.getMessage();
                    if (string3 == null) {
                        Throwable throwable = e$iv.getCause();
                        string3 = throwable != null ? throwable.getMessage() : null;
                    }
                    LOG$iv.warn(stringBuilder.append(string3 != null ? (Serializable)((Object)string3) : (Serializable)e$iv.getClass()).toString());
                }
            }
            catch (Throwable t$iv) {
                if (t$iv instanceof ControlFlowException) {
                    throw t$iv;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Failed to download ").append(url).append(" due ").append(t$iv.getClass()).append(" for ").append(request).append(". Error: ");
                String string4 = t$iv.getMessage();
                if (string4 == null) {
                    Throwable throwable = t$iv.getCause();
                    string4 = throwable != null ? throwable.getMessage() : null;
                }
                LOG$iv.warn(stringBuilder.append(string4 != null ? (Serializable)((Object)string4) : (Serializable)t$iv.getClass()).toString());
            }
            byArray = null;
        }
        if (byArray == null) {
            return null;
        }
        byte[] rawDataXZ = byArray;
        try {
            byte[] byArray2;
            object = new ByteArrayInputStream(rawDataXZ);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                byte[] byArray3;
                ByteArrayInputStream input = (ByteArrayInputStream)object;
                boolean bl3 = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl6 = false;
                    byArray3 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray2 = byArray3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray2;
        }
        catch (Throwable e) {
            this.LOG.warn("Failed to unpack data from " + url + " for " + request + ". " + e.getMessage());
            return null;
        }
        Object rawData = object;
        try {
            JsonNode jsonNode = new ObjectMapper().readTree((byte[])rawData);
            if (jsonNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            object = (ObjectNode)jsonNode;
        }
        catch (Throwable e) {
            this.LOG.warn("Failed to read JSON from " + url + " for " + request + ". " + e.getMessage());
            return null;
        }
        return object;
    }

    private final String avoidCaching(String url) {
        return url + "?timestamp=" + System.currentTimeMillis();
    }

    public SharedIndexDownloadJson() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexDownloadJson.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
    }
}

