/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.util;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.fest.util.Preconditions;

public final class Accessibles {
    private static Logger logger = Logger.getLogger(Accessibles.class.getCanonicalName());

    private Accessibles() {
    }

    public static void setAccessibleIgnoringExceptions(@Nonnull AccessibleObject o, boolean accessible) {
        try {
            Accessibles.setAccessible(o, accessible);
        }
        catch (RuntimeException ignored) {
            String format = "Failed to set 'accessible' flag of %s to %s";
            logger.log(Level.SEVERE, String.format(format, o.toString(), String.valueOf(accessible)), ignored);
        }
    }

    public static void makeAccessible(@Nonnull AccessibleObject o) {
        Accessibles.setAccessible(o, true);
    }

    public static void setAccessible(@Nonnull AccessibleObject o, boolean accessible) {
        AccessController.doPrivileged(new SetAccessibleAction(o, accessible));
    }

    private static class SetAccessibleAction
    implements PrivilegedAction<Void> {
        private final AccessibleObject o;
        private final boolean accessible;

        SetAccessibleAction(@Nonnull AccessibleObject o, boolean accessible) {
            this.o = Preconditions.checkNotNull(o);
            this.accessible = accessible;
        }

        @Override
        public Void run() {
            this.o.setAccessible(this.accessible);
            return null;
        }
    }
}

