/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.method;

import javax.annotation.Nonnull;
import org.fest.reflect.method.MethodInvoker;
import org.fest.reflect.method.ParameterTypes;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Preconditions;

public class ReturnTypeRef<T> {
    private final String methodName;
    private final TypeRef<T> value;

    ReturnTypeRef(@Nonnull String methodName, @Nonnull TypeRef<T> type) {
        this.methodName = Preconditions.checkNotNullOrEmpty(methodName);
        this.value = Preconditions.checkNotNull(type);
    }

    @Nonnull
    public ParameterTypes<T> withParameterTypes(Class<?> ... parameterTypes) {
        return new ParameterTypes<T>(this.methodName, this.value.rawType(), parameterTypes);
    }

    @Nonnull
    public MethodInvoker<T> in(@Nonnull Object target) {
        return new MethodInvoker<T>(this.methodName, this.value.rawType(), new Class[0], target);
    }
}

