/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.method;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.util.Accessibles;
import org.fest.reflect.util.Throwables;
import org.fest.reflect.util.Types;
import org.fest.util.Arrays;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public final class MethodInvoker<T> {
    private final Class<T> returnType;
    private final Object target;
    private final Method method;

    MethodInvoker(@Nonnull String methodName, @Nonnull Class<T> returnType, @Nonnull Class<?>[] parameterTypes, @Nonnull Object target) {
        this.returnType = Preconditions.checkNotNull(returnType);
        this.target = Preconditions.checkNotNull(target);
        this.method = this.findMethodInClassHierarchy(Preconditions.checkNotNullOrEmpty(methodName), Preconditions.checkNotNull(parameterTypes));
    }

    @Nullable
    private static Method findMethod(@Nonnull String methodName, @Nonnull Class<?> type, @Nonnull Class<?>[] parameterTypes) {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nonnull
    private Method findMethodInClassHierarchy(@Nonnull String methodName, @Nonnull Class<?>[] parameterTypes) {
        Class<?> targetType;
        Method method = null;
        for (Class<?> type = targetType = this.target instanceof Class ? (Class<?>)this.target : this.target.getClass(); type != null && (method = MethodInvoker.findMethod(methodName, type, parameterTypes)) == null; type = type.getSuperclass()) {
        }
        if (method == null) {
            String format = "Unable to find method: %s in: %s with parameter type(s) %s";
            throw new ReflectionError(String.format(format, Strings.quote(methodName), targetType.getName(), Arrays.format(parameterTypes)));
        }
        return method;
    }

    @Nullable
    public T invoke(Object ... args) {
        Preconditions.checkNotNull(args);
        Method method = this.target();
        boolean accessible = method.isAccessible();
        try {
            Accessibles.makeAccessible(method);
            Object returnValue = method.invoke(this.target, args);
            T t = Types.castSafely(returnValue, Preconditions.checkNotNull(this.returnType));
            return t;
        }
        catch (Throwable t) {
            Throwable cause = Throwables.targetOf(t);
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            String format = "Unable to invoke method %s with arguments %s";
            throw new ReflectionError(String.format(format, Strings.quote(method.getName()), Arrays.format(args)), cause);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(method, accessible);
        }
    }

    @Nonnull
    public Method target() {
        return this.method;
    }
}

