/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import javax.annotation.Nonnull;
import org.fest.reflect.field.FieldType;
import org.fest.reflect.field.FieldTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

public final class FieldName {
    private final String name;

    @InternalApi
    public FieldName(@Nonnull String name) {
        this.name = Preconditions.checkNotNullOrEmpty(name);
    }

    @Nonnull
    public <T> FieldType<T> ofType(@Nonnull Class<T> type) {
        return new FieldType<T>(this.name, type);
    }

    @Nonnull
    public <T> FieldTypeRef<T> ofType(@Nonnull TypeRef<T> type) {
        return new FieldTypeRef<T>(this.name, type);
    }
}

