/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Preconditions;

public class StringAssert
extends GroupAssert<StringAssert, String> {
    protected StringAssert(@Nullable String actual) {
        super(StringAssert.class, actual);
    }

    @Nonnull
    public StringAssert isEqualToIgnoringCase(String expected) {
        if (this.actual == null && expected == null) {
            return this;
        }
        this.isNotNull();
        if (((String)this.actual).equalsIgnoreCase(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should be equal to :<%s> ignoring case", this.actual, expected));
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((String)this.actual).length();
    }

    @Nonnull
    public StringAssert contains(String expected) {
        this.isNotNull();
        if (((String)this.actual).indexOf(expected) != -1) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should contain the String:<%s>", this.actual, expected));
    }

    @Nonnull
    public StringAssert endsWith(String expected) {
        this.isNotNull();
        if (((String)this.actual).endsWith(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should end with:<%s>", this.actual, expected));
    }

    @Nonnull
    public StringAssert startsWith(String expected) {
        this.isNotNull();
        if (((String)this.actual).startsWith(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should start with:<%s>", this.actual, expected));
    }

    @Nonnull
    public StringAssert excludes(String s) {
        this.isNotNull();
        if (((String)this.actual).indexOf(s) == -1) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should not contain the String:<%s>", this.actual, s));
    }

    @Nonnull
    public StringAssert matches(String regex) {
        this.isNotNull();
        if (((String)this.actual).matches(regex)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should match the regular expression:<%s>", this.actual, regex));
    }

    @Nonnull
    public StringAssert doesNotMatch(String regex) {
        this.isNotNull();
        if (!((String)this.actual).matches(regex)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should not match the regular expression:<%s>", this.actual, regex));
    }

    @Nonnull
    public StringAssert containsIgnoringCase(@Nonnull String text) {
        Preconditions.checkNotNull(text);
        this.isNotNull();
        if (((String)this.actual).toLowerCase().contains(text.toLowerCase())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> does not contain <%s>", this.actual, text));
    }

    @Nonnull
    public StringAssert doesNotContain(@Nonnull String text) {
        Preconditions.checkNotNull(text);
        this.isNotNull();
        if (!((String)this.actual).contains(text)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> should not contain <%s>", this.actual, text));
    }
}

