/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

public class ObjectArrayAssert
extends ObjectGroupAssert<ObjectArrayAssert, Object[]> {
    protected ObjectArrayAssert(Object ... actual) {
        super(ObjectArrayAssert.class, actual);
    }

    @Nonnull
    public ObjectArrayAssert hasAllElementsOfType(@Nonnull Class<?> type) {
        Preconditions.checkNotNull(type);
        this.isNotNull();
        for (Object o : (Object[])this.actual) {
            if (type.isInstance(o)) continue;
            this.failIfCustomMessageIsSet();
            this.fail(Formatting.format("not all elements in array:<%s> belong to the type:<%s>", this.actual, type));
        }
        return this;
    }

    @Nonnull
    public ObjectArrayAssert hasAtLeastOneElementOfType(@Nonnull Class<?> type) {
        Preconditions.checkNotNull(type);
        this.isNotNull();
        boolean found = false;
        for (Object o : (Object[])this.actual) {
            if (!type.isInstance(o)) continue;
            found = true;
            break;
        }
        if (found) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("array:<%s> does not have any elements of type:<%s>", this.actual, type));
    }

    @Override
    @Nonnull
    public ObjectArrayAssert isEqualTo(@Nullable Object[] expected) {
        if (Arrays.deepEquals((Object[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    @Nonnull
    public ObjectArrayAssert isNotEqualTo(@Nullable Object[] array) {
        if (!Arrays.deepEquals((Object[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    @Override
    @Nonnull
    public ObjectArrayAssert onProperty(@Nonnull String propertyName) {
        this.isNotNull();
        if (((Object[])this.actual).length == 0) {
            return new ObjectArrayAssert(new Object[0]);
        }
        List<Object> values = PropertySupport.instance().propertyValues(propertyName, Lists.newArrayList((Object[])this.actual));
        return new ObjectArrayAssert(values.toArray());
    }

    @Override
    protected Set<Object> actualAsSet() {
        return this.actual == null ? null : Sets.newLinkedHashSet((Object[])this.actual);
    }

    @Override
    @Nullable
    protected List<Object> actualAsList() {
        return this.actual == null ? null : Lists.newArrayList((Object[])this.actual);
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Object[])this.actual).length;
    }
}

