/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Formatting;
import org.fest.assertions.Index;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.Lists;
import org.fest.util.Objects;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

public class ListAssert
extends ObjectGroupAssert<ListAssert, List<?>> {
    protected ListAssert(@Nullable List<?> actual) {
        super(ListAssert.class, actual);
    }

    @Nonnull
    public ListAssert contains(@Nullable Object o, @Nonnull Index index) {
        Object actualElement;
        Preconditions.checkNotNull(index);
        ((ListAssert)this.isNotNull()).isNotEmpty();
        int indexValue = index.value();
        int listSize = this.actualGroupSize();
        if (indexValue < 0 || indexValue >= listSize) {
            this.failIndexOutOfBounds(indexValue);
        }
        if (!Objects.areEqual(actualElement = ((List)this.actual).get(indexValue), o)) {
            this.failElementNotFound(o, actualElement, indexValue);
        }
        return this;
    }

    private void failElementNotFound(@Nullable Object e, @Nullable Object a, int index) {
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("expecting <%s> at index <%s> but found <%s>", e, index, a));
    }

    private void failIndexOutOfBounds(int index) {
        throw new IndexOutOfBoundsException(this.formattedErrorMessage(Formatting.format("The index <%s> should be greater than or equal to zero and less than %s", index, this.actualGroupSize())));
    }

    @Nonnull
    public ListAssert containsSequence(Object ... sequence) {
        this.isNotNull();
        Preconditions.checkNotNull(sequence);
        int sequenceSize = sequence.length;
        if (sequenceSize == 0) {
            return this;
        }
        int indexOfFirst = ((List)this.actual).indexOf(sequence[0]);
        if (indexOfFirst == -1) {
            this.failIfSequenceNotFound(sequence);
        }
        int listSize = this.actualGroupSize();
        for (int i = 0; i < sequenceSize; ++i) {
            int actualIndex = indexOfFirst + i;
            if (actualIndex > listSize - 1) {
                this.failIfSequenceNotFound(sequence);
            }
            if (Objects.areEqual(sequence[i], ((List)this.actual).get(actualIndex))) continue;
            this.failIfSequenceNotFound(sequence);
        }
        return this;
    }

    private void failIfSequenceNotFound(@Nonnull Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("list:<%s> does not contain the sequence:<%s>", this.actual, notFound));
    }

    @Nonnull
    public ListAssert startsWith(Object ... sequence) {
        this.isNotNull();
        Preconditions.checkNotNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotStartingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotStartingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            if (Objects.areEqual(sequence[i], ((List)this.actual).get(i))) continue;
            this.failIfNotStartingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotStartingWithSequence(@Nonnull Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("list:<%s> does not start with the sequence:<%s>", this.actual, notFound));
    }

    @Nonnull
    public ListAssert endsWith(Object ... sequence) {
        this.isNotNull();
        Preconditions.checkNotNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotEndingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotEndingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            int sequenceIndex = sequenceSize - 1 - i;
            int listIndex = listSize - 1 - i;
            if (Objects.areEqual(sequence[sequenceIndex], ((List)this.actual).get(listIndex))) continue;
            this.failIfNotEndingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotEndingWithSequence(@Nonnull Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("list:<%s> does not end with the sequence:<%s>", this.actual, notFound));
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((List)this.actual).size();
    }

    @Nonnull
    public ListAssert containsExactly(Object ... objects) {
        Preconditions.checkNotNull(objects);
        return (ListAssert)((ListAssert)this.isNotNull()).isEqualTo(Lists.newArrayList(objects));
    }

    @Override
    @Nonnull
    public ListAssert onProperty(@Nonnull String propertyName) {
        this.isNotNull();
        if (((List)this.actual).isEmpty()) {
            return new ListAssert(Collections.emptyList());
        }
        return new ListAssert(PropertySupport.instance().propertyValues(propertyName, (Collection)this.actual));
    }

    @Override
    @Nullable
    protected Set<Object> actualAsSet() {
        return this.actual == null ? null : Sets.newLinkedHashSet(((List)this.actual).toArray());
    }

    @Override
    @Nullable
    protected List<Object> actualAsList() {
        return this.actual == null ? null : Lists.newArrayList(((List)this.actual).toArray());
    }
}

