/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Collections;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

public abstract class ItemGroupAssert<S, A>
extends GroupAssert<S, A> {
    public ItemGroupAssert(@Nonnull Class<S> selfType, @Nullable A actual) {
        super(selfType, actual);
    }

    protected final void assertContains(Object ... objects) {
        this.isNotNull();
        Preconditions.checkNotNull(objects);
        Collection<Object> notFound = this.notFoundInActual(objects);
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failureIfExpectedElementsNotFound(notFound);
    }

    private Collection<Object> notFoundInActual(Object ... objects) {
        return Collections.notFound(this.actualAsSet(), objects);
    }

    protected final void assertContainsOnly(Object ... objects) {
        this.isNotNull();
        Preconditions.checkNotNull(objects);
        Set<Object> copy = this.actualAsSet();
        List<Object> notFound = this.notFoundInCopy(copy, Sets.newLinkedHashSet(objects));
        if (!notFound.isEmpty()) {
            throw this.failureIfExpectedElementsNotFound(notFound);
        }
        if (copy == null || copy.isEmpty()) {
            return;
        }
        throw this.failureIfUnexpectedElementsFound(copy);
    }

    @Nullable
    protected abstract Set<Object> actualAsSet();

    @Nonnull
    private List<Object> notFoundInCopy(@Nullable Set<Object> copy, @Nonnull Set<Object> objects) {
        if (copy == null) {
            return Lists.emptyList();
        }
        ArrayList<Object> notFound = Lists.newArrayList();
        for (Object o : objects) {
            if (!copy.contains(o)) {
                notFound.add(o);
                continue;
            }
            copy.remove(o);
        }
        return notFound;
    }

    @Nonnull
    private AssertionError failureIfExpectedElementsNotFound(@Nonnull Collection<Object> notFound) {
        this.failIfCustomMessageIsSet();
        return this.failure(Formatting.format("<%s> does not contain element(s):<%s>", this.actual, notFound));
    }

    @Nonnull
    private AssertionError failureIfUnexpectedElementsFound(@Nonnull Collection<Object> unexpected) {
        this.failIfCustomMessageIsSet();
        return this.failure(Formatting.format("unexpected element(s):<%s> in <%s>", unexpected, this.actual));
    }

    protected final void assertExcludes(Object ... objects) {
        this.isNotNull();
        Preconditions.checkNotNull(objects);
        Collection<Object> found = Collections.found(this.actualAsSet(), objects);
        if (found.isEmpty()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> does not exclude element(s):<%s>", this.actual, found));
    }

    protected final void assertDoesNotHaveDuplicates() {
        this.isNotNull();
        Collection<Object> duplicates = org.fest.util.Collections.duplicatesFrom(this.actualAsList());
        if (duplicates.isEmpty()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("<%s> contains duplicate(s):<%s>", this.actual, duplicates));
    }

    @Nullable
    protected abstract List<Object> actualAsList();
}

