/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Closeables;
import org.fest.util.Lists;
import org.fest.util.Objects;
import org.fest.util.Strings;

class FileContentComparator {
    private static final String EOF = "EOF";

    FileContentComparator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    LineDiff[] compareContents(@Nonnull File actual, @Nonnull File expected) throws IOException {
        LineDiff[] lineDiffArray;
        FileInputStream ais = null;
        FileInputStream eis = null;
        try {
            ais = new FileInputStream(actual);
            eis = new FileInputStream(expected);
            List<LineDiff> diffs = this.verifyEqualContent(this.readerFor(ais), this.readerFor(eis));
            lineDiffArray = diffs.toArray(new LineDiff[diffs.size()]);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(eis);
            Closeables.closeQuietly(ais);
            throw throwable;
        }
        Closeables.closeQuietly(eis);
        Closeables.closeQuietly(ais);
        return lineDiffArray;
    }

    @Nonnull
    private LineNumberReader readerFor(@Nonnull InputStream inputStream) {
        return new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
    }

    @Nonnull
    private List<LineDiff> verifyEqualContent(@Nonnull LineNumberReader actual, @Nonnull LineNumberReader expected) throws IOException {
        String actualLine;
        int lineNumber;
        ArrayList<LineDiff> diffs = Lists.newArrayList();
        while (true) {
            String expectedLine;
            if (!expected.ready() && !actual.ready()) {
                return diffs;
            }
            lineNumber = expected.getLineNumber();
            actualLine = actual.readLine();
            if (Objects.areEqual(actualLine, expectedLine = expected.readLine())) continue;
            diffs.add(LineDiff.lineDiff(lineNumber, actualLine, expectedLine));
            if (!actual.ready() && expected.ready()) {
                diffs.add(LineDiff.lineDiff(lineNumber, EOF, expectedLine));
                return diffs;
            }
            if (actual.ready() && !expected.ready()) break;
        }
        diffs.add(LineDiff.lineDiff(lineNumber, actualLine, EOF));
        return diffs;
    }

    static class LineDiff {
        final int lineNumber;
        final String actual;
        final String expected;

        private LineDiff(int lineNumber, @Nullable String actual, @Nullable String expected) {
            this.lineNumber = lineNumber;
            this.actual = actual;
            this.expected = expected;
        }

        static LineDiff lineDiff(int lineNumber, @Nullable String actual, @Nullable String expected) {
            return new LineDiff(lineNumber, actual, expected);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCodeFor(this.actual);
            result = 31 * result + Objects.hashCodeFor(this.expected);
            result = 31 * result + this.lineNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineDiff other = (LineDiff)obj;
            if (!Objects.areEqual(this.actual, other.actual)) {
                return false;
            }
            if (!Objects.areEqual(this.expected, other.expected)) {
                return false;
            }
            return this.lineNumber == other.lineNumber;
        }

        public String toString() {
            return String.format("LineDiff [actual=%s, expected=%s, lineNumber=%d]", Strings.quote(this.actual), Strings.quote(this.expected), this.lineNumber);
        }
    }
}

