/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Delta;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.util.Preconditions;

public class DoubleArrayAssert
extends ArrayAssert<DoubleArrayAssert, double[]> {
    protected DoubleArrayAssert(double ... actual) {
        super(DoubleArrayAssert.class, actual);
    }

    @Nonnull
    public DoubleArrayAssert contains(double ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public DoubleArrayAssert containsOnly(double ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public DoubleArrayAssert excludes(double ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    @Nonnull
    public DoubleArrayAssert isEqualTo(@Nullable double[] expected) {
        if (Arrays.equals((double[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Nonnull
    public DoubleArrayAssert isEqualTo(@Nullable double[] expected, @Nonnull Delta delta) {
        Preconditions.checkNotNull(delta);
        if (this.actual == expected) {
            return this;
        }
        if (this.actual == null || expected == null) {
            throw this.failureWhenNotEqual(expected, delta);
        }
        int length = expected.length;
        if (((double[])this.actual).length != length) {
            this.failureWhenNotEqual(expected, delta);
        }
        for (int i = 0; i < length; ++i) {
            if (this.equals(expected[i], ((double[])this.actual)[i], delta)) continue;
            this.failureWhenNotEqual(expected, delta);
        }
        return this;
    }

    @Nonnull
    private AssertionError failureWhenNotEqual(@Nullable double[] expected, @Nonnull Delta delta) {
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected) + Formatting.format(" using delta:<%s>", delta.doubleValue()));
    }

    private boolean equals(double e, double a, @Nonnull Delta delta) {
        if (Double.compare(e, a) == 0) {
            return true;
        }
        return Math.abs(e - a) <= delta.doubleValue();
    }

    @Override
    @Nonnull
    public DoubleArrayAssert isNotEqualTo(@Nullable double[] array) {
        if (!Arrays.equals((double[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

