/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.fest.util.Preconditions;

class ConstructorInvoker {
    private static Logger logger = Logger.getLogger(ConstructorInvoker.class.getCanonicalName());

    ConstructorInvoker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Object newInstance(@Nonnull String className, @Nonnull Class<?>[] parameterTypes, @Nonnull Object[] parameterValues) throws Exception {
        Preconditions.checkNotNullOrEmpty(className);
        Preconditions.checkNotNull(parameterTypes);
        Preconditions.checkNotNull(parameterValues);
        Class<?> targetType = Class.forName(className);
        Constructor<?> constructor = targetType.getConstructor(parameterTypes);
        boolean accessible = constructor.isAccessible();
        try {
            this.setAccessible(constructor, true);
            Object obj = constructor.newInstance(parameterValues);
            return obj;
        }
        finally {
            try {
                this.setAccessible(constructor, accessible);
            }
            catch (RuntimeException e) {
                logger.log(Level.SEVERE, "Failed to set 'accessible' flag back to " + accessible, e);
            }
        }
    }

    private void setAccessible(@Nonnull AccessibleObject accessible, boolean value) {
        AccessController.doPrivileged(new SetAccessibleValueAction(accessible, value));
    }

    private static class SetAccessibleValueAction
    implements PrivilegedAction<Void> {
        private final AccessibleObject accessible;
        private final boolean value;

        private SetAccessibleValueAction(@Nonnull AccessibleObject accessible, boolean value) {
            this.accessible = Preconditions.checkNotNull(accessible);
            this.value = value;
        }

        @Override
        public Void run() {
            this.accessible.setAccessible(this.value);
            return null;
        }
    }
}

