/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public abstract class Condition<T> {
    private String description;

    public Condition() {
    }

    public Condition(@Nullable String description) {
        this.as(description);
    }

    @Nonnull
    public final Condition<T> as(@Nullable String newDescription) {
        this.description = newDescription;
        return this;
    }

    @Nonnull
    final String addDescriptionTo(@Nonnull String s) {
        Preconditions.checkNotNull(s);
        String descriptionToAdd = this.description();
        if (Strings.isNullOrEmpty(descriptionToAdd)) {
            descriptionToAdd = this.getClass().getSimpleName();
        }
        return String.format("%s:<%s>", s, descriptionToAdd);
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public abstract boolean matches(@Nullable T var1);
}

