/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ConstructorInvoker;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.ToString;

public final class ComparisonFailureFactory {
    private static final String EMPTY_MESSAGE = "";
    private static ConstructorInvoker constructorInvoker = new ConstructorInvoker();

    private ComparisonFailureFactory() {
    }

    static void constructorInvoker(@Nonnull ConstructorInvoker newConstructorInvoker) {
        constructorInvoker = Preconditions.checkNotNull(newConstructorInvoker);
    }

    @Nullable
    public static AssertionError comparisonFailure(@Nullable String message, @Nullable Object expected, @Nullable Object actual) {
        try {
            return ComparisonFailureFactory.newComparisonFailure(ComparisonFailureFactory.clean(message), expected, actual);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nonnull
    private static String clean(@Nullable String message) {
        return message == null ? EMPTY_MESSAGE : message;
    }

    @Nullable
    private static AssertionError newComparisonFailure(@Nullable String message, @Nullable Object expected, @Nullable Object actual) throws Exception {
        String className = "org.junit.ComparisonFailure";
        Class[] parameterTypes = new Class[]{String.class, String.class, String.class};
        Object[] parameterValues = new Object[]{ComparisonFailureFactory.format(message), ComparisonFailureFactory.asString(expected), ComparisonFailureFactory.asString(actual)};
        Object o = constructorInvoker.newInstance(className, parameterTypes, parameterValues);
        if (o instanceof AssertionError) {
            return (AssertionError)o;
        }
        return null;
    }

    @Nullable
    private static String asString(@Nullable Object o) {
        if (o instanceof String) {
            return Strings.quote((String)o);
        }
        if (o == null) {
            return null;
        }
        return ToString.toStringOf(o);
    }

    @Nonnull
    private static String format(@Nullable String message) {
        if (Strings.isNullOrEmpty(message)) {
            return EMPTY_MESSAGE;
        }
        return String.format("[%s]", message);
    }
}

