/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.rt.coverage.instrumentation.ExtraFieldInstrumenter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.CheckSumCalculator;
import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsCollector;
import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsFilter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.SourceFilesCollector;
import java.util.Collections;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class TestDiscoveryInstrumenter
extends ExtraFieldInstrumenter {
    private final String myClassName;
    int myClassVersion;
    private final InstrumentedMethodsFilter myMethodFilter;
    volatile boolean myInstrumentConstructors;
    private int myCurrentMethodCount;
    static final String METHODS_VISITED = "__$methodsVisited$__";
    static final String METHODS_VISITED_CLASS = "[Z";
    private static final String METHODS_VISITED_INIT = "__$initMethodsVisited$__";
    private final String[] myMethodNames;

    public TestDiscoveryInstrumenter(ClassWriter classWriter, ClassReader cr, String className) {
        super(cr, classWriter, className, METHODS_VISITED, METHODS_VISITED_CLASS, METHODS_VISITED_INIT, false);
        this.myMethodFilter = new InstrumentedMethodsFilter(className);
        this.myClassName = className;
        this.myMethodNames = this.inspectClass(cr);
    }

    private String[] inspectClass(ClassReader cr) {
        CheckSumCalculator checksumCalculator = new CheckSumCalculator(this.api, this.myClassName);
        SourceFilesCollector sourceFilesCollector = new SourceFilesCollector(this.api, checksumCalculator, this.myClassName);
        InstrumentedMethodsCollector methodCollector = new InstrumentedMethodsCollector(this.api, sourceFilesCollector, this, this.myClassName);
        cr.accept(methodCollector, 0);
        TestDiscoveryProjectData.getProjectData().addClassMetadata(Collections.singletonList(new ClassMetadata(this.myClassName, sourceFilesCollector.getSources(), checksumCalculator.getChecksums())));
        return methodCollector.instrumentedMethods();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myMethodFilter.visit(version, access, name, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        if (this.myMethodNames.length == 0) {
            return mv;
        }
        if ("<clinit>".equals(name)) {
            return this.createMethodVisitor(mv, mv, name);
        }
        InstrumentedMethodsFilter.Decision decision = this.myMethodFilter.shouldVisitMethod(access, name, desc, signature, exceptions, this.myInstrumentConstructors);
        if (decision != InstrumentedMethodsFilter.Decision.YES) {
            return mv;
        }
        MethodVisitor newMv = new MethodVisitor(589824, mv){
            final int myMethodId;
            {
                this.myMethodId = TestDiscoveryInstrumenter.this.myCurrentMethodCount++;
            }

            public void visitCode() {
                this.mv.visitFieldInsn(178, TestDiscoveryInstrumenter.this.getInternalClassName(), TestDiscoveryInstrumenter.METHODS_VISITED, TestDiscoveryInstrumenter.METHODS_VISITED_CLASS);
                TestDiscoveryInstrumenter.pushInstruction(this, this.myMethodId);
                this.visitInsn(4);
                this.visitInsn(84);
                super.visitCode();
            }
        };
        return this.createMethodVisitor(mv, newMv, name);
    }

    public void visitEnd() {
        if (this.myMethodNames.length > 0) {
            this.generateMembers();
        }
        super.visitEnd();
    }

    public void initField(MethodVisitor mv) {
        mv.visitLdcInsn(this.myClassName);
        TestDiscoveryInstrumenter.pushInstruction(mv, this.myMethodNames.length);
        mv.visitIntInsn(188, 4);
        TestDiscoveryInstrumenter.pushInstruction(mv, this.myMethodNames.length);
        mv.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < this.myMethodNames.length; ++i) {
            mv.visitInsn(89);
            TestDiscoveryInstrumenter.pushInstruction(mv, i);
            mv.visitLdcInsn(this.myMethodNames[i]);
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/TestDiscoveryProjectData", "trace", "(Ljava/lang/String;[Z[Ljava/lang/String;)[Z", false);
        mv.visitFieldInsn(179, this.getInternalClassName(), METHODS_VISITED, METHODS_VISITED_CLASS);
    }

    private static void pushInstruction(MethodVisitor mv, int operand) {
        if (operand < 127) {
            mv.visitIntInsn(16, operand);
        } else {
            mv.visitIntInsn(17, operand);
        }
    }
}

