/*
 * Decompiled with CFR 0.152.
 */
package training.ui.views;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.statistic.StatisticBase;
import training.ui.LearnToolWindow;
import training.ui.LessonMessagePane;
import training.ui.MessageFactory;
import training.ui.MessagePart;
import training.ui.UISettings;
import training.ui.views.LearnPanel;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001:\u0001LB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#J\u001e\u0010$\u001a\u00020\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\b\b\u0002\u0010\"\u001a\u00020#J\b\u0010(\u001a\u00020\u001fH\u0002J\b\u0010)\u001a\u00020\u001fH\u0002J\u0006\u0010*\u001a\u00020\u001fJ\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020\u001fJ\b\u00100\u001a\u00020!H\u0003J\u0010\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u001fH\u0002J\u0006\u00105\u001a\u00020\u001fJ\u0006\u00106\u001a\u00020\u001dJ\u000e\u00107\u001a\u00020\u001f2\u0006\u00102\u001a\u000203J\u000e\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u001dJ\u000e\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\u001dJ\u000e\u0010<\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u001dJ\u0012\u0010=\u001a\u00020\u001f2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002J\u0010\u0010@\u001a\u00020\u001f2\b\b\u0001\u0010A\u001a\u00020!J\u0010\u0010B\u001a\u00020\u001f2\b\b\u0001\u0010C\u001a\u00020!J\u0006\u0010D\u001a\u00020\u001fJ$\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u00142\b\u0010G\u001a\u0004\u0018\u0001032\b\b\u0001\u0010H\u001a\u00020!H\u0002J\b\u0010I\u001a\u00020\u001fH\u0002J\u000e\u0010J\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020\u001dR\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Ltraining/ui/views/LearnPanel;", "Ljavax/swing/JPanel;", "learnToolWindow", "Ltraining/ui/LearnToolWindow;", "(Ltraining/ui/LearnToolWindow;)V", "buttonPanel", "footer", "getLearnToolWindow", "()Ltraining/ui/LearnToolWindow;", "lessonMessagePane", "Ltraining/ui/LessonMessagePane;", "getLessonMessagePane", "()Ltraining/ui/LessonMessagePane;", "lessonNameLabel", "Ljavax/swing/JLabel;", "lessonPanel", "lessonPanelBoxLayout", "Ljavax/swing/BoxLayout;", "moduleNameLabel", "nextButton", "Ljavax/swing/JButton;", "prevButton", "scrollToNewMessages", "", "getScrollToNewMessages$intellij_featuresTrainer", "()Z", "setScrollToNewMessages$intellij_featuresTrainer", "(Z)V", "sideOffsetBeforeScaling", "", "addMessage", "", "text", "", "properties", "Ltraining/ui/LessonMessagePane$MessageProperties;", "addMessages", "messageParts", "", "Ltraining/ui/MessagePart;", "adjustMessagesArea", "clearMessages", "clearRestoreMessage", "createHeaderPanel", "Lcom/intellij/ui/components/panels/VerticalBox;", "createSmallSeparator", "Ljava/awt/Component;", "focusCurrentMessage", "getNextLessonKeyStrokeText", "initFooterPanel", "lesson", "Ltraining/learn/course/Lesson;", "initLessonPanel", "makeNextButtonSelected", "messagesNumber", "reinitMe", "removeInactiveMessages", "number", "removeMessage", "index", "resetMessagesNumber", "scrollToMessage", "needToShow", "Ljava/awt/Rectangle;", "setLessonName", "lessonName", "setModuleName", "moduleName", "setPreviousMessagesPassed", "updateButton", "button", "targetLesson", "buttonText", "updateNavigationButtons", "updatePanelSize", "viewAreaWidth", "LinkLabelWithBackArrow", "intellij.featuresTrainer"})
public final class LearnPanel
extends JPanel {
    private final int sideOffsetBeforeScaling;
    private final JPanel lessonPanel;
    private final JLabel moduleNameLabel;
    private final JLabel lessonNameLabel;
    @NotNull
    private final LessonMessagePane lessonMessagePane;
    private final JPanel buttonPanel;
    private final JButton nextButton;
    private final JButton prevButton;
    private final JPanel footer;
    private final BoxLayout lessonPanelBoxLayout;
    private boolean scrollToNewMessages;
    @NotNull
    private final LearnToolWindow learnToolWindow;

    @NotNull
    public final LessonMessagePane getLessonMessagePane() {
        return this.lessonMessagePane;
    }

    public final boolean getScrollToNewMessages$intellij_featuresTrainer() {
        return this.scrollToNewMessages;
    }

    public final void setScrollToNewMessages$intellij_featuresTrainer(boolean bl) {
        this.scrollToNewMessages = bl;
    }

    public final void reinitMe(@NotNull Lesson lesson) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        Object object = UISettings.Companion.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        UISettings $this$with = object;
        boolean bl3 = false;
        this.setBorder(new EmptyBorder($this$with.getNorthInset(), JBUI.scale((int)this.sideOffsetBeforeScaling), $this$with.getSouthInset(), JBUI.scale((int)this.sideOffsetBeforeScaling)));
        this.scrollToNewMessages = true;
        this.clearMessages();
        this.footer.removeAll();
        this.lessonPanel.removeAll();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.initLessonPanel();
        this.lessonPanel.setAlignmentX(0.0f);
        this.add((Component)this.lessonPanel, "Center");
        object = lesson.getHelpLinks();
        bl = false;
        if (!object.isEmpty() && Registry.is((String)"ift.help.links", (boolean)false)) {
            this.initFooterPanel(lesson);
            this.add((Component)this.footer, "Last");
        }
    }

    public final void updatePanelSize(int viewAreaWidth) {
        int n = UISettings.Companion.getInstance().getPanelWidth();
        boolean bl = false;
        int width = Math.max(n, viewAreaWidth) - 2 * this.sideOffsetBeforeScaling;
        this.lessonMessagePane.setPreferredSize(null);
        this.lessonMessagePane.setBounds(0, 0, width, 10000);
        this.lessonMessagePane.revalidate();
        this.lessonMessagePane.repaint();
        this.lessonMessagePane.setPreferredSize(new Dimension(width, this.lessonMessagePane.getPreferredSize().height));
        this.lessonPanel.revalidate();
        this.lessonPanel.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private final void initFooterPanel(Lesson lesson) {
        void it22;
        JPanel shiftedFooter = new JPanel();
        shiftedFooter.setName("footerLessonPanel");
        shiftedFooter.setLayout(new BoxLayout(shiftedFooter, 1));
        shiftedFooter.setFocusable(false);
        shiftedFooter.setOpaque(false);
        shiftedFooter.setBorder(new MatteBorder(JBUI.scale((int)1), 0, 0, 0, UISettings.Companion.getInstance().getSeparatorColor()));
        JPanel footerContent = new JPanel();
        footerContent.setOpaque(false);
        footerContent.setLayout((LayoutManager)new VerticalLayout(5));
        JLabel jLabel = new JLabel(IdeBundle.message((String)"welcome.screen.learnIde.help.and.resources.text", (Object[])new Object[0]));
        boolean bl = false;
        boolean bl2 = false;
        JLabel jLabel2 = jLabel;
        JPanel jPanel = footerContent;
        boolean bl3 = false;
        it22.setFont(UISettings.Companion.getInstance().getFont(1).deriveFont(1));
        Unit unit = Unit.INSTANCE;
        jPanel.add(jLabel);
        Map<String, String> map = lesson.getHelpLinks();
        boolean it22 = false;
        for (Map.Entry<String, String> helpLink : map.entrySet()) {
            String text2 = helpLink.getKey();
            String link = helpLink.getValue();
            LinkLabel linkLabel2 = new LinkLabel(text2, null, new LinkListener(link){
                final /* synthetic */ String $link;

                public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                    UtilsKt.openLinkInBrowser(this.$link);
                }
                {
                    this.$link = string;
                }
            });
            footerContent.add(UtilsKt.wrapWithUrlPanel((LinkLabel<Object>)linkLabel2));
        }
        shiftedFooter.add(footerContent);
        shiftedFooter.add(Box.createHorizontalGlue());
        this.footer.add(shiftedFooter);
        this.footer.setOpaque(false);
        this.footer.setLayout(new BoxLayout(this.footer, 1));
        this.footer.setBorder(UISettings.Companion.getInstance().getCheckmarkShiftBorder());
    }

    private final void initLessonPanel() {
        this.lessonPanel.setName("lessonPanel");
        this.lessonPanel.setLayout(this.lessonPanelBoxLayout);
        this.lessonPanel.setFocusable(false);
        this.lessonPanel.setOpaque(false);
        this.moduleNameLabel.setName("moduleNameLabel");
        this.moduleNameLabel.setFont(UISettings.Companion.getInstance().getFont(1));
        this.moduleNameLabel.setFocusable(false);
        this.lessonNameLabel.setName("lessonNameLabel");
        this.lessonNameLabel.setBorder(UISettings.Companion.getInstance().getLessonHeaderBorder());
        this.lessonNameLabel.setFont(UISettings.Companion.getInstance().getFont(5).deriveFont(1));
        this.lessonNameLabel.setAlignmentX(0.0f);
        this.lessonNameLabel.setFocusable(false);
        this.lessonMessagePane.setName("lessonMessagePane");
        this.lessonMessagePane.setFocusable(false);
        this.lessonMessagePane.setOpaque(false);
        this.lessonMessagePane.setAlignmentX(0.0f);
        this.lessonMessagePane.setMargin((Insets)JBUI.emptyInsets());
        this.lessonMessagePane.setBorder(new EmptyBorder(0, 0, JBUI.scale((int)20), JBUI.scale((int)14)));
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new JButton[]{this.nextButton, this.prevButton});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JButton it = (JButton)element$iv;
            boolean bl = false;
            it.setMargin((Insets)JBUI.emptyInsets());
            it.setFocusable(false);
            it.setVisible(true);
            it.setEnabled(true);
            it.setOpaque(false);
        }
        this.buttonPanel.setName("buttonPanel");
        this.buttonPanel.setBorder(new EmptyBorder(0, UISettings.Companion.getInstance().getCheckIndent() - new JButton().getInsets().left, 0, 0));
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setFocusable(false);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setAlignmentX(0.0f);
        this.updateNavigationButtons();
        this.lessonPanel.add((Component)this.createHeaderPanel());
        int rigidWidth = JBUI.scale((int)(UISettings.Companion.getInstance().getPanelWidth() - 2 * this.sideOffsetBeforeScaling));
        Component component2 = Box.createRigidArea(new Dimension(rigidWidth, JBUI.scale((int)19)));
        if (component2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        JComponent jComponent = (JComponent)component2;
        boolean bl = false;
        boolean bl2 = false;
        Object it = jComponent;
        boolean bl3 = false;
        ((JComponent)it).setAlignmentX(0.0f);
        JComponent rigid = jComponent;
        this.lessonPanel.add(rigid);
        this.lessonPanel.add(this.lessonNameLabel);
        this.lessonPanel.add(this.lessonMessagePane);
        this.lessonPanel.add(this.buttonPanel);
        this.lessonPanel.add(Box.createVerticalGlue());
    }

    private final VerticalBox createHeaderPanel() {
        JPanel linksPanel = new JPanel();
        linksPanel.setOpaque(false);
        linksPanel.setLayout(new BoxLayout(linksPanel, 0));
        linksPanel.setAlignmentX(0.0f);
        linksPanel.setBorder(new EmptyBorder(0, 0, JBUI.scale((int)12), 0));
        linksPanel.add(this.moduleNameLabel);
        if (UtilsKt.findLanguageSupport(this.learnToolWindow.getProject()) != null) {
            linksPanel.add(Box.createHorizontalGlue());
            JLabel exitLink = new JLabel(LearnBundle.INSTANCE.message("exit.learning.link", new Object[0]), AllIcons.Actions.Exit, 10);
            exitLink.setCursor(Cursor.getPredefinedCursor(12));
            exitLink.addMouseListener(new MouseAdapter(){

                public void mouseClicked(@NotNull MouseEvent e) {
                    AnAction action2;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!StatisticBase.Companion.isLearnProjectCloseLogged()) {
                        StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.EXIT_LINK);
                    }
                    AnAction anAction = action2 = ActionManager.getInstance().getAction("CloseProject");
                    Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"action");
                    UtilsKt.invokeActionForFocusContext(anAction);
                }
            });
            linksPanel.add(exitLink);
        }
        VerticalBox headerPanel = new VerticalBox();
        headerPanel.setOpaque(false);
        headerPanel.setAlignmentX(0.0f);
        headerPanel.setBorder(UISettings.Companion.getInstance().getLessonHeaderBorder());
        headerPanel.add((Component)linksPanel);
        headerPanel.add(this.createSmallSeparator());
        return headerPanel;
    }

    public final void setLessonName(@Nls @NotNull String lessonName) {
        Intrinsics.checkNotNullParameter((Object)lessonName, (String)"lessonName");
        this.lessonNameLabel.setText(lessonName);
        this.lessonNameLabel.setForeground(UISettings.Companion.getInstance().getDefaultTextColor());
        this.lessonNameLabel.setFocusable(false);
        this.revalidate();
        this.repaint();
    }

    public final void setModuleName(@Nls @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this.moduleNameLabel.setText("    " + moduleName);
        this.moduleNameLabel.setForeground(UISettings.Companion.getInstance().getDefaultTextColor());
        this.moduleNameLabel.setFocusable(false);
        this.revalidate();
        this.repaint();
    }

    public final void addMessage(@Language(value="HTML") @NotNull String text2, @NotNull LessonMessagePane.MessageProperties properties) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        List<MessagePart> messages = MessageFactory.INSTANCE.convert(text2);
        MessageFactory.INSTANCE.setLinksHandlers(this.learnToolWindow.getProject(), messages);
        this.addMessages(messages, properties);
    }

    public static /* synthetic */ void addMessage$default(LearnPanel learnPanel, String string, LessonMessagePane.MessageProperties messageProperties, int n, Object object) {
        if ((n & 2) != 0) {
            messageProperties = new LessonMessagePane.MessageProperties(null, null, false, null, 15, null);
        }
        learnPanel.addMessage(string, messageProperties);
    }

    public final void addMessages(@NotNull List<MessagePart> messageParts, @NotNull LessonMessagePane.MessageProperties properties) {
        Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Function0<Rectangle> needToShow = this.lessonMessagePane.addMessage(messageParts, properties);
        this.adjustMessagesArea();
        if (properties.getState() != LessonMessagePane.MessageState.INACTIVE) {
            this.scrollToMessage((Rectangle)needToShow.invoke());
        }
    }

    public static /* synthetic */ void addMessages$default(LearnPanel learnPanel, List list2, LessonMessagePane.MessageProperties messageProperties, int n, Object object) {
        if ((n & 2) != 0) {
            messageProperties = new LessonMessagePane.MessageProperties(null, null, false, null, 15, null);
        }
        learnPanel.addMessages(list2, messageProperties);
    }

    public final void focusCurrentMessage() {
        this.scrollToMessage(this.lessonMessagePane.getCurrentMessageRectangle());
    }

    private final void scrollToMessage(Rectangle needToShow) {
        if (needToShow == null) {
            return;
        }
        int y = needToShow.y + this.lessonMessagePane.getBounds().y + this.lessonPanel.getBounds().y;
        if (this.scrollToNewMessages) {
            this.adjustMessagesArea();
            Rectangle rectangle = this.getVisibleRect();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"visibleRect");
            Dimension visibleSize = rectangle.getSize();
            int n = 0;
            int n2 = y - visibleSize.height / 2;
            boolean bl = false;
            int needToScroll = Math.max(n, n2);
            this.learnToolWindow.scrollTo$intellij_featuresTrainer(needToScroll);
        }
    }

    private final void adjustMessagesArea() {
        this.updatePanelSize(this.learnToolWindow.getVisibleAreaWidth());
        this.revalidate();
        this.repaint();
    }

    public final void resetMessagesNumber(int number) {
        Function0<Rectangle> needToShow = this.lessonMessagePane.resetMessagesNumber(number);
        this.adjustMessagesArea();
        this.scrollToMessage((Rectangle)needToShow.invoke());
    }

    public final void removeInactiveMessages(int number) {
        this.lessonMessagePane.removeInactiveMessages(number);
        this.adjustMessagesArea();
    }

    public final int messagesNumber() {
        return this.lessonMessagePane.messagesNumber();
    }

    public final void setPreviousMessagesPassed() {
        this.lessonMessagePane.passPreviousMessages();
        this.adjustMessagesArea();
    }

    private final void clearMessages() {
        this.lessonNameLabel.setIcon(null);
        this.lessonMessagePane.clear();
    }

    private final void updateNavigationButtons() {
        this.buttonPanel.removeAll();
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(null);
        }
        this.updateButton(this.prevButton, UtilsKt.getPreviousLessonForCurrent(), LearnBundle.INSTANCE.message("learn.new.ui.button.back", new Object[0]));
        Lesson nextLesson = UtilsKt.getNextLessonForCurrent();
        Object[] objectArray = new Object[1];
        Object object = nextLesson;
        if (object == null || (object = ((Lesson)object).getName()) == null) {
            object = "";
        }
        objectArray[0] = object;
        this.updateButton(this.nextButton, nextLesson, LearnBundle.INSTANCE.message("learn.new.ui.button.next", objectArray));
    }

    private final void updateButton(JButton button2, Lesson targetLesson, @Nls String buttonText) {
        button2.setVisible(targetLesson != null);
        if (targetLesson != null) {
            button2.setAction(new AbstractAction(this, targetLesson){
                final /* synthetic */ LearnPanel this$0;
                final /* synthetic */ Lesson $targetLesson;

                public void actionPerformed(@NotNull ActionEvent actionEvent) {
                    Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
                    StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.OPEN_NEXT_OR_PREV_LESSON);
                    CourseManager.openLesson$default(CourseManager.Companion.getInstance(), this.this$0.getLearnToolWindow().getProject(), this.$targetLesson, false, 4, null);
                }
                {
                    this.this$0 = this$0;
                    this.$targetLesson = $captured_local_variable$1;
                }
            });
            button2.setText(buttonText);
            button2.updateUI();
            button2.setSelected(true);
            if (!targetLesson.getPassed$intellij_featuresTrainer() && !targetLesson.getProperties().getCanStartInDumbMode()) {
                DumbService dumbService = DumbService.getInstance((Project)this.learnToolWindow.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(learnToolWindow.project)");
                if (dumbService.isDumb()) {
                    button2.setEnabled(false);
                    button2.setToolTipText(LearnBundle.INSTANCE.message("indexing.message", new Object[0]));
                    button2.setSelected(false);
                    DumbService.getInstance((Project)this.learnToolWindow.getProject()).runWhenSmart(new Runnable(button2){
                        final /* synthetic */ JButton $button;

                        public final void run() {
                            this.$button.setEnabled(true);
                            this.$button.setToolTipText("");
                            this.$button.setSelected(true);
                        }
                        {
                            this.$button = jButton;
                        }
                    });
                }
            }
            this.buttonPanel.add(button2);
        }
    }

    @NlsSafe
    private final String getNextLessonKeyStrokeText() {
        return "Enter";
    }

    public final void makeNextButtonSelected() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(this.nextButton);
        }
        this.nextButton.setSelected(true);
        this.nextButton.setFocusable(true);
        this.nextButton.requestFocus();
        if (this.scrollToNewMessages) {
            this.adjustMessagesArea();
            this.learnToolWindow.scrollToTheEnd$intellij_featuresTrainer();
        }
    }

    public final void clearRestoreMessage() {
        Function0<Rectangle> needToShow = this.lessonMessagePane.clearRestoreMessages();
        this.scrollToMessage((Rectangle)needToShow.invoke());
    }

    public final void removeMessage(int index) {
        this.lessonMessagePane.removeMessage(index);
    }

    private final Component createSmallSeparator() {
        JPanel separatorPanel = new JPanel();
        separatorPanel.setOpaque(false);
        separatorPanel.setLayout(new BoxLayout(separatorPanel, 0));
        separatorPanel.add(Box.createHorizontalGlue());
        separatorPanel.setBorder(new MatteBorder(0, 0, JBUI.scale((int)1), 0, UISettings.Companion.getInstance().getSeparatorColor()));
        return separatorPanel;
    }

    @NotNull
    public final LearnToolWindow getLearnToolWindow() {
        return this.learnToolWindow;
    }

    public LearnPanel(@NotNull LearnToolWindow learnToolWindow) {
        Intrinsics.checkNotNullParameter((Object)((Object)learnToolWindow), (String)"learnToolWindow");
        this.learnToolWindow = learnToolWindow;
        this.sideOffsetBeforeScaling = 18;
        this.lessonPanel = new JPanel();
        this.moduleNameLabel = (JLabel)((Object)new LinkLabelWithBackArrow(moduleNameLabel.1.INSTANCE));
        this.lessonNameLabel = new JLabel();
        this.lessonMessagePane = new LessonMessagePane(false, 1, null);
        this.buttonPanel = new JPanel();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.footer = new JPanel();
        this.lessonPanelBoxLayout = new BoxLayout(this.lessonPanel, 1);
        this.scrollToNewMessages = true;
        this.setFocusable(false);
        this.setBackground(UISettings.Companion.getInstance().getBackgroundColor());
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Ltraining/ui/views/LearnPanel$LinkLabelWithBackArrow;", "T", "Lcom/intellij/ui/components/labels/LinkLabel;", "linkListener", "Lcom/intellij/ui/components/labels/LinkListener;", "(Lcom/intellij/ui/components/labels/LinkListener;)V", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.featuresTrainer"})
    public static final class LinkLabelWithBackArrow<T>
    extends LinkLabel<T> {
        public void paint(@Nullable Graphics g) {
            super.paint(g);
            int arrowWingHeight = this.getTextBounds().height / 4;
            Graphics graphics = g;
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = this.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
            Stroke stroke3 = new BasicStroke(1.2f * (float)font.getSize() / (float)13, 1, 1);
            g2d.setStroke(stroke3);
            g2d.setColor(this.getForeground());
            g2d.drawLine(this.getTextBounds().x, this.getTextBounds().y + this.getTextBounds().height / 2, this.getTextBounds().x + 5 * this.getTextBounds().height / 17, this.getTextBounds().y + this.getTextBounds().height / 2 - arrowWingHeight);
            g2d.drawLine(this.getTextBounds().x, this.getTextBounds().y + this.getTextBounds().height / 2, this.getTextBounds().x + 9 * this.getTextBounds().height / 17, this.getTextBounds().y + this.getTextBounds().height / 2);
            g2d.drawLine(this.getTextBounds().x, this.getTextBounds().y + this.getTextBounds().height / 2, this.getTextBounds().x + 5 * this.getTextBounds().height / 17, this.getTextBounds().y + this.getTextBounds().height / 2 + arrowWingHeight);
        }

        public LinkLabelWithBackArrow(@NotNull LinkListener<T> linkListener) {
            Intrinsics.checkNotNullParameter(linkListener, (String)"linkListener");
            super("", null, linkListener);
            this.setFont(UIUtil.getLabelFont());
        }
    }
}

