/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WatermarkIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.FeaturesTrainerIcons;
import training.dsl.TaskTextProperties;
import training.learn.lesson.LessonManager;
import training.ui.ActionKeyPopupKt;
import training.ui.LearningUiManager;
import training.ui.LessonMessagePane;
import training.ui.LessonMessagePane$WhenMappings;
import training.ui.MessagePart;
import training.ui.UISettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u0085\u00012\u00020\u0001:\f\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\b\b\u0002\u00101\u001a\u000202J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002042\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002042\u0006\u00109\u001a\u000200H\u0002J\u0010\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0002J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00120/H\u0002J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\u0006H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010%2\u0006\u0010C\u001a\u000200H\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010%2\u0006\u0010C\u001a\u000200H\u0002J\u0006\u0010E\u001a\u000204J\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0,J,\u0010G\u001a\u0002042\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u00122\u0006\u0010I\u001a\u00020\u00122\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u0016H\u0002JC\u0010M\u001a\u0002042\u0006\u0010N\u001a\u0002002\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u00162!\u0010O\u001a\u001d\u0012\u0013\u0012\u00110Q\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(T\u0012\u0004\u0012\u0002040PH\u0002J\u0010\u0010U\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0002J\n\u0010V\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010W\u001a\u0004\u0018\u00010-J\u0010\u0010X\u001a\u00020Y2\u0006\u00106\u001a\u000207H\u0002J\b\u0010Z\u001a\u00020[H\u0016J\u0018\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\u0006\u0010;\u001a\u00020<H\u0002J\u0012\u0010`\u001a\u0004\u0018\u00010%2\u0006\u0010a\u001a\u00020bH\u0002J\u0012\u0010c\u001a\u0004\u0018\u00010-2\u0006\u0010d\u001a\u00020\u0012H\u0002J\b\u0010e\u001a\u000204H\u0002J\u0018\u0010f\u001a\u0002042\u0006\u0010g\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020hH\u0002J \u0010i\u001a\u00020\u00142\u0006\u0010j\u001a\u00020_2\u0006\u0010;\u001a\u00020K2\u0006\u0010k\u001a\u00020\u001dH\u0002J\u0006\u0010l\u001a\u00020\u0014J\u0010\u0010m\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010n\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010o\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0002J\u0006\u0010p\u001a\u000204J\u0006\u0010q\u001a\u000204J\u000e\u0010r\u001a\u0002042\u0006\u0010s\u001a\u00020\u0014J\u000e\u0010t\u001a\u0002042\u0006\u0010u\u001a\u00020\u0014J&\u0010v\u001a\u0002042\u0006\u0010w\u001a\u00020\u00142\u0006\u0010x\u001a\u00020\u00142\f\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0016\u0010z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0,2\u0006\u0010s\u001a\u00020\u0014J\u0010\u0010{\u001a\u0002042\u0006\u0010A\u001a\u00020\u0006H\u0002J\u0010\u0010|\u001a\u0002042\u0006\u0010d\u001a\u00020\u0012H\u0002J$\u0010}\u001a\u0002042\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020\u00142\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010\u0082\u0001\u001a\u00020\u00142\u0007\u0010\u0083\u0001\u001a\u000207H\u0002J\t\u0010\u0084\u0001\u001a\u000204H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0019\"\u0004\b*\u0010\u001b\u00a8\u0006\u008b\u0001"}, d2={"Ltraining/ui/LessonMessagePane;", "Ljavax/swing/JTextPane;", "panelMode", "", "(Z)V", "BALLOON_STYLE", "Ljavax/swing/text/SimpleAttributeSet;", "BOLD", "CODE", "INACTIVE", "INTERNAL_PARAGRAPH_STYLE", "LINK", "REGULAR", "ROBOTO", "SHORTCUT", "TASK_PARAGRAPH_STYLE", "activeMessages", "", "Ltraining/ui/LessonMessagePane$LessonMessage;", "codeFontSize", "", "codeForegroundColor", "Ljava/awt/Color;", "currentAnimation", "getCurrentAnimation", "()I", "setCurrentAnimation", "(I)V", "fontFamily", "", "getFontFamily", "()Ljava/lang/String;", "inactiveMessages", "insertOffset", "paragraphStyle", "ranges", "", "Ltraining/ui/LessonMessagePane$RangeData;", "restoreMessages", "textColor", "totalAnimation", "getTotalAnimation", "setTotalAnimation", "addMessage", "Lkotlin/Function0;", "Ljava/awt/Rectangle;", "messageParts", "", "Ltraining/ui/MessagePart;", "properties", "Ltraining/ui/LessonMessagePane$MessageProperties;", "addNotify", "", "addPlaceholderForIcon", "icon", "Ljavax/swing/Icon;", "addPlaceholderForIllustration", "part", "adjustCodeFontSize", "g", "Ljava/awt/Graphics;", "allLessonMessages", "appendClickableRange", "Lkotlin/ranges/IntRange;", "clickable", "attributeSet", "appendLink", "messagePart", "appendShortcut", "clear", "clearRestoreMessages", "drawRectangleAroundMessage", "lastPassedMessage", "lastActiveMessage", "g2d", "Ljava/awt/Graphics2D;", "needColor", "drawRectangleAroundText", "myMessage", "draw", "Lkotlin/Function1;", "Ljava/awt/geom/RoundRectangle2D;", "Lkotlin/ParameterName;", "name", "r2d", "drawTaskNumbers", "firstActiveMessage", "getCurrentMessageRectangle", "getInactiveIcon", "Lcom/intellij/util/ui/WatermarkIcon;", "getMaximumSize", "Ljava/awt/Dimension;", "getNumbersFont", "Ltraining/ui/LessonMessagePane$FontSearchResult;", "textFont", "Ljava/awt/Font;", "getRangeDataForMouse", "me", "Ljava/awt/event/MouseEvent;", "getRectangleToScroll", "lessonMessage", "initStyleConstants", "insertText", "text", "Ljavax/swing/text/AttributeSet;", "letterHeight", "font", "str", "messagesNumber", "paintComponent", "paintLessonCheckmarks", "paintMessages", "passPreviousMessages", "redrawMessages", "removeInactiveMessages", "number", "removeMessage", "index", "removeMessagesRange", "startIdx", "endIdx", "list", "resetMessagesNumber", "setCommonParagraphAttributes", "setInactiveStyle", "showShortcutBalloon", "point", "Ljava/awt/geom/Point2D;", "height", "actionName", "spaceAboveIllustrationParagraph", "illustration", "updateUI", "Companion", "FontSearchResult", "LessonMessage", "MessageProperties", "MessageState", "RangeData", "intellij.featuresTrainer"})
public final class LessonMessagePane
extends JTextPane {
    private final SimpleAttributeSet INACTIVE;
    private final SimpleAttributeSet REGULAR;
    private final SimpleAttributeSet BOLD;
    private final SimpleAttributeSet SHORTCUT;
    private final SimpleAttributeSet ROBOTO;
    private final SimpleAttributeSet CODE;
    private final SimpleAttributeSet LINK;
    private int codeFontSize;
    private final SimpleAttributeSet TASK_PARAGRAPH_STYLE;
    private final SimpleAttributeSet INTERNAL_PARAGRAPH_STYLE;
    private final SimpleAttributeSet BALLOON_STYLE;
    private final Color textColor;
    private final Color codeForegroundColor;
    private final List<LessonMessage> activeMessages;
    private final List<LessonMessage> restoreMessages;
    private final List<LessonMessage> inactiveMessages;
    private final Set<RangeData> ranges;
    private int insertOffset;
    private SimpleAttributeSet paragraphStyle;
    private int currentAnimation;
    private int totalAnimation;
    private final boolean panelMode;
    private static final Logger LOG;
    private static final Lazy arc$delegate;
    private static final Lazy indent$delegate;
    private static final Lazy activeTaskInset$delegate;
    @NotNull
    public static final Companion Companion;

    private final String getFontFamily() {
        Font font = UIUtil.getLabelFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"UIUtil.getLabelFont()");
        String string = font.getFontName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UIUtil.getLabelFont().fontName");
        return string;
    }

    private final List<LessonMessage> allLessonMessages() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.activeMessages, (Iterable)this.restoreMessages), (Iterable)this.inactiveMessages);
    }

    public final int getCurrentAnimation() {
        return this.currentAnimation;
    }

    public final void setCurrentAnimation(int n) {
        this.currentAnimation = n;
    }

    public final int getTotalAnimation() {
        return this.totalAnimation;
    }

    public final void setTotalAnimation(int n) {
        this.totalAnimation = n;
    }

    /*
     * WARNING - void declaration
     */
    private final RangeData getRangeDataForMouse(MouseEvent me) {
        RangeData result2;
        int n;
        block10: {
            block9: {
                Object v0;
                int offset;
                block8: {
                    offset = this.viewToModel2D(new Point2D.Double(me.getX(), me.getY()));
                    Iterable iterable = this.ranges;
                    n = 0;
                    Iterable iterable2 = iterable;
                    boolean bl = false;
                    for (Object t : iterable2) {
                        RangeData it = (RangeData)t;
                        boolean bl2 = false;
                        if (!it.getRange().contains(offset)) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                RangeData rangeData = v0;
                if (rangeData == null) {
                    return null;
                }
                result2 = rangeData;
                if (offset < 0) break block9;
                Document document = this.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
                if (offset < document.getLength()) break block10;
            }
            return null;
        }
        IntRange intRange = result2.getRange();
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i2;
                Rectangle2D rectangle = this.modelToView2D((int)i2);
                double d = me.getX();
                Rectangle2D rectangle2D = rectangle;
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"rectangle");
                if (d >= rectangle2D.getX() && (double)me.getY() >= rectangle.getY() && (double)me.getY() <= rectangle.getY() + rectangle.getHeight()) {
                    return result2;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initStyleConstants();
        this.redrawMessages();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ LessonMessagePane this$0;

            public final void run() {
                LessonMessagePane.access$initStyleConstants(this.this$0);
                this.this$0.redrawMessages();
            }
            {
                this.this$0 = lessonMessagePane;
            }
        });
    }

    private final void initStyleConstants() {
        int fontSize = (int)UISettings.Companion.getInstance().getFontSize();
        StyleConstants.setForeground(this.INACTIVE, UISettings.Companion.getInstance().getInactiveColor());
        StyleConstants.setFontFamily(this.REGULAR, this.getFontFamily());
        StyleConstants.setFontSize(this.REGULAR, fontSize);
        StyleConstants.setFontFamily(this.BOLD, this.getFontFamily());
        StyleConstants.setFontSize(this.BOLD, fontSize);
        StyleConstants.setBold(this.BOLD, true);
        StyleConstants.setFontFamily(this.SHORTCUT, this.getFontFamily());
        StyleConstants.setFontSize(this.SHORTCUT, fontSize);
        StyleConstants.setBold(this.SHORTCUT, true);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        editorColorsScheme.getEditorFontName();
        MutableAttributeSet mutableAttributeSet = this.CODE;
        EditorColorsManager editorColorsManager2 = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager2, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme2 = editorColorsManager2.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"EditorColorsManager.getInstance().globalScheme");
        StyleConstants.setFontFamily(mutableAttributeSet, editorColorsScheme2.getEditorFontName());
        StyleConstants.setFontSize(this.CODE, this.codeFontSize);
        StyleConstants.setFontFamily(this.LINK, this.getFontFamily());
        StyleConstants.setUnderline(this.LINK, true);
        StyleConstants.setFontSize(this.LINK, fontSize);
        StyleConstants.setSpaceAbove(this.TASK_PARAGRAPH_STYLE, UISettings.Companion.getInstance().getTaskParagraphAbove());
        this.setCommonParagraphAttributes(this.TASK_PARAGRAPH_STYLE);
        StyleConstants.setSpaceAbove(this.INTERNAL_PARAGRAPH_STYLE, UISettings.Companion.getInstance().getTaskInternalParagraphAbove());
        this.setCommonParagraphAttributes(this.INTERNAL_PARAGRAPH_STYLE);
        StyleConstants.setLineSpacing(this.BALLOON_STYLE, 0.2f);
        StyleConstants.setLeftIndent(this.BALLOON_STYLE, UISettings.Companion.getInstance().getBalloonIndent());
        StyleConstants.setForeground(this.REGULAR, this.textColor);
        StyleConstants.setForeground(this.BOLD, this.textColor);
        StyleConstants.setForeground(this.SHORTCUT, UISettings.Companion.getInstance().getShortcutTextColor());
        StyleConstants.setForeground(this.LINK, UISettings.Companion.getInstance().getLessonLinkColor());
        StyleConstants.setForeground(this.CODE, this.codeForegroundColor);
    }

    private final void setCommonParagraphAttributes(SimpleAttributeSet attributeSet) {
        StyleConstants.setLeftIndent(attributeSet, UISettings.Companion.getInstance().getCheckIndent());
        StyleConstants.setRightIndent(attributeSet, 0.0f);
        StyleConstants.setSpaceBelow(attributeSet, 0.0f);
        StyleConstants.setLineSpacing(attributeSet, 0.2f);
    }

    public final int messagesNumber() {
        return this.activeMessages.size();
    }

    private final void removeMessagesRange(int startIdx, int endIdx, List<LessonMessage> list2) {
        if (startIdx == endIdx) {
            return;
        }
        list2.subList(startIdx, endIdx).clear();
    }

    @NotNull
    public final Function0<Rectangle> clearRestoreMessages() {
        this.removeMessagesRange(0, this.restoreMessages.size(), this.restoreMessages);
        this.redrawMessages();
        LessonMessage lastOrNull = (LessonMessage)CollectionsKt.lastOrNull(this.activeMessages);
        return (Function0)new Function0<Rectangle>(this, lastOrNull){
            final /* synthetic */ LessonMessagePane this$0;
            final /* synthetic */ LessonMessage $lastOrNull;

            @Nullable
            public final Rectangle invoke() {
                Rectangle rectangle;
                LessonMessage lessonMessage = this.$lastOrNull;
                if (lessonMessage != null) {
                    LessonMessage lessonMessage2 = lessonMessage;
                    boolean bl = false;
                    boolean bl2 = false;
                    LessonMessage it = lessonMessage2;
                    boolean bl3 = false;
                    rectangle = LessonMessagePane.access$getRectangleToScroll(this.this$0, it);
                } else {
                    rectangle = null;
                }
                return rectangle;
            }
            {
                this.this$0 = lessonMessagePane;
                this.$lastOrNull = lessonMessage;
                super(0);
            }
        };
    }

    public final void removeInactiveMessages(int number) {
        this.removeMessagesRange(0, number, this.inactiveMessages);
        this.redrawMessages();
    }

    @NotNull
    public final Function0<Rectangle> resetMessagesNumber(int number) {
        List<LessonMessage> move = this.activeMessages.subList(number, this.activeMessages.size());
        Iterable $this$forEach$iv = move;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonMessage it = (LessonMessage)element$iv;
            boolean bl = false;
            it.setState(MessageState.INACTIVE);
        }
        this.inactiveMessages.addAll(0, (Collection<LessonMessage>)move);
        move.clear();
        return this.clearRestoreMessages();
    }

    @Nullable
    public final Rectangle getCurrentMessageRectangle() {
        LessonMessage lessonMessage = (LessonMessage)CollectionsKt.lastOrNull(this.restoreMessages);
        if (lessonMessage == null) {
            lessonMessage = (LessonMessage)CollectionsKt.lastOrNull(this.activeMessages);
        }
        if (lessonMessage == null) {
            return null;
        }
        LessonMessage lessonMessage2 = lessonMessage;
        return this.getRectangleToScroll(lessonMessage2);
    }

    private final void insertText(String text2, AttributeSet attributeSet) {
        this.getDocument().insertString(this.insertOffset, text2, attributeSet);
        this.getStyledDocument().setParagraphAttributes(this.insertOffset, text2.length() - 1, this.paragraphStyle, true);
        this.insertOffset += text2.length();
    }

    @NotNull
    public final Function0<Rectangle> addMessage(@NotNull List<MessagePart> messageParts, @NotNull MessageProperties properties) {
        List<LessonMessage> list2;
        Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        LessonMessage lessonMessage = new LessonMessage(messageParts, properties.getState(), properties.getVisualIndex(), properties.getUseInternalParagraphStyle(), properties.getTextProperties(), 0, 0, 96, null);
        switch (LessonMessagePane$WhenMappings.$EnumSwitchMapping$0[properties.getState().ordinal()]) {
            case 1: {
                list2 = this.inactiveMessages;
                break;
            }
            case 2: {
                list2 = this.restoreMessages;
                break;
            }
            default: {
                list2 = this.activeMessages;
            }
        }
        list2.add(lessonMessage);
        this.redrawMessages();
        return (Function0)new Function0<Rectangle>(this, lessonMessage){
            final /* synthetic */ LessonMessagePane this$0;
            final /* synthetic */ LessonMessage $lessonMessage;

            @Nullable
            public final Rectangle invoke() {
                return LessonMessagePane.access$getRectangleToScroll(this.this$0, this.$lessonMessage);
            }
            {
                this.this$0 = lessonMessagePane;
                this.$lessonMessage = lessonMessage;
                super(0);
            }
        };
    }

    public static /* synthetic */ Function0 addMessage$default(LessonMessagePane lessonMessagePane, List list2, MessageProperties messageProperties, int n, Object object) {
        if ((n & 2) != 0) {
            messageProperties = new MessageProperties(null, null, false, null, 15, null);
        }
        return lessonMessagePane.addMessage(list2, messageProperties);
    }

    public final void removeMessage(int index) {
        this.activeMessages.remove(index);
    }

    private final Rectangle getRectangleToScroll(LessonMessage lessonMessage) {
        Rectangle2D rectangle2D = this.modelToView2D(lessonMessage.getStart() + 1);
        if (rectangle2D == null || (rectangle2D = LessonMessagePane.Companion.toRectangle(rectangle2D)) == null) {
            return null;
        }
        Rectangle2D startRect = rectangle2D;
        Rectangle2D rectangle2D2 = this.modelToView2D(lessonMessage.getEnd() - 1);
        if (rectangle2D2 == null || (rectangle2D2 = LessonMessagePane.Companion.toRectangle(rectangle2D2)) == null) {
            return null;
        }
        Rectangle2D endRect = rectangle2D2;
        return new Rectangle(((Rectangle)startRect).x, ((Rectangle)startRect).y - LessonMessagePane.Companion.getActiveTaskInset(), ((Rectangle)endRect).x + ((Rectangle)endRect).width - ((Rectangle)startRect).x, ((Rectangle)endRect).y + ((Rectangle)endRect).height - ((Rectangle)startRect).y + LessonMessagePane.Companion.getActiveTaskInset() * 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void redrawMessages() {
        this.initStyleConstants();
        this.ranges.clear();
        this.setText("");
        this.insertOffset = 0;
        LessonMessage previous = null;
        Iterator<LessonMessage> iterator = this.allLessonMessages().iterator();
        while (iterator.hasNext()) {
            LessonMessage lessonMessage = iterator.next();
            Object object = previous;
            if ((object != null && (object = ((LessonMessage)object).getMessageParts()) != null && (object = (MessagePart)CollectionsKt.firstOrNull((List)object)) != null ? ((MessagePart)object).getType() : null) != MessagePart.MessageType.ILLUSTRATION) {
                SimpleAttributeSet simpleAttributeSet;
                TaskTextProperties textProperties;
                LessonMessage lessonMessage2 = previous;
                TaskTextProperties taskTextProperties = textProperties = lessonMessage2 != null ? lessonMessage2.getTextProperties() : null;
                if (textProperties != null) {
                    SimpleAttributeSet customStyle = new SimpleAttributeSet();
                    this.setCommonParagraphAttributes(customStyle);
                    StyleConstants.setSpaceAbove(customStyle, textProperties.getSpaceAbove());
                    StyleConstants.setSpaceBelow(customStyle, textProperties.getSpaceBelow());
                    simpleAttributeSet = customStyle;
                } else {
                    LessonMessage lessonMessage3 = previous;
                    simpleAttributeSet = lessonMessage3 != null && lessonMessage3.getUseInternalParagraphStyle() ? this.INTERNAL_PARAGRAPH_STYLE : (this.panelMode ? this.TASK_PARAGRAPH_STYLE : this.BALLOON_STYLE);
                }
                this.paragraphStyle = simpleAttributeSet;
            }
            List<MessagePart> messageParts = lessonMessage.getMessageParts();
            lessonMessage.setStart(this.insertOffset);
            if (this.insertOffset != 0) {
                this.insertText("\n", this.paragraphStyle);
            }
            for (MessagePart part : messageParts) {
                int startOffset = this.insertOffset;
                part.setStartOffset(startOffset);
                switch (LessonMessagePane$WhenMappings.$EnumSwitchMapping$1[part.getType().ordinal()]) {
                    case 1: {
                        this.insertText(part.getText(), this.REGULAR);
                        break;
                    }
                    case 2: {
                        this.insertText(part.getText(), this.BOLD);
                        break;
                    }
                    case 3: {
                        Object object2;
                        if (this.appendShortcut(part) == null) break;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        this.ranges.add((RangeData)it);
                        break;
                    }
                    case 4: {
                        this.insertText(part.getText(), this.CODE);
                        break;
                    }
                    case 5: {
                        this.insertText(part.getText(), this.ROBOTO);
                        break;
                    }
                    case 6: {
                        Object object2;
                        if (this.appendLink(part) == null) break;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl4 = false;
                        this.ranges.add((RangeData)it);
                        break;
                    }
                    case 7: {
                        Object object2;
                        if ((Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)part.getText()) == null) break;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl5 = false;
                        Object object3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it");
                        this.addPlaceholderForIcon((Icon)object3);
                        break;
                    }
                    case 8: {
                        this.insertText(part.getText(), this.BOLD);
                        break;
                    }
                    case 9: {
                        this.addPlaceholderForIllustration(part);
                        break;
                    }
                    case 10: {
                        this.insertText("\n", this.REGULAR);
                        this.paragraphStyle = this.INTERNAL_PARAGRAPH_STYLE;
                        break;
                    }
                }
                part.setEndOffset(this.insertOffset);
            }
            lessonMessage.setEnd(this.insertOffset);
            if (lessonMessage.getState() == MessageState.INACTIVE) {
                this.setInactiveStyle(lessonMessage);
            }
            previous = lessonMessage;
        }
        return;
    }

    private final void addPlaceholderForIllustration(MessagePart part) {
        Icon illustration = (Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)part.getText());
        if (illustration == null) {
            LessonMessagePane $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LessonMessagePane.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("No illustration for " + part.getText());
        } else {
            int spaceAbove = this.spaceAboveIllustrationParagraph(illustration) + UISettings.Companion.getInstance().getIllustrationAbove();
            SimpleAttributeSet illustrationStyle = new SimpleAttributeSet();
            StyleConstants.setSpaceAbove(illustrationStyle, spaceAbove);
            this.setCommonParagraphAttributes(illustrationStyle);
            this.paragraphStyle = illustrationStyle;
        }
        this.insertText(" ", this.REGULAR);
    }

    private final int spaceAboveIllustrationParagraph(Icon illustration) {
        int n = illustration.getIconHeight();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(this.font)");
        return n - fontMetrics.getHeight() + UISettings.Companion.getInstance().getIllustrationBelow();
    }

    private final void addPlaceholderForIcon(Icon icon) {
        String placeholder = " ";
        while (this.getFontMetrics(this.getFont()).stringWidth(placeholder) <= icon.getIconWidth()) {
            placeholder = placeholder + " ";
        }
        placeholder = placeholder + " ";
        this.insertText(placeholder, this.REGULAR);
    }

    public final void passPreviousMessages() {
        for (LessonMessage message : this.activeMessages) {
            message.setState(MessageState.PASSED);
        }
        this.redrawMessages();
    }

    private final void setInactiveStyle(LessonMessage lessonMessage) {
        this.getStyledDocument().setCharacterAttributes(lessonMessage.getStart(), lessonMessage.getEnd(), this.INACTIVE, false);
    }

    public final void clear() {
        this.setText("");
        this.activeMessages.clear();
        this.restoreMessages.clear();
        this.inactiveMessages.clear();
        this.ranges.clear();
    }

    private final RangeData appendLink(MessagePart messagePart) throws BadLocationException {
        IntRange clickRange = this.appendClickableRange(messagePart.getText(), this.LINK);
        Runnable runnable = messagePart.getRunnable();
        if (runnable == null) {
            return null;
        }
        Runnable runnable2 = runnable;
        return new RangeData(clickRange, (Function2<? super Point, ? super Integer, Unit>)((Function2)new Function2<Point, Integer, Unit>(runnable2){
            final /* synthetic */ Runnable $runnable;

            public final void invoke(@NotNull Point $noName_0, int $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                this.$runnable.run();
            }
            {
                this.$runnable = runnable;
                super(2);
            }
        }));
    }

    private final RangeData appendShortcut(MessagePart messagePart) {
        IntRange range = this.appendClickableRange(messagePart.getText(), this.SHORTCUT);
        String string = messagePart.getLink();
        if (string == null) {
            return null;
        }
        String actionId = string;
        IntRange clickRange = new IntRange(range.getFirst() + 1, range.getLast() - 1);
        return new RangeData(clickRange, (Function2<? super Point, ? super Integer, Unit>)((Function2)new Function2<Point, Integer, Unit>(this, actionId){
            final /* synthetic */ LessonMessagePane this$0;
            final /* synthetic */ String $actionId;

            public final void invoke(@NotNull Point p, int h) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                LessonMessagePane.access$showShortcutBalloon(this.this$0, p, h, this.$actionId);
            }
            {
                this.this$0 = lessonMessagePane;
                this.$actionId = string;
                super(2);
            }
        }));
    }

    private final void showShortcutBalloon(Point2D point, int height, String actionName) {
        if (actionName == null) {
            return;
        }
        ActionKeyPopupKt.showActionKeyPopup(this, LessonMessagePane.Companion.toPoint(point), height, actionName);
    }

    private final IntRange appendClickableRange(String clickable, SimpleAttributeSet attributeSet) {
        int startLink = this.insertOffset;
        this.insertText(clickable, attributeSet);
        int endLink = this.insertOffset;
        int n = startLink;
        return new IntRange(n, endLink);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.adjustCodeFontSize(g);
        try {
            this.paintMessages(g);
        }
        catch (BadLocationException e) {
            LOG.warn((Throwable)e);
        }
        super.paintComponent(g);
        this.paintLessonCheckmarks(g);
        this.drawTaskNumbers(g);
    }

    private final void adjustCodeFontSize(Graphics g) {
        int fontSize = StyleConstants.getFontSize(this.CODE);
        Font labelFont = UISettings.Companion.getInstance().getPlainFont();
        FontSearchResult fontSearchResult = this.getNumbersFont(labelFont, g);
        Font numberFont = fontSearchResult.component1();
        if (numberFont.getSize() != fontSize) {
            StyleConstants.setFontSize(this.CODE, numberFont.getSize());
            this.codeFontSize = numberFont.getSize();
            this.redrawMessages();
        }
    }

    private final void paintLessonCheckmarks(Graphics g) {
        int n;
        Font plainFont = UISettings.Companion.getInstance().getPlainFont();
        FontMetrics fontMetrics = g.getFontMetrics(plainFont);
        if (g instanceof Graphics2D) {
            n = this.letterHeight(plainFont, (Graphics2D)g, "A");
        } else {
            FontMetrics fontMetrics2 = fontMetrics;
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"fontMetrics");
            n = fontMetrics2.getHeight();
        }
        int height = n;
        FontMetrics fontMetrics3 = fontMetrics;
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics3, (String)"fontMetrics");
        int baseLineOffset = fontMetrics3.getAscent() + fontMetrics.getLeading();
        for (LessonMessage lessonMessage : this.allLessonMessages()) {
            Icon icon;
            int startOffset = lessonMessage.getStart();
            if (startOffset != 0) {
                ++startOffset;
            }
            Rectangle2D rectangle2D = this.modelToView2D(startOffset);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"modelToView2D(startOffset)");
            Rectangle rectangle = LessonMessagePane.Companion.toRectangle(rectangle2D);
            MessagePart messagePart = (MessagePart)CollectionsKt.singleOrNull(lessonMessage.getMessageParts());
            if ((messagePart != null ? messagePart.getType() : null) == MessagePart.MessageType.ILLUSTRATION) continue;
            if (lessonMessage.getState() == MessageState.PASSED) {
                icon = FeaturesTrainerIcons.Img.GreenCheckmark;
            } else {
                if (LessonManager.Companion.getInstance().lessonIsRunning$intellij_featuresTrainer()) continue;
                icon = AllIcons.General.Information;
            }
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"if (lessonMessage.state \u2026    }\n      else continue");
            Icon icon2 = icon;
            int xShift = icon2.getIconWidth() + UISettings.Companion.getInstance().getNumberTaskIndent();
            int y = rectangle.y + baseLineOffset - (height + icon2.getIconHeight() + 1) / 2;
            icon2.paintIcon(this, g, rectangle.x - xShift, y);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawTaskNumbers(Graphics g) {
        LessonMessage firstActiveMessage;
        void numberHeight;
        void numberFont;
        FontMetrics textFontMetrics;
        Font oldFont = g.getFont();
        Font labelFont = UISettings.Companion.getInstance().getPlainFont();
        FontSearchResult fontSearchResult = this.getNumbersFont(labelFont, g);
        Font font = fontSearchResult.component1();
        int n = fontSearchResult.component2();
        int textLetterHeight = fontSearchResult.component3();
        FontMetrics fontMetrics = textFontMetrics = g.getFontMetrics(labelFont);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"textFontMetrics");
        int baseLineOffset = fontMetrics.getAscent() + textFontMetrics.getLeading();
        g.setFont((Font)numberFont);
        Function2<LessonMessage, Color, Unit> $fun$paintNumber$1 = new Function2<LessonMessage, Color, Unit>(this, textFontMetrics, baseLineOffset, (int)numberHeight, textLetterHeight, g){
            final /* synthetic */ LessonMessagePane this$0;
            final /* synthetic */ FontMetrics $textFontMetrics;
            final /* synthetic */ int $baseLineOffset;
            final /* synthetic */ int $numberHeight;
            final /* synthetic */ int $textLetterHeight;
            final /* synthetic */ Graphics $g;

            public final void invoke(@NotNull LessonMessage lessonMessage, @NotNull Color color) {
                Rectangle2D modelToView2D;
                Object object;
                Intrinsics.checkNotNullParameter((Object)lessonMessage, (String)"lessonMessage");
                Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                int startOffset = lessonMessage.getStart();
                if (startOffset != 0) {
                    ++startOffset;
                }
                if ((object = lessonMessage.getVisualIndex()) == null || (object = String.valueOf((Integer)object)) == null || (object = StringsKt.padStart((String)object, (int)2, (char)'0')) == null) {
                    return;
                }
                Object s = object;
                int width = this.$textFontMetrics.stringWidth((String)s);
                Rectangle2D rectangle2D = modelToView2D = this.this$0.modelToView2D(startOffset);
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"modelToView2D");
                Rectangle rectangle = training.ui.LessonMessagePane$Companion.access$toRectangle(LessonMessagePane.Companion, rectangle2D);
                int xOffset = rectangle.x - (width + UISettings.Companion.getInstance().getNumberTaskIndent());
                int baseLineY = rectangle.y + this.$baseLineOffset;
                int yOffset = baseLineY + (this.$numberHeight - this.$textLetterHeight);
                Color backupColor = this.$g.getColor();
                this.$g.setColor(color);
                GraphicsUtil.setupAAPainting((Graphics)this.$g);
                this.$g.drawString((String)s, xOffset, yOffset);
                this.$g.setColor(backupColor);
            }
            {
                this.this$0 = lessonMessagePane;
                this.$textFontMetrics = fontMetrics;
                this.$baseLineOffset = n;
                this.$numberHeight = n2;
                this.$textLetterHeight = n3;
                this.$g = graphics;
                super(2);
            }
        };
        for (LessonMessage lessonMessage : this.inactiveMessages) {
            $fun$paintNumber$1.invoke(lessonMessage, UISettings.Companion.getInstance().getFutureTaskNumberColor());
        }
        LessonMessage lessonMessage = (LessonMessage)CollectionsKt.lastOrNull(this.activeMessages);
        if (!((lessonMessage != null ? lessonMessage.getState() : null) == MessageState.PASSED && this.panelMode || (firstActiveMessage = this.firstActiveMessage()) == null)) {
            Color color = this.panelMode ? UISettings.Companion.getInstance().getActiveTaskNumberColor() : UISettings.Companion.getInstance().getTooltipTaskNumberColor();
            $fun$paintNumber$1.invoke(firstActiveMessage, color);
        }
        g.setFont(oldFont);
    }

    /*
     * WARNING - void declaration
     */
    private final FontSearchResult getNumbersFont(Font textFont, Graphics g) {
        int style = 0;
        String string = FontPreferences.DEFAULT_FONT_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FontPreferences.DEFAULT_FONT_NAME");
        String monoFontName = string;
        if (g instanceof Graphics2D) {
            void numberHeight;
            void size;
            void numberFont;
            int textHeight = this.letterHeight(textFont, (Graphics2D)g, "A");
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = textFont.getSize();
            Ref.IntRef intRef2 = new Ref.IntRef();
            intRef2.element = 0;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function0<Integer> $fun$calculateHeight$1 = new Function0<Integer>(this, (Ref.ObjectRef)numberFont, monoFontName, style, (Ref.IntRef)size, (Ref.IntRef)numberHeight, g){
                final /* synthetic */ LessonMessagePane this$0;
                final /* synthetic */ Ref.ObjectRef $numberFont;
                final /* synthetic */ String $monoFontName;
                final /* synthetic */ int $style;
                final /* synthetic */ Ref.IntRef $size;
                final /* synthetic */ Ref.IntRef $numberHeight;
                final /* synthetic */ Graphics $g;

                public final int invoke() {
                    Object object = this.$numberFont.element = new Font(this.$monoFontName, this.$style, this.$size.element);
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"numberFont");
                    }
                    this.$numberHeight.element = LessonMessagePane.access$letterHeight(this.this$0, (Font)object, (Graphics2D)this.$g, "0");
                    return this.$numberHeight.element;
                }
                {
                    this.this$0 = lessonMessagePane;
                    this.$numberFont = objectRef;
                    this.$monoFontName = string;
                    this.$style = n;
                    this.$size = intRef;
                    this.$numberHeight = intRef2;
                    this.$g = graphics;
                    super(0);
                }
            };
            $fun$calculateHeight$1.invoke();
            if (numberHeight.element > textHeight) {
                int n = size.element;
                size.element = n + -1;
                while ($fun$calculateHeight$1.invoke() >= textHeight) {
                    n = size.element;
                    size.element = n + -1;
                }
                n = size.element;
                size.element = n + 1;
                $fun$calculateHeight$1.invoke();
            } else if (numberHeight.element < textHeight) {
                int n = size.element;
                size.element = n + 1;
                while ($fun$calculateHeight$1.invoke() < textHeight) {
                    n = size.element;
                    size.element = n + 1;
                }
            }
            Object object = numberFont.element;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"numberFont");
            }
            return new FontSearchResult((Font)object, numberHeight.element, textHeight);
        }
        return new FontSearchResult(new Font(monoFontName, style, textFont.getSize()), 0, 0);
    }

    private final int letterHeight(Font font, Graphics2D g, String str) {
        GlyphVector glyphVector = font.createGlyphVector(g.getFontRenderContext(), str);
        Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"font.createGlyphVector(g.fontRenderContext, str)");
        GlyphVector gv = glyphVector;
        GlyphMetrics glyphMetrics = gv.getGlyphMetrics(0);
        Intrinsics.checkNotNullExpressionValue((Object)glyphMetrics, (String)"gv.getGlyphMetrics(0)");
        Rectangle2D rectangle2D = glyphMetrics.getBounds2D();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"gv.getGlyphMetrics(0).bounds2D");
        return MathKt.roundToInt((double)rectangle2D.getHeight());
    }

    private final void paintMessages(Graphics g) throws BadLocationException {
        Graphics graphics = g;
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)graphics;
        for (LessonMessage lessonMessage : this.allLessonMessages()) {
            List<MessagePart> myMessages = lessonMessage.getMessageParts();
            block7: for (MessagePart myMessage : myMessages) {
                switch (LessonMessagePane$WhenMappings.$EnumSwitchMapping$2[myMessage.getType().ordinal()]) {
                    case 1: {
                        Color bg = UISettings.Companion.getInstance().getShortcutBackgroundColor();
                        Color needColor = lessonMessage.getState() == MessageState.INACTIVE ? new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 76) : bg;
                        for (MessagePart part : myMessage.splitMe()) {
                            this.drawRectangleAroundText(part, g2d, needColor, (Function1<? super RoundRectangle2D, Unit>)((Function1)new Function1<RoundRectangle2D, Unit>(g2d){
                                final /* synthetic */ Graphics2D $g2d;

                                public final void invoke(@NotNull RoundRectangle2D r2d) {
                                    Intrinsics.checkNotNullParameter((Object)r2d, (String)"r2d");
                                    this.$g2d.fill(r2d);
                                }
                                {
                                    this.$g2d = graphics2D;
                                    super(1);
                                }
                            }));
                        }
                        break;
                    }
                    case 2: {
                        Color needColor = UISettings.Companion.getInstance().getCodeBorderColor();
                        this.drawRectangleAroundText(myMessage, g2d, needColor, (Function1<? super RoundRectangle2D, Unit>)((Function1)new Function1<RoundRectangle2D, Unit>(this, g2d){
                            final /* synthetic */ LessonMessagePane this$0;
                            final /* synthetic */ Graphics2D $g2d;

                            public final void invoke(@NotNull RoundRectangle2D r2d) {
                                Intrinsics.checkNotNullParameter((Object)r2d, (String)"r2d");
                                if (LessonMessagePane.access$getPanelMode$p(this.this$0)) {
                                    this.$g2d.draw(r2d);
                                } else {
                                    this.$g2d.fill(r2d);
                                }
                            }
                            {
                                this.this$0 = lessonMessagePane;
                                this.$g2d = graphics2D;
                                super(1);
                            }
                        }));
                        break;
                    }
                    case 3: {
                        Icon icon;
                        Rectangle2D rect = this.modelToView2D(myMessage.getStartOffset() + 1);
                        if ((Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)myMessage.getText()) == null) {
                            continue block7;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LearningUiManager.iconMa\u2026Message.text] ?: continue");
                        if (this.inactiveMessages.contains(lessonMessage)) {
                            icon = (Icon)this.getInactiveIcon(icon);
                        }
                        Component component2 = this;
                        Graphics graphics2 = g2d;
                        Rectangle2D rectangle2D = rect;
                        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"rect");
                        icon.paintIcon(component2, graphics2, (int)rectangle2D.getX(), (int)rect.getY());
                        break;
                    }
                    case 4: {
                        Icon icon;
                        Rectangle2D rectangle2D = this.modelToView2D(myMessage.getStartOffset());
                        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"modelToView2D(myMessage.startOffset)");
                        int x = (int)rectangle2D.getX();
                        Rectangle2D rectangle2D2 = this.modelToView2D(myMessage.getEndOffset() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"modelToView2D(myMessage.endOffset - 1)");
                        int y = (int)rectangle2D2.getY();
                        if ((Icon)LearningUiManager.INSTANCE.getIconMap().get((Object)myMessage.getText()) == null) {
                            continue block7;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LearningUiManager.iconMa\u2026Message.text] ?: continue");
                        if (this.inactiveMessages.contains(lessonMessage)) {
                            icon = (Icon)this.getInactiveIcon(icon);
                        }
                        icon.paintIcon(this, g2d, x, y - this.spaceAboveIllustrationParagraph(icon));
                        break;
                    }
                }
            }
        }
        LessonMessage lastActiveMessage = (LessonMessage)CollectionsKt.lastOrNull(this.activeMessages);
        LessonMessage firstActiveMessage = this.firstActiveMessage();
        if (this.panelMode && lastActiveMessage != null && lastActiveMessage.getState() == MessageState.NORMAL) {
            Color c = UISettings.Companion.getInstance().getActiveTaskBorder();
            int a = this.totalAnimation == 0 ? 255 : 255 * this.currentAnimation / this.totalAnimation;
            Color needColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
            this.drawRectangleAroundMessage(firstActiveMessage, lastActiveMessage, g2d, needColor);
        }
    }

    private final WatermarkIcon getInactiveIcon(Icon icon) {
        return new WatermarkIcon(icon, (float)UISettings.Companion.getInstance().getTransparencyInactiveFactor());
    }

    private final LessonMessage firstActiveMessage() {
        Object object;
        block5: {
            block4: {
                int n;
                block3: {
                    List<LessonMessage> $this$indexOfLast$iv = this.activeMessages;
                    boolean $i$f$indexOfLast = false;
                    ListIterator<LessonMessage> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        LessonMessage it = iterator$iv.previous();
                        boolean bl = false;
                        if (!(it.getState() == MessageState.PASSED)) continue;
                        n = iterator$iv.nextIndex();
                        break block3;
                    }
                    n = -1;
                }
                Integer n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                object = it != -1 && it < this.activeMessages.size() - 1 ? n2 : null;
                if (object == null) break block4;
                n2 = object;
                bl = false;
                bl2 = false;
                it = ((Number)n2).intValue();
                boolean bl4 = false;
                object = this.activeMessages.get(it + 1);
                if (object != null) break block5;
            }
            object = (LessonMessage)CollectionsKt.firstOrNull(this.activeMessages);
        }
        return object;
    }

    private final void drawRectangleAroundText(MessagePart myMessage, Graphics2D g2d, Color needColor, Function1<? super RoundRectangle2D, Unit> draw) {
        int startOffset = myMessage.getStartOffset();
        int endOffset = myMessage.getEndOffset();
        Rectangle2D rectangleStart = this.modelToView2D(startOffset);
        Rectangle2D rectangleEnd = this.modelToView2D(endOffset);
        Color color = g2d.getColor();
        float fontSize = UISettings.Companion.getInstance().getFontSize();
        g2d.setColor(needColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float shift = SystemInfo.isMac ? 1.0f : 2.0f;
        Rectangle2D rectangle2D = rectangleStart;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"rectangleStart");
        double d = rectangle2D.getX() - (double)(2 * LessonMessagePane.Companion.getIndent());
        double d2 = rectangleStart.getY() - (double)LessonMessagePane.Companion.getIndent() + (double)JBUIScale.scale((float)shift);
        Rectangle2D rectangle2D2 = rectangleEnd;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"rectangleEnd");
        RoundRectangle2D.Double r2d = new RoundRectangle2D.Double(d, d2, rectangle2D2.getX() - rectangleStart.getX() + (double)(4 * LessonMessagePane.Companion.getIndent()), fontSize + (float)(2 * LessonMessagePane.Companion.getIndent()), LessonMessagePane.Companion.getArc(), LessonMessagePane.Companion.getArc());
        draw.invoke((Object)r2d);
        g2d.setColor(color);
    }

    private final void drawRectangleAroundMessage(LessonMessage lastPassedMessage, LessonMessage lastActiveMessage, Graphics2D g2d, Color needColor) {
        int n;
        LessonMessage lessonMessage = lastPassedMessage;
        if (lessonMessage != null) {
            LessonMessage lessonMessage2 = lessonMessage;
            boolean bl = false;
            boolean bl2 = false;
            LessonMessage it = lessonMessage2;
            boolean bl3 = false;
            n = it.getStart() == 0 ? 0 : it.getStart() + 1;
        } else {
            n = 0;
        }
        int startOffset = n;
        int endOffset = lastActiveMessage.getEnd();
        Rectangle2D rectangle2D = this.modelToView2D(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"modelToView2D(startOffset)");
        double topLineY = rectangle2D.getY();
        Rectangle2D rectangle2D2 = this.modelToView2D(endOffset - 1);
        boolean bl = false;
        boolean bl4 = false;
        Rectangle2D it = rectangle2D2;
        boolean bl5 = false;
        Rectangle2D rectangle2D3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D3, (String)"it");
        double bottomLineY = rectangle2D3.getY() + it.getHeight();
        double textHeight = bottomLineY - topLineY;
        Color color = g2d.getColor();
        g2d.setColor(needColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double xOffset = JBUI.scale((int)2);
        double yOffset = topLineY - (double)LessonMessagePane.Companion.getActiveTaskInset();
        double width = (double)this.getBounds().width - (double)2 * xOffset - (double)JBUIScale.scale((int)2);
        TaskTextProperties taskTextProperties = lastActiveMessage.getTextProperties();
        double height = textHeight + (double)(2 * LessonMessagePane.Companion.getActiveTaskInset()) - (double)JBUIScale.scale((int)2) + (double)(taskTextProperties != null ? taskTextProperties.getSpaceBelow() : 0);
        g2d.draw(new RoundRectangle2D.Double(xOffset, yOffset, width, height, LessonMessagePane.Companion.getArc(), LessonMessagePane.Companion.getArc()));
        g2d.setColor(color);
    }

    static /* synthetic */ void drawRectangleAroundMessage$default(LessonMessagePane lessonMessagePane, LessonMessage lessonMessage, LessonMessage lessonMessage2, Graphics2D graphics2D, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            lessonMessage = null;
        }
        lessonMessagePane.drawRectangleAroundMessage(lessonMessage, lessonMessage2, graphics2D, color);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"preferredSize");
        return dimension;
    }

    public LessonMessagePane(boolean panelMode) {
        this.panelMode = panelMode;
        this.INACTIVE = new SimpleAttributeSet();
        this.REGULAR = new SimpleAttributeSet();
        this.BOLD = new SimpleAttributeSet();
        this.SHORTCUT = new SimpleAttributeSet();
        this.ROBOTO = new SimpleAttributeSet();
        this.CODE = new SimpleAttributeSet();
        this.LINK = new SimpleAttributeSet();
        this.codeFontSize = (int)UISettings.Companion.getInstance().getFontSize();
        this.TASK_PARAGRAPH_STYLE = new SimpleAttributeSet();
        this.INTERNAL_PARAGRAPH_STYLE = new SimpleAttributeSet();
        this.BALLOON_STYLE = new SimpleAttributeSet();
        this.textColor = this.panelMode ? UISettings.Companion.getInstance().getDefaultTextColor() : UISettings.Companion.getInstance().getTooltipTextColor();
        this.codeForegroundColor = this.panelMode ? UISettings.Companion.getInstance().getCodeForegroundColor() : UISettings.Companion.getInstance().getTooltipTextColor();
        boolean bl = false;
        this.activeMessages = new ArrayList();
        bl = false;
        this.restoreMessages = new ArrayList();
        bl = false;
        this.inactiveMessages = new ArrayList();
        bl = false;
        this.ranges = new LinkedHashSet();
        this.paragraphStyle = new SimpleAttributeSet();
        UIUtil.doNotScrollToCaret((JTextComponent)this);
        this.initStyleConstants();
        this.setEditable(false);
        MouseAdapter listener2 = new MouseAdapter(this){
            final /* synthetic */ LessonMessagePane this$0;

            public void mouseClicked(@NotNull MouseEvent me) {
                Intrinsics.checkNotNullParameter((Object)me, (String)"me");
                RangeData rangeData = LessonMessagePane.access$getRangeDataForMouse(this.this$0, me);
                if (rangeData == null) {
                    return;
                }
                RangeData rangeData2 = rangeData;
                int middle = (rangeData2.getRange().getFirst() + rangeData2.getRange().getLast()) / 2;
                Rectangle2D rectangle = this.this$0.modelToView2D(middle);
                Function2<Point, Integer, Unit> function2 = rangeData2.getAction();
                Rectangle2D rectangle2D = rectangle;
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"rectangle");
                function2.invoke((Object)new Point(MathKt.roundToInt((double)rectangle2D.getX()), MathKt.roundToInt((double)rectangle.getY()) + MathKt.roundToInt((double)rectangle.getHeight()) / 2), (Object)MathKt.roundToInt((double)rectangle.getHeight()));
            }

            public void mouseMoved(@NotNull MouseEvent me) {
                Intrinsics.checkNotNullParameter((Object)me, (String)"me");
                RangeData rangeData = LessonMessagePane.access$getRangeDataForMouse(this.this$0, me);
                this.this$0.setCursor(rangeData == null ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
            }
            {
                this.this$0 = this$0;
            }
        };
        this.addMouseListener(listener2);
        this.addMouseMotionListener(listener2);
    }

    public /* synthetic */ LessonMessagePane(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public LessonMessagePane() {
        this(false, 1, null);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LessonMessagePane.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(LessonMessagePane::class.java)");
        LOG = logger;
        arc$delegate = LazyKt.lazy((Function0)Companion.arc.2.INSTANCE);
        indent$delegate = LazyKt.lazy((Function0)Companion.indent.2.INSTANCE);
        activeTaskInset$delegate = LazyKt.lazy((Function0)Companion.activeTaskInset.2.INSTANCE);
    }

    public static final /* synthetic */ void access$initStyleConstants(LessonMessagePane $this) {
        $this.initStyleConstants();
    }

    public static final /* synthetic */ Rectangle access$getRectangleToScroll(LessonMessagePane $this, LessonMessage lessonMessage) {
        return $this.getRectangleToScroll(lessonMessage);
    }

    public static final /* synthetic */ void access$showShortcutBalloon(LessonMessagePane $this, Point2D point, int height, String actionName) {
        $this.showShortcutBalloon(point, height, actionName);
    }

    public static final /* synthetic */ int access$letterHeight(LessonMessagePane $this, Font font, Graphics2D g, String str) {
        return $this.letterHeight(font, g, str);
    }

    public static final /* synthetic */ boolean access$getPanelMode$p(LessonMessagePane $this) {
        return $this.panelMode;
    }

    public static final /* synthetic */ RangeData access$getRangeDataForMouse(LessonMessagePane $this, MouseEvent me) {
        return $this.getRangeDataForMouse(me);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ltraining/ui/LessonMessagePane$MessageState;", "", "(Ljava/lang/String;I)V", "NORMAL", "PASSED", "INACTIVE", "RESTORE", "INFORMER", "intellij.featuresTrainer"})
    public static final class MessageState
    extends Enum<MessageState> {
        public static final /* enum */ MessageState NORMAL;
        public static final /* enum */ MessageState PASSED;
        public static final /* enum */ MessageState INACTIVE;
        public static final /* enum */ MessageState RESTORE;
        public static final /* enum */ MessageState INFORMER;
        private static final /* synthetic */ MessageState[] $VALUES;

        static {
            MessageState[] messageStateArray = new MessageState[5];
            MessageState[] messageStateArray2 = messageStateArray;
            messageStateArray[0] = NORMAL = new MessageState();
            messageStateArray[1] = PASSED = new MessageState();
            messageStateArray[2] = INACTIVE = new MessageState();
            messageStateArray[3] = RESTORE = new MessageState();
            messageStateArray[4] = INFORMER = new MessageState();
            $VALUES = messageStateArray;
        }

        public static MessageState[] values() {
            return (MessageState[])$VALUES.clone();
        }

        public static MessageState valueOf(String string) {
            return Enum.valueOf(MessageState.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J:\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Ltraining/ui/LessonMessagePane$MessageProperties;", "", "state", "Ltraining/ui/LessonMessagePane$MessageState;", "visualIndex", "", "useInternalParagraphStyle", "", "textProperties", "Ltraining/dsl/TaskTextProperties;", "(Ltraining/ui/LessonMessagePane$MessageState;Ljava/lang/Integer;ZLtraining/dsl/TaskTextProperties;)V", "getState", "()Ltraining/ui/LessonMessagePane$MessageState;", "getTextProperties", "()Ltraining/dsl/TaskTextProperties;", "getUseInternalParagraphStyle", "()Z", "getVisualIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "copy", "(Ltraining/ui/LessonMessagePane$MessageState;Ljava/lang/Integer;ZLtraining/dsl/TaskTextProperties;)Ltraining/ui/LessonMessagePane$MessageProperties;", "equals", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    public static final class MessageProperties {
        @NotNull
        private final MessageState state;
        @Nullable
        private final Integer visualIndex;
        private final boolean useInternalParagraphStyle;
        @Nullable
        private final TaskTextProperties textProperties;

        @NotNull
        public final MessageState getState() {
            return this.state;
        }

        @Nullable
        public final Integer getVisualIndex() {
            return this.visualIndex;
        }

        public final boolean getUseInternalParagraphStyle() {
            return this.useInternalParagraphStyle;
        }

        @Nullable
        public final TaskTextProperties getTextProperties() {
            return this.textProperties;
        }

        public MessageProperties(@NotNull MessageState state, @Nullable Integer visualIndex, boolean useInternalParagraphStyle, @Nullable TaskTextProperties textProperties) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.state = state;
            this.visualIndex = visualIndex;
            this.useInternalParagraphStyle = useInternalParagraphStyle;
            this.textProperties = textProperties;
        }

        public /* synthetic */ MessageProperties(MessageState messageState, Integer n, boolean bl, TaskTextProperties taskTextProperties, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                messageState = MessageState.NORMAL;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                taskTextProperties = null;
            }
            this(messageState, n, bl, taskTextProperties);
        }

        public MessageProperties() {
            this(null, null, false, null, 15, null);
        }

        @NotNull
        public final MessageState component1() {
            return this.state;
        }

        @Nullable
        public final Integer component2() {
            return this.visualIndex;
        }

        public final boolean component3() {
            return this.useInternalParagraphStyle;
        }

        @Nullable
        public final TaskTextProperties component4() {
            return this.textProperties;
        }

        @NotNull
        public final MessageProperties copy(@NotNull MessageState state, @Nullable Integer visualIndex, boolean useInternalParagraphStyle, @Nullable TaskTextProperties textProperties) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            return new MessageProperties(state, visualIndex, useInternalParagraphStyle, textProperties);
        }

        public static /* synthetic */ MessageProperties copy$default(MessageProperties messageProperties, MessageState messageState, Integer n, boolean bl, TaskTextProperties taskTextProperties, int n2, Object object) {
            if ((n2 & 1) != 0) {
                messageState = messageProperties.state;
            }
            if ((n2 & 2) != 0) {
                n = messageProperties.visualIndex;
            }
            if ((n2 & 4) != 0) {
                bl = messageProperties.useInternalParagraphStyle;
            }
            if ((n2 & 8) != 0) {
                taskTextProperties = messageProperties.textProperties;
            }
            return messageProperties.copy(messageState, n, bl, taskTextProperties);
        }

        @NotNull
        public String toString() {
            return "MessageProperties(state=" + (Object)((Object)this.state) + ", visualIndex=" + this.visualIndex + ", useInternalParagraphStyle=" + this.useInternalParagraphStyle + ", textProperties=" + this.textProperties + ")";
        }

        public int hashCode() {
            MessageState messageState = this.state;
            Integer n = this.visualIndex;
            int n2 = ((messageState != null ? ((Object)((Object)messageState)).hashCode() : 0) * 31 + (n != null ? ((Object)n).hashCode() : 0)) * 31;
            int n3 = this.useInternalParagraphStyle ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            TaskTextProperties taskTextProperties = this.textProperties;
            return (n2 + n3) * 31 + (taskTextProperties != null ? ((Object)taskTextProperties).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MessageProperties)) break block3;
                    MessageProperties messageProperties = (MessageProperties)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)messageProperties.state)) || !Intrinsics.areEqual((Object)this.visualIndex, (Object)messageProperties.visualIndex) || this.useInternalParagraphStyle != messageProperties.useInternalParagraphStyle || !Intrinsics.areEqual((Object)this.textProperties, (Object)messageProperties.textProperties)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010!J\t\u0010&\u001a\u00020\nH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J^\u0010*\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00020\n2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\bH\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u001a\u0010\u000e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Ltraining/ui/LessonMessagePane$LessonMessage;", "", "messageParts", "", "Ltraining/ui/MessagePart;", "state", "Ltraining/ui/LessonMessagePane$MessageState;", "visualIndex", "", "useInternalParagraphStyle", "", "textProperties", "Ltraining/dsl/TaskTextProperties;", "start", "end", "(Ljava/util/List;Ltraining/ui/LessonMessagePane$MessageState;Ljava/lang/Integer;ZLtraining/dsl/TaskTextProperties;II)V", "getEnd", "()I", "setEnd", "(I)V", "getMessageParts", "()Ljava/util/List;", "getStart", "setStart", "getState", "()Ltraining/ui/LessonMessagePane$MessageState;", "setState", "(Ltraining/ui/LessonMessagePane$MessageState;)V", "getTextProperties", "()Ltraining/dsl/TaskTextProperties;", "getUseInternalParagraphStyle", "()Z", "getVisualIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/util/List;Ltraining/ui/LessonMessagePane$MessageState;Ljava/lang/Integer;ZLtraining/dsl/TaskTextProperties;II)Ltraining/ui/LessonMessagePane$LessonMessage;", "equals", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    private static final class LessonMessage {
        @NotNull
        private final List<MessagePart> messageParts;
        @NotNull
        private MessageState state;
        @Nullable
        private final Integer visualIndex;
        private final boolean useInternalParagraphStyle;
        @Nullable
        private final TaskTextProperties textProperties;
        private int start;
        private int end;

        @NotNull
        public final List<MessagePart> getMessageParts() {
            return this.messageParts;
        }

        @NotNull
        public final MessageState getState() {
            return this.state;
        }

        public final void setState(@NotNull MessageState messageState) {
            Intrinsics.checkNotNullParameter((Object)((Object)messageState), (String)"<set-?>");
            this.state = messageState;
        }

        @Nullable
        public final Integer getVisualIndex() {
            return this.visualIndex;
        }

        public final boolean getUseInternalParagraphStyle() {
            return this.useInternalParagraphStyle;
        }

        @Nullable
        public final TaskTextProperties getTextProperties() {
            return this.textProperties;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        public LessonMessage(@NotNull List<MessagePart> messageParts, @NotNull MessageState state, @Nullable Integer visualIndex, boolean useInternalParagraphStyle, @Nullable TaskTextProperties textProperties, int start, int end) {
            Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.messageParts = messageParts;
            this.state = state;
            this.visualIndex = visualIndex;
            this.useInternalParagraphStyle = useInternalParagraphStyle;
            this.textProperties = textProperties;
            this.start = start;
            this.end = end;
        }

        public /* synthetic */ LessonMessage(List list2, MessageState messageState, Integer n, boolean bl, TaskTextProperties taskTextProperties, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x20) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x40) != 0) {
                n3 = 0;
            }
            this(list2, messageState, n, bl, taskTextProperties, n2, n3);
        }

        @NotNull
        public final List<MessagePart> component1() {
            return this.messageParts;
        }

        @NotNull
        public final MessageState component2() {
            return this.state;
        }

        @Nullable
        public final Integer component3() {
            return this.visualIndex;
        }

        public final boolean component4() {
            return this.useInternalParagraphStyle;
        }

        @Nullable
        public final TaskTextProperties component5() {
            return this.textProperties;
        }

        public final int component6() {
            return this.start;
        }

        public final int component7() {
            return this.end;
        }

        @NotNull
        public final LessonMessage copy(@NotNull List<MessagePart> messageParts, @NotNull MessageState state, @Nullable Integer visualIndex, boolean useInternalParagraphStyle, @Nullable TaskTextProperties textProperties, int start, int end) {
            Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            return new LessonMessage(messageParts, state, visualIndex, useInternalParagraphStyle, textProperties, start, end);
        }

        public static /* synthetic */ LessonMessage copy$default(LessonMessage lessonMessage, List list2, MessageState messageState, Integer n, boolean bl, TaskTextProperties taskTextProperties, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                list2 = lessonMessage.messageParts;
            }
            if ((n4 & 2) != 0) {
                messageState = lessonMessage.state;
            }
            if ((n4 & 4) != 0) {
                n = lessonMessage.visualIndex;
            }
            if ((n4 & 8) != 0) {
                bl = lessonMessage.useInternalParagraphStyle;
            }
            if ((n4 & 0x10) != 0) {
                taskTextProperties = lessonMessage.textProperties;
            }
            if ((n4 & 0x20) != 0) {
                n2 = lessonMessage.start;
            }
            if ((n4 & 0x40) != 0) {
                n3 = lessonMessage.end;
            }
            return lessonMessage.copy(list2, messageState, n, bl, taskTextProperties, n2, n3);
        }

        @NotNull
        public String toString() {
            return "LessonMessage(messageParts=" + this.messageParts + ", state=" + (Object)((Object)this.state) + ", visualIndex=" + this.visualIndex + ", useInternalParagraphStyle=" + this.useInternalParagraphStyle + ", textProperties=" + this.textProperties + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            List<MessagePart> list2 = this.messageParts;
            MessageState messageState = this.state;
            Integer n = this.visualIndex;
            int n2 = (((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (messageState != null ? ((Object)((Object)messageState)).hashCode() : 0)) * 31 + (n != null ? ((Object)n).hashCode() : 0)) * 31;
            int n3 = this.useInternalParagraphStyle ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            TaskTextProperties taskTextProperties = this.textProperties;
            return (((n2 + n3) * 31 + (taskTextProperties != null ? ((Object)taskTextProperties).hashCode() : 0)) * 31 + Integer.hashCode(this.start)) * 31 + Integer.hashCode(this.end);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LessonMessage)) break block3;
                    LessonMessage lessonMessage = (LessonMessage)object;
                    if (!Intrinsics.areEqual(this.messageParts, lessonMessage.messageParts) || !Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)lessonMessage.state)) || !Intrinsics.areEqual((Object)this.visualIndex, (Object)lessonMessage.visualIndex) || this.useInternalParagraphStyle != lessonMessage.useInternalParagraphStyle || !Intrinsics.areEqual((Object)this.textProperties, (Object)lessonMessage.textProperties) || this.start != lessonMessage.start || this.end != lessonMessage.end) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J/\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Ltraining/ui/LessonMessagePane$RangeData;", "", "range", "Lkotlin/ranges/IntRange;", "action", "Lkotlin/Function2;", "Ljava/awt/Point;", "", "", "(Lkotlin/ranges/IntRange;Lkotlin/jvm/functions/Function2;)V", "getAction", "()Lkotlin/jvm/functions/Function2;", "getRange", "()Lkotlin/ranges/IntRange;", "setRange", "(Lkotlin/ranges/IntRange;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    private static final class RangeData {
        @NotNull
        private IntRange range;
        @NotNull
        private final Function2<Point, Integer, Unit> action;

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        public final void setRange(@NotNull IntRange intRange) {
            Intrinsics.checkNotNullParameter((Object)intRange, (String)"<set-?>");
            this.range = intRange;
        }

        @NotNull
        public final Function2<Point, Integer, Unit> getAction() {
            return this.action;
        }

        public RangeData(@NotNull IntRange range, @NotNull Function2<? super Point, ? super Integer, Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            this.range = range;
            this.action = action2;
        }

        @NotNull
        public final IntRange component1() {
            return this.range;
        }

        @NotNull
        public final Function2<Point, Integer, Unit> component2() {
            return this.action;
        }

        @NotNull
        public final RangeData copy(@NotNull IntRange range, @NotNull Function2<? super Point, ? super Integer, Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            return new RangeData(range, action2);
        }

        public static /* synthetic */ RangeData copy$default(RangeData rangeData, IntRange intRange, Function2 function2, int n, Object object) {
            if ((n & 1) != 0) {
                intRange = rangeData.range;
            }
            if ((n & 2) != 0) {
                function2 = rangeData.action;
            }
            return rangeData.copy(intRange, function2);
        }

        @NotNull
        public String toString() {
            return "RangeData(range=" + this.range + ", action=" + this.action + ")";
        }

        public int hashCode() {
            IntRange intRange = this.range;
            Function2<Point, Integer, Unit> function2 = this.action;
            return (intRange != null ? intRange.hashCode() : 0) * 31 + (function2 != null ? function2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RangeData)) break block3;
                    RangeData rangeData = (RangeData)object;
                    if (!Intrinsics.areEqual((Object)this.range, (Object)rangeData.range) || !Intrinsics.areEqual(this.action, rangeData.action)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ltraining/ui/LessonMessagePane$FontSearchResult;", "", "numberFont", "Ljava/awt/Font;", "numberHeight", "", "textLetterHeight", "(Ljava/awt/Font;II)V", "getNumberFont", "()Ljava/awt/Font;", "getNumberHeight", "()I", "getTextLetterHeight", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.featuresTrainer"})
    private static final class FontSearchResult {
        @NotNull
        private final Font numberFont;
        private final int numberHeight;
        private final int textLetterHeight;

        @NotNull
        public final Font getNumberFont() {
            return this.numberFont;
        }

        public final int getNumberHeight() {
            return this.numberHeight;
        }

        public final int getTextLetterHeight() {
            return this.textLetterHeight;
        }

        public FontSearchResult(@NotNull Font numberFont, int numberHeight, int textLetterHeight) {
            Intrinsics.checkNotNullParameter((Object)numberFont, (String)"numberFont");
            this.numberFont = numberFont;
            this.numberHeight = numberHeight;
            this.textLetterHeight = textLetterHeight;
        }

        @NotNull
        public final Font component1() {
            return this.numberFont;
        }

        public final int component2() {
            return this.numberHeight;
        }

        public final int component3() {
            return this.textLetterHeight;
        }

        @NotNull
        public final FontSearchResult copy(@NotNull Font numberFont, int numberHeight, int textLetterHeight) {
            Intrinsics.checkNotNullParameter((Object)numberFont, (String)"numberFont");
            return new FontSearchResult(numberFont, numberHeight, textLetterHeight);
        }

        public static /* synthetic */ FontSearchResult copy$default(FontSearchResult fontSearchResult, Font font, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                font = fontSearchResult.numberFont;
            }
            if ((n3 & 2) != 0) {
                n = fontSearchResult.numberHeight;
            }
            if ((n3 & 4) != 0) {
                n2 = fontSearchResult.textLetterHeight;
            }
            return fontSearchResult.copy(font, n, n2);
        }

        @NotNull
        public String toString() {
            return "FontSearchResult(numberFont=" + this.numberFont + ", numberHeight=" + this.numberHeight + ", textLetterHeight=" + this.textLetterHeight + ")";
        }

        public int hashCode() {
            Font font = this.numberFont;
            return ((font != null ? ((Object)font).hashCode() : 0) * 31 + Integer.hashCode(this.numberHeight)) * 31 + Integer.hashCode(this.textLetterHeight);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FontSearchResult)) break block3;
                    FontSearchResult fontSearchResult = (FontSearchResult)object;
                    if (!Intrinsics.areEqual((Object)this.numberFont, (Object)fontSearchResult.numberFont) || this.numberHeight != fontSearchResult.numberHeight || this.textLetterHeight != fontSearchResult.textLetterHeight) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0018"}, d2={"Ltraining/ui/LessonMessagePane$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "activeTaskInset", "", "getActiveTaskInset", "()I", "activeTaskInset$delegate", "Lkotlin/Lazy;", "arc", "getArc", "arc$delegate", "indent", "getIndent", "indent$delegate", "toPoint", "Ljava/awt/Point;", "Ljava/awt/geom/Point2D;", "toRectangle", "Ljava/awt/Rectangle;", "Ljava/awt/geom/Rectangle2D;", "intellij.featuresTrainer"})
    public static final class Companion {
        private final int getArc() {
            Lazy lazy = arc$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return ((Number)lazy.getValue()).intValue();
        }

        private final int getIndent() {
            Lazy lazy = indent$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return ((Number)lazy.getValue()).intValue();
        }

        private final int getActiveTaskInset() {
            Lazy lazy = activeTaskInset$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return ((Number)lazy.getValue()).intValue();
        }

        private final Point toPoint(Point2D $this$toPoint) {
            return new Point(MathKt.roundToInt((double)$this$toPoint.getX()), MathKt.roundToInt((double)$this$toPoint.getY()));
        }

        private final Rectangle toRectangle(Rectangle2D $this$toRectangle) {
            return new Rectangle(MathKt.roundToInt((double)$this$toRectangle.getX()), MathKt.roundToInt((double)$this$toRectangle.getY()), MathKt.roundToInt((double)$this$toRectangle.getWidth()), MathKt.roundToInt((double)$this$toRectangle.getHeight()));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

