/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.fest.swing.timing.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.actions.ChooseProgrammingLanguageForLearningAction;
import training.lang.LangManager;
import training.learn.LearnBundle;
import training.learn.lesson.LessonManager;
import training.ui.LearnToolWindow;
import training.ui.LearningUiUtil;
import training.ui.StepAnimator;
import training.ui.views.LearnPanel;
import training.ui.views.ModulesPanel;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\r\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u001fH\u0002J\u0010\u0010\"\u001a\n $*\u0004\u0018\u00010#0#H\u0002J\u0015\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020\u001fH\u0002J\r\u0010-\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b0J\r\u00101\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b2J\b\u00103\u001a\u00020\u001fH\u0002J\b\u00104\u001a\u000205H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ltraining/ui/LearnToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "wholeToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "learnPanel", "Ltraining/ui/views/LearnPanel;", "getLearnPanel$intellij_featuresTrainer", "()Ltraining/ui/views/LearnPanel;", "modulesPanel", "Ltraining/ui/views/ModulesPanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getParentDisposable$intellij_featuresTrainer", "()Lcom/intellij/openapi/Disposable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "stepAnimator", "Ltraining/ui/StepAnimator;", "getStepAnimator", "()Ltraining/ui/StepAnimator;", "stepAnimator$delegate", "Lkotlin/Lazy;", "getVisibleAreaWidth", "", "reinitViews", "", "reinitViews$intellij_featuresTrainer", "reinitViewsInternal", "restartAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlin.jvm.PlatformType", "scrollTo", "needTo", "scrollTo$intellij_featuresTrainer", "scrollToTheEnd", "scrollToTheEnd$intellij_featuresTrainer", "scrollToTheStart", "scrollToTheStart$intellij_featuresTrainer", "setChooseLanguageButton", "setLearnPanel", "setLearnPanel$intellij_featuresTrainer", "setModulesPanel", "setModulesPanel$intellij_featuresTrainer", "showGotItAboutRestart", "showGotItAboutRestart$intellij_featuresTrainer", "updateScrollPane", "useAnimation", "", "intellij.featuresTrainer"})
public final class LearnToolWindow
extends SimpleToolWindowPanel
implements DataProvider {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final LearnPanel learnPanel;
    private final ModulesPanel modulesPanel;
    private final JBScrollPane scrollPane;
    private final Lazy stepAnimator$delegate;
    @NotNull
    private final Project project;
    private final ToolWindow wholeToolWindow;

    @NotNull
    public final Disposable getParentDisposable$intellij_featuresTrainer() {
        return this.parentDisposable;
    }

    @NotNull
    public final LearnPanel getLearnPanel$intellij_featuresTrainer() {
        return this.learnPanel;
    }

    private final StepAnimator getStepAnimator() {
        Lazy lazy = this.stepAnimator$delegate;
        LearnToolWindow learnToolWindow = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StepAnimator)lazy.getValue();
    }

    public final int getVisibleAreaWidth() {
        Serializable serializable = this.scrollPane.getVerticalScrollBar();
        int scrollWidth = serializable != null && (serializable = serializable.getSize()) != null ? ((Dimension)serializable).width : 0;
        JViewport jViewport = this.scrollPane.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"scrollPane.viewport");
        return jViewport.getExtentSize().width - scrollWidth;
    }

    private final void reinitViewsInternal() {
        this.modulesPanel.updateMainPanel();
    }

    public final void setLearnPanel$intellij_featuresTrainer() {
        this.wholeToolWindow.setTitleActions(CollectionsKt.listOf((Object)this.restartAction()));
        this.scrollPane.setViewportView((Component)this.learnPanel);
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public final void showGotItAboutRestart$intellij_featuresTrainer() {
        GotItTooltip gotIt = new GotItTooltip("reset.lesson.got.it", LearnBundle.INSTANCE.message("completed.lessons.got.it", new Object[0]), this.parentDisposable);
        if (gotIt.canShow()) {
            AnAction anAction = this.restartAction();
            if (anAction == null) {
                return;
            }
            AnAction needToFindButton = anAction;
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, needToFindButton, gotIt){
                final /* synthetic */ LearnToolWindow this$0;
                final /* synthetic */ AnAction $needToFindButton;
                final /* synthetic */ GotItTooltip $gotIt;

                public final void run() {
                    Project project = this.this$0.getProject();
                    Timeout timeout = Timeout.timeout((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"Timeout.timeout(500, TimeUnit.MILLISECONDS)");
                    ActionButton button2 = (ActionButton)LearningUiUtil.findShowingComponentWithTimeout$default(LearningUiUtil.INSTANCE, project, ActionButton.class, timeout, null, (Function1)new Function1<ActionButton, Boolean>(this){
                        final /* synthetic */ showGotItAboutRestart.1 this$0;

                        public final boolean invoke(@NotNull ActionButton it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it.getAction(), (Object)this.this$0.$needToFindButton);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, 8, null);
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(this, button2){
                        final /* synthetic */ showGotItAboutRestart.1 this$0;
                        final /* synthetic */ ActionButton $button$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$button$inlined = actionButton;
                        }

                        public final void run() {
                            boolean bl = false;
                            this.this$0.$gotIt.show((JComponent)this.$button$inlined, GotItTooltip.BOTTOM_MIDDLE);
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                }
                {
                    this.this$0 = learnToolWindow;
                    this.$needToFindButton = anAction;
                    this.$gotIt = gotItTooltip;
                }
            });
        }
    }

    private final AnAction restartAction() {
        return ActionManager.getInstance().getAction("RestartLessonAction");
    }

    public final void setModulesPanel$intellij_featuresTrainer() {
        this.setChooseLanguageButton();
        this.modulesPanel.updateMainPanel();
        this.scrollPane.setViewportView((Component)this.modulesPanel);
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    private final void setChooseLanguageButton() {
        Collection collection = LangManager.Companion.getInstance().getSupportedLanguagesExtensions();
        boolean bl = false;
        if (!collection.isEmpty() && LangManager.Companion.getInstance().getSupportedLanguagesExtensions().size() > 1) {
            this.wholeToolWindow.setTitleActions(CollectionsKt.listOf((Object)((Object)new ChooseProgrammingLanguageForLearningAction(this))));
        }
    }

    private final void updateScrollPane() {
        this.scrollPane.getViewport().revalidate();
        this.scrollPane.getViewport().repaint();
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public final void reinitViews$intellij_featuresTrainer() {
        this.reinitViewsInternal();
        this.updateScrollPane();
    }

    public final void scrollToTheEnd$intellij_featuresTrainer() {
        JScrollBar vertical = this.scrollPane.getVerticalScrollBar();
        if (this.useAnimation()) {
            StepAnimator stepAnimator2 = this.getStepAnimator();
            JScrollBar jScrollBar = vertical;
            Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"vertical");
            stepAnimator2.startAnimation(jScrollBar.getMaximum());
        } else {
            JScrollBar jScrollBar = vertical;
            Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"vertical");
            jScrollBar.setValue(vertical.getMaximum());
        }
    }

    public final void scrollToTheStart$intellij_featuresTrainer() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
        jScrollBar.setValue(0);
    }

    public final void scrollTo$intellij_featuresTrainer(int needTo) {
        if (this.useAnimation()) {
            this.getStepAnimator().startAnimation(needTo);
        } else {
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
            jScrollBar.setValue(needTo);
        }
    }

    private final boolean useAnimation() {
        return Registry.is((String)"ift.use.scroll.animation", (boolean)false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public LearnToolWindow(@NotNull Project project, @NotNull ToolWindow wholeToolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)wholeToolWindow, (String)"wholeToolWindow");
        super(true, true);
        this.project = project;
        this.wholeToolWindow = wholeToolWindow;
        Disposable disposable = this.wholeToolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"wholeToolWindow.disposable");
        this.parentDisposable = disposable;
        this.learnPanel = new LearnPanel(this);
        this.modulesPanel = new ModulesPanel(this.project);
        this.scrollPane = LangManager.Companion.getInstance().getLanguages().isEmpty() ? new JBScrollPane((Component)new JLabel(LearnBundle.INSTANCE.message("no.supported.languages.found", new Object[0]))) : new JBScrollPane((Component)this.modulesPanel);
        this.stepAnimator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StepAnimator>(this){
            final /* synthetic */ LearnToolWindow this$0;

            @NotNull
            public final StepAnimator invoke() {
                JScrollBar jScrollBar = LearnToolWindow.access$getScrollPane$p(this.this$0).getVerticalScrollBar();
                Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
                return new StepAnimator(jScrollBar, this.this$0.getLearnPanel$intellij_featuresTrainer().getLessonMessagePane());
            }
            {
                this.this$0 = learnToolWindow;
                super(0);
            }
        }));
        this.setChooseLanguageButton();
        this.reinitViewsInternal();
        if (LessonManager.Companion.getInstance().lessonIsRunning$intellij_featuresTrainer()) {
            this.setLearnPanel$intellij_featuresTrainer();
        }
        this.setContent((JComponent)this.scrollPane);
        this.scrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                JViewport jViewport = scrollPane.getViewport();
                Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"scrollPane.viewport");
                if (Intrinsics.areEqual((Object)jViewport.getView(), (Object)this.getLearnPanel$intellij_featuresTrainer())) {
                    this.getLearnPanel$intellij_featuresTrainer().updatePanelSize(this.getVisibleAreaWidth());
                }
            }
        });
    }
}

