/*
 * Decompiled with CFR 0.152.
 */
package training.editor;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import java.lang.ref.WeakReference;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.learn.lesson.LessonManager;
import training.util.PerformActionUtil;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ltraining/editor/LearnProjectFileEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "langSupport", "Ltraining/lang/LangSupport;", "getLangSupport", "()Ltraining/lang/LangSupport;", "ref", "Ljava/lang/ref/WeakReference;", "getRef", "()Ljava/lang/ref/WeakReference;", "ref$delegate", "Lkotlin/Lazy;", "fileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.featuresTrainer"})
final class LearnProjectFileEditorListener
implements FileEditorManagerListener {
    private final Lazy ref$delegate;

    private final WeakReference<LangSupport> getRef() {
        Lazy lazy = this.ref$delegate;
        LearnProjectFileEditorListener learnProjectFileEditorListener = this;
        Object var3_3 = null;
        boolean bl = false;
        return (WeakReference)lazy.getValue();
    }

    private final LangSupport getLangSupport() {
        return (LangSupport)this.getRef().get();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LangSupport langSupport2 = this.getLangSupport();
        if (langSupport2 == null) {
            return;
        }
        LangSupport langSupport3 = langSupport2;
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"source.project");
        Project project2 = project;
        if (ScratchUtil.isScratch((VirtualFile)file)) {
            return;
        }
        if (!langSupport3.blockProjectFileModification(project2, file)) {
            return;
        }
        FileEditor[] fileEditorArray = source.getAllEditors(file);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"source.getAllEditors(file)");
        FileEditor[] $this$forEach$iv = fileEditorArray;
        boolean $i$f$forEach = false;
        FileEditor[] fileEditorArray2 = $this$forEach$iv;
        int n = fileEditorArray2.length;
        for (int j = 0; j < n; ++j) {
            EditorEx editorEx;
            FileEditor element$iv;
            FileEditor it = element$iv = fileEditorArray2[j];
            boolean bl = false;
            FileEditor fileEditor = it;
            if (!(fileEditor instanceof TextEditor)) {
                fileEditor = null;
            }
            TextEditor textEditor = (TextEditor)fileEditor;
            Object object = textEditor != null ? textEditor.getEditor() : null;
            if (!(object instanceof EditorEx)) {
                object = null;
            }
            if ((EditorEx)object == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            EditorEx editorEx2 = editorEx;
            boolean bl4 = false;
            HyperlinkListener listener2 = new HyperlinkListener(editorEx2, project2){
                final /* synthetic */ EditorEx $editorEx;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$editorEx = editorEx;
                    this.$project$inlined = project;
                }

                public final void hyperlinkUpdate(HyperlinkEvent event) {
                    HyperlinkEvent hyperlinkEvent = event;
                    Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"event");
                    if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        String string = event.getDescription();
                        if (string != null) {
                            switch (string) {
                                case "ift.close": {
                                    PerformActionUtil.performAction$default(PerformActionUtil.INSTANCE, "CloseProject", (Editor)this.$editorEx, this.$project$inlined, false, null, 16, null);
                                    break;
                                }
                                case "ift.toolwindow": {
                                    ToolWindow toolWindow = UtilsKt.learningToolWindow(this.$project$inlined);
                                    if (toolWindow != null) {
                                        toolWindow.show();
                                    }
                                    LessonManager.Companion.getInstance().focusTask();
                                }
                            }
                        }
                    }
                }
            };
            String hint = LearnBundle.INSTANCE.message("learn.project.read.only.hint", LearnBundle.INSTANCE.message("toolwindow.stripe.Learn", new Object[0]));
            EditorModificationUtil.setReadOnlyHint((Editor)((Editor)editorEx2), (String)hint, (HyperlinkListener)listener2);
            editorEx2.setViewer(true);
        }
    }

    public LearnProjectFileEditorListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.ref$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WeakReference<LangSupport>>(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final WeakReference<LangSupport> invoke() {
                return new WeakReference<LangSupport>(UtilsKt.findLanguageSupport(this.$project));
            }
            {
                this.$project = project;
                super(0);
            }
        }));
    }
}

