/*
 * Decompiled with CFR 0.152.
 */
package training.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.learn.CourseManager;
import training.learn.course.Lesson;
import training.statistic.StatisticBase;
import training.ui.LearnToolWindowFactory;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Ltraining/actions/NextLessonAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.featuresTrainer"})
final class NextLessonAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        if (LearnToolWindowFactory.Companion.getLearnWindowPerProject().get(project2) == null) {
            return;
        }
        Lesson lesson = UtilsKt.getNextLessonForCurrent();
        if (lesson == null) {
            return;
        }
        Lesson nextLesson = lesson;
        StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.OPEN_NEXT_OR_PREV_LESSON);
        CourseManager.openLesson$default(CourseManager.Companion.getInstance(), project2, nextLesson, false, 4, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Lesson lesson = UtilsKt.lessonOpenedInProject(project);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(lesson != null && Intrinsics.areEqual((Object)((Lesson)CollectionsKt.lastOrNull(CourseManager.Companion.getInstance().getLessonsForModules())), (Object)lesson) ^ true);
    }

    public NextLessonAction() {
        super(AllIcons.Actions.Forward);
    }
}

