/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.lists.ListItemInfo;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListItemUnindentHandler;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListIndentBackspaceHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "deletedRange", "Lcom/intellij/openapi/util/TextRange;", "listItem", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl;", "moveCaret", "", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "indentLevels", "Lkotlin/sequences/Sequence;", "", "aboveItem", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.markdown"})
public final class MarkdownListIndentBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    private TextRange deletedRange;
    private MarkdownListItemImpl listItem;
    private boolean moveCaret;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Object v5;
        int indent;
        int lineStart;
        block10: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.deletedRange = null;
            this.listItem = null;
            this.moveCaret = false;
            if (!(file instanceof MarkdownFile) || !CharsKt.isWhitespace((char)c)) {
                return;
            }
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document document2 = document;
            PsiDocumentManager.getInstance((Project)((MarkdownFile)file).getProject()).commitDocument(document2);
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            int caretOffset = caretModel.getOffset();
            int line = document2.getLineNumber(caretOffset);
            if (line == 0) {
                return;
            }
            lineStart = document2.getLineStartOffset(line);
            String string = document2.getText(TextRange.create((int)lineStart, (int)caretOffset));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRan\u2026(lineStart, caretOffset))");
            CharSequence charSequence = string;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                return;
            }
            CaretModel caretModel2 = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"editor.caretModel");
            indent = caretModel2.getLogicalPosition().column;
            if (indent == 0) {
                return;
            }
            MarkdownListItemImpl item = ListUtils.INSTANCE.getListItemAtLine((MarkdownFile)file, line, document2);
            if (item != null && document2.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)item))) == line) {
                this.listItem = item;
                return;
            }
            MarkdownListItemImpl markdownListItemImpl = ListUtils.INSTANCE.getListItemAtLine((MarkdownFile)file, line - 1, document2);
            if (markdownListItemImpl == null) {
                markdownListItemImpl = ListUtils.INSTANCE.getListItemAtLineSafely((MarkdownFile)file, line - 2, document2);
            }
            if (markdownListItemImpl == null) {
                return;
            }
            MarkdownListItemImpl aboveItem = markdownListItemImpl;
            if (indent + document2.getLineStartOffset(line) > document2.getLineEndOffset(line)) {
                this.moveCaret = true;
                return;
            }
            Sequence<Integer> sequence = this.indentLevels(aboveItem, document2);
            boolean bl2 = false;
            Sequence<Integer> sequence2 = sequence;
            boolean bl3 = false;
            for (Object e : sequence2) {
                int it = ((Number)e).intValue();
                boolean bl4 = false;
                if (!(it < indent)) continue;
                v5 = e;
                break block10;
            }
            v5 = null;
        }
        Integer n = v5;
        if (n == null) {
            return;
        }
        int wantedIndent = n;
        this.deletedRange = TextRange.from((int)(lineStart + wantedIndent), (int)(indent - wantedIndent));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<Integer> indentLevels(MarkdownListItemImpl aboveItem, Document document) {
        void $this$parentsOfType$iv;
        PsiElement psiElement = (PsiElement)aboveItem;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        return SequencesKt.map((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, MarkdownListItemImpl.class, (boolean)withSelf$iv), (Function1)((Function1)new Function1<MarkdownListItemImpl, Integer>(document){
            final /* synthetic */ Document $document;

            public final int invoke(@NotNull MarkdownListItemImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ListItemInfo(it, this.$document).getIndentInfo().getIndent();
            }
            {
                this.$document = document;
                super(1);
            }
        }));
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (this.listItem != null) {
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(editor2, c){
                final /* synthetic */ Editor $editor$inlined;
                final /* synthetic */ char $c$inlined;
                {
                    this.$editor$inlined = editor2;
                    this.$c$inlined = c;
                }

                public final T compute() {
                    boolean bl = false;
                    EditorModificationUtil.insertStringAtCaret((Editor)this.$editor$inlined, (String)String.valueOf(this.$c$inlined));
                    return (T)Unit.INSTANCE;
                }
            });
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor2.getDocument());
            MarkdownListItemUnindentHandler unindentHandler = new MarkdownListItemUnindentHandler(null);
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            unindentHandler.execute(editor2, caretModel.getCurrentCaret(), null);
            return true;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        if (this.moveCaret) {
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            int line = document2.getLineNumber(caretModel.getOffset());
            editor2.getCaretModel().moveToOffset(document2.getLineEndOffset(line));
            return true;
        }
        TextRange textRange = this.deletedRange;
        if (textRange == null) {
            return false;
        }
        TextRange deletedRange = textRange;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int line = document2.getLineNumber(caretModel.getOffset());
        TextRange indentRange = ListUtils.INSTANCE.getLineIndentRange(document2, line);
        String string = ListUtils.INSTANCE.getLineIndentSpaces(document2, line, file);
        Intrinsics.checkNotNull((Object)string);
        String realIndent = string;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(indentRange, realIndent, editor2, deletedRange){
            final /* synthetic */ TextRange $indentRange$inlined;
            final /* synthetic */ String $realIndent$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ TextRange $deletedRange$inlined;
            {
                this.$indentRange$inlined = textRange;
                this.$realIndent$inlined = string;
                this.$editor$inlined = editor2;
                this.$deletedRange$inlined = textRange2;
            }

            public final T compute() {
                boolean bl = false;
                if (this.$indentRange$inlined.getLength() < this.$realIndent$inlined.length()) {
                    this.$editor$inlined.getDocument().replaceString(this.$indentRange$inlined.getStartOffset(), this.$indentRange$inlined.getEndOffset(), (CharSequence)this.$realIndent$inlined);
                }
                this.$editor$inlined.getDocument().deleteString(this.$deletedRange$inlined.getStartOffset(), this.$deletedRange$inlined.getEndOffset() - 1);
                return (T)Unit.INSTANCE;
            }
        });
        return true;
    }
}

