/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentInfo;
import org.intellij.plugins.markdown.editor.lists.ListItemInfo;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001d\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0082\u0002J(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\"\u0010\u001d\u001a\u00020\u001e*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListRenumberUtils;", "", "()V", "renumberingReplacements", "Lkotlin/sequences/Sequence;", "Lorg/intellij/plugins/markdown/editor/lists/Replacement;", "list", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListImpl;", "listIndentInfo", "Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "recursive", "", "restart", "changeContentLinesIndent", "", "lines", "Lkotlin/ranges/IntRange;", "newIndent", "", "plus", "Ljava/lang/StringBuilder;", "kotlin.jvm.PlatformType", "", "other", "renumber", "renumberInBulk", "", "intellij.markdown"})
public final class ListRenumberUtils {
    @NotNull
    public static final ListRenumberUtils INSTANCE;

    public final void renumberInBulk(@NotNull MarkdownListImpl $this$renumberInBulk, @NotNull Document document, boolean recursive, boolean restart) {
        Intrinsics.checkNotNullParameter((Object)$this$renumberInBulk, (String)"$this$renumberInBulk");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        List<Replacement> replacementList = this.renumber($this$renumberInBulk, document, recursive, restart);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(replacementList, document){
            final /* synthetic */ List $replacementList$inlined;
            final /* synthetic */ Document $document$inlined;
            {
                this.$replacementList$inlined = list;
                this.$document$inlined = document;
            }

            public final T compute() {
                boolean bl = false;
                Replacement.Companion.replaceAllInBulk$intellij_markdown(this.$replacementList$inlined, this.$document$inlined);
                return (T)Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final List<Replacement> renumber(@NotNull MarkdownListImpl $this$renumber, @NotNull Document document, boolean recursive, boolean restart) {
        Intrinsics.checkNotNullParameter((Object)$this$renumber, (String)"$this$renumber");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int line = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)$this$renumber)));
        String string = ListUtils.INSTANCE.getLineIndentSpaces(document, line, $this$renumber.getContainingFile());
        Intrinsics.checkNotNull((Object)string);
        int firstIndent = string.length();
        ListItemIndentInfo listItemIndentInfo = new ListItemIndentInfo(firstIndent, 0);
        PsiFile psiFile = $this$renumber.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"containingFile");
        return SequencesKt.toList(this.renumberingReplacements($this$renumber, listItemIndentInfo, document, psiFile, recursive, restart));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<Replacement> renumberingReplacements(MarkdownListImpl list, ListItemIndentInfo listIndentInfo, Document document, PsiFile file, boolean recursive, boolean restart) {
        Integer n;
        String firstMarker = ListUtils.INSTANCE.getNormalizedMarker((MarkdownListItemImpl)CollectionsKt.first(ListUtils.INSTANCE.getItems(list)));
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)list)), (Object)MarkdownElementTypes.ORDERED_LIST) ^ true) {
            n = null;
        } else if (restart) {
            n = 1;
        } else {
            String string = firstMarker;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = StringsKt.dropLast((String)((Object)StringsKt.trim((CharSequence)string2)).toString(), (int)1);
            bl = false;
            n = Integer.parseInt(string);
        }
        Integer start = n;
        String string = firstMarker;
        boolean bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        char markerFlavor = StringsKt.last((CharSequence)((Object)StringsKt.trim((CharSequence)string3)).toString());
        Sequence sequence = SequencesKt.sequenceOf((Object[])new Replacement[0]);
        bl = false;
        for (MarkdownListItemImpl item : (Iterable)ListUtils.INSTANCE.getItems(list)) {
            Replacement indentReplacement;
            void i;
            ListItemInfo oldInfo = new ListItemInfo(item, document);
            Integer n2 = start;
            String marker2 = n2 == null ? "" + markerFlavor + ' ' : "" + (start + i) + markerFlavor + ' ';
            ListItemIndentInfo newIndentInfo = listIndentInfo.subItem(marker2.length());
            Intrinsics.checkNotNull((Object)oldInfo.getIndentInfo().changeLineIndent(oldInfo.getLines().getFirst(), newIndentInfo.getIndent(), document, file));
            TextRange textRange = indentReplacement.getRange();
            PsiElement psiElement = item.getMarkerElement();
            Intrinsics.checkNotNull((Object)psiElement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"item.markerElement!!");
            TextRange textRange2 = textRange.union(psiElement.getTextRange());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"indentReplacement.range.\u2026arkerElement!!.textRange)");
            StringBuilder stringBuilder = this.plus(indentReplacement.getStr(), marker2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"indentReplacement.str + marker");
            Replacement indentWithMarkerReplacement = new Replacement(textRange2, stringBuilder);
            sequence = SequencesKt.plus((Sequence)sequence, (Object)indentWithMarkerReplacement);
            int prevLine = oldInfo.getLines().getFirst();
            if (recursive) {
                for (MarkdownListImpl sublist : ListUtils.INSTANCE.getSublists(item)) {
                    int sublistFirstLine = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)sublist)));
                    int sublistLastLine = document.getLineNumber(UtilsKt.getEndOffset((PsiElement)((PsiElement)sublist)));
                    IntRange preContentLines = RangesKt.until((int)(prevLine + 1), (int)sublistFirstLine);
                    sequence = SequencesKt.plus((Sequence)sequence, (Iterable)this.changeContentLinesIndent(oldInfo.getIndentInfo(), preContentLines, newIndentInfo.subItemIndent(), document, file));
                    sequence = SequencesKt.plus((Sequence)sequence, this.renumberingReplacements(sublist, newIndentInfo, document, file, true, true));
                    prevLine = sublistLastLine;
                }
            }
            int n3 = prevLine + 1;
            IntRange postContentLines = new IntRange(n3, oldInfo.getLines().getLast());
            sequence = SequencesKt.plus((Sequence)sequence, (Iterable)this.changeContentLinesIndent(oldInfo.getIndentInfo(), postContentLines, newIndentInfo.subItemIndent(), document, file));
            ++i;
        }
        return sequence;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Replacement> changeContentLinesIndent(ListItemIndentInfo $this$changeContentLinesIndent, IntRange lines, int newIndent, Document document, PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)lines;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Replacement replacement;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int line = element$iv$iv;
            boolean bl2 = false;
            if ($this$changeContentLinesIndent.subItem(0).changeLineIndent(line, newIndent, document, file) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Replacement it$iv$iv = replacement;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final StringBuilder plus(CharSequence $this$plus, CharSequence other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
        return new StringBuilder($this$plus.length() + other.length()).append($this$plus).append(other);
    }

    private ListRenumberUtils() {
    }

    static {
        ListRenumberUtils listRenumberUtils;
        INSTANCE = listRenumberUtils = new ListRenumberUtils();
    }
}

