/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManagerKt;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionComponentBase;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionKt;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogLoginPanel;
import org.jetbrains.plugins.github.util.CachingGHUserAvatarLoader;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J \u0010\u000b\u001a\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0012\u0010\u0010\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponent;", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponentBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createAccountMenuLoginActions", "", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItem$Action;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "createLoginAction", "createLoginPanel", "Ljavax/swing/JComponent;", "cancelHandler", "Lkotlin/Function0;", "", "createLoginWithTokenAction", "getAccounts", "getLoginPanel", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogLoginPanel;", "onAccountCredentialsChanged", "onAccountListChanged", "old", "new", "intellij.vcs.github"})
final class GHCloneDialogExtensionComponent
extends GHCloneDialogExtensionComponentBase {
    @Override
    @NotNull
    protected Collection<GithubAccount> getAccounts() {
        return GHCloneDialogExtensionKt.access$getGHAccounts();
    }

    @Override
    public void onAccountListChanged(@NotNull Collection<GithubAccount> old, @NotNull Collection<GithubAccount> collection) {
        GithubAccount it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(old, (String)"old");
        Intrinsics.checkNotNullParameter(collection, (String)"new");
        Iterable iterable = old;
        GHCloneDialogExtensionComponent gHCloneDialogExtensionComponent = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GithubAccount)((Object)element$iv$iv);
            boolean bl = false;
            if (!GHAccountManagerKt.isGHAccount(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        $this$filter$iv = collection;
        collection2 = collection2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GithubAccount)((Object)element$iv$iv);
            boolean bl = false;
            if (!GHAccountManagerKt.isGHAccount(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        super.onAccountListChanged(collection2, list2);
    }

    @Override
    public void onAccountCredentialsChanged(@NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        if (GHAccountManagerKt.isGHAccount(account)) {
            super.onAccountCredentialsChanged(account);
        }
    }

    @Override
    @NotNull
    protected JComponent createLoginPanel(@Nullable GithubAccount account, @NotNull Function0<Unit> cancelHandler) {
        Intrinsics.checkNotNullParameter(cancelHandler, (String)"cancelHandler");
        GHCloneDialogLoginPanel gHCloneDialogLoginPanel = new GHCloneDialogLoginPanel(account);
        boolean bl = false;
        boolean bl2 = false;
        GHCloneDialogLoginPanel $this$apply = gHCloneDialogLoginPanel;
        boolean bl3 = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)$this$apply);
        Function0<Unit> chooseLoginUiHandler2 = new Function0<Unit>($this$apply){
            final /* synthetic */ GHCloneDialogLoginPanel $this_apply;

            public final void invoke() {
                this.$this_apply.setChooseLoginUi();
            }
            {
                this.$this_apply = gHCloneDialogLoginPanel;
                super(0);
            }
        };
        $this$apply.getLoginPanel().setCancelHandler(this.getAccounts().isEmpty() ? chooseLoginUiHandler2 : cancelHandler);
        return (JComponent)((Object)gHCloneDialogLoginPanel);
    }

    @Override
    @NotNull
    protected Collection<AccountMenuItem.Action> createAccountMenuLoginActions(@Nullable GithubAccount account) {
        return CollectionsKt.listOf((Object[])new AccountMenuItem.Action[]{this.createLoginAction(account), this.createLoginWithTokenAction(account)});
    }

    private final AccountMenuItem.Action createLoginAction(GithubAccount account) {
        boolean isExistingAccount = account != null;
        String string = GithubBundle.message("login.via.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"login.via.github.action\")");
        return new AccountMenuItem.Action(string, (Function0)new Function0<Unit>(this, account){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account;

            public final void invoke() {
                block0: {
                    this.this$0.switchToLogin(this.$account);
                    GHCloneDialogLoginPanel gHCloneDialogLoginPanel = GHCloneDialogExtensionComponent.access$getLoginPanel(this.this$0);
                    if (gHCloneDialogLoginPanel == null) break block0;
                    gHCloneDialogLoginPanel.setPrimaryLoginUi();
                }
            }
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                this.$account = githubAccount;
                super(0);
            }
        }, null, !isExistingAccount, 4, null);
    }

    private final AccountMenuItem.Action createLoginWithTokenAction(GithubAccount account) {
        String string = GithubBundle.message("login.with.token.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"login.with.token.action\")");
        return new AccountMenuItem.Action(string, (Function0)new Function0<Unit>(this, account){
            final /* synthetic */ GHCloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account;

            public final void invoke() {
                block0: {
                    this.this$0.switchToLogin(this.$account);
                    GHCloneDialogLoginPanel gHCloneDialogLoginPanel = GHCloneDialogExtensionComponent.access$getLoginPanel(this.this$0);
                    if (gHCloneDialogLoginPanel == null) break block0;
                    gHCloneDialogLoginPanel.setTokenUi();
                }
            }
            {
                this.this$0 = gHCloneDialogExtensionComponent;
                this.$account = githubAccount;
                super(0);
            }
        }, null, false, 12, null);
    }

    private final GHCloneDialogLoginPanel getLoginPanel() {
        JComponent jComponent = this.getContent();
        if (!(jComponent instanceof GHCloneDialogLoginPanel)) {
            jComponent = null;
        }
        return (GHCloneDialogLoginPanel)((Object)jComponent);
    }

    public GHCloneDialogExtensionComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, GithubAuthenticationManager.Companion.getInstance(), GithubApiRequestExecutorManager.Companion.getInstance(), GithubAccountInformationProvider.Companion.getInstance(), CachingGHUserAvatarLoader.Companion.getInstance());
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        ((GHAccountManager)((Object)object)).addListener((Disposable)this, this);
        this.setup();
    }

    public static final /* synthetic */ GHCloneDialogLoginPanel access$getLoginPanel(GHCloneDialogExtensionComponent $this) {
        return $this.getLoginPanel();
    }
}

