/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedEvents;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedSimpleEvents;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedStateEvents;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tJ\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002J\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergingModel;", "Ljavax/swing/AbstractListModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "()V", "list", "", "add", "", "items", "", "getElementAt", "index", "", "getSize", "remove", "item", "removeAll", "update", "Companion", "intellij.vcs.github"})
public final class GHPRTimelineMergingModel
extends AbstractListModel<GHPRTimelineItem> {
    private final List<GHPRTimelineItem> list;
    private static final long MERGE_THRESHOLD_MS = 120000L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public GHPRTimelineItem getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public final void add(@NotNull List<? extends GHPRTimelineItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        int lastListIdx = CollectionsKt.getLastIndex(this.list);
        GHPRTimelineItem lastItem = (GHPRTimelineItem)CollectionsKt.lastOrNull(this.list);
        if (lastItem != null) {
            this.list.remove(lastListIdx);
            this.fireIntervalRemoved(this, lastListIdx, lastListIdx);
            --lastListIdx;
        }
        boolean added = false;
        Application application = ApplicationManager.getApplication();
        boolean bl = false;
        boolean bl2 = false;
        Application it = application;
        boolean bl3 = false;
        Application application2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"it");
        boolean hideUnknown = !application2.isInternal() && !it.isEAP();
        for (GHPRTimelineItem gHPRTimelineItem : items) {
            if (gHPRTimelineItem instanceof GHPRTimelineItem.Unknown && (hideUnknown || GHPRTimelineItem.Companion.getIGNORED_TYPES().contains(((GHPRTimelineItem.Unknown)gHPRTimelineItem).get__typename()))) continue;
            GHPRTimelineEvent merged = GHPRTimelineMergingModel.Companion.mergeIfPossible(lastItem, gHPRTimelineItem);
            if (merged != null) {
                lastItem = merged;
                continue;
            }
            if (lastItem != null && !GHPRTimelineMergingModel.Companion.isCollapsedMerge(lastItem)) {
                this.list.add(lastItem);
                added = true;
            }
            lastItem = gHPRTimelineItem;
        }
        if (lastItem != null && !GHPRTimelineMergingModel.Companion.isCollapsedMerge(lastItem)) {
            this.list.add(lastItem);
            added = true;
        }
        if (added) {
            this.fireIntervalAdded(this, lastListIdx + 1, CollectionsKt.getLastIndex(this.list));
        }
    }

    public final void update(@NotNull GHPRTimelineItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        int idx = this.list.indexOf(item2);
        if (idx >= 0) {
            this.list.set(idx, item2);
        }
        this.fireContentsChanged(this, idx, idx);
    }

    public final void remove(@NotNull GHPRTimelineItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        int idx = this.list.indexOf(item2);
        if (idx >= 0) {
            this.list.remove(idx);
        }
        this.fireIntervalRemoved(this, idx, idx);
    }

    public final void removeAll() {
        int n = 0;
        int n2 = this.getSize() - 1;
        boolean bl = false;
        int lastIdx = Math.max(n, n2);
        this.list.clear();
        if (lastIdx > 0) {
            this.fireIntervalRemoved(this, 0, lastIdx);
        }
    }

    public GHPRTimelineMergingModel() {
        boolean bl = false;
        this.list = new ArrayList();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergingModel$Companion;", "", "()V", "MERGE_THRESHOLD_MS", "", "isCollapsedMerge", "", "event", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "mergeIfPossible", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "existing", "new", "intellij.vcs.github"})
    public static final class Companion {
        private final GHPRTimelineEvent mergeIfPossible(GHPRTimelineItem existing, GHPRTimelineItem gHPRTimelineItem) {
            if (!(existing instanceof GHPRTimelineEvent) || !(gHPRTimelineItem instanceof GHPRTimelineEvent)) {
                return null;
            }
            if (Intrinsics.areEqual((Object)((GHPRTimelineEvent)existing).getActor(), (Object)((GHPRTimelineEvent)gHPRTimelineItem).getActor()) && ((GHPRTimelineEvent)gHPRTimelineItem).getCreatedAt().getTime() - ((GHPRTimelineEvent)existing).getCreatedAt().getTime() <= 120000L) {
                if (existing instanceof GHPRTimelineEvent.Simple && gHPRTimelineItem instanceof GHPRTimelineEvent.Simple) {
                    if (existing instanceof GHPRTimelineMergedSimpleEvents) {
                        ((GHPRTimelineMergedSimpleEvents)existing).add((GHPRTimelineEvent)gHPRTimelineItem);
                        return (GHPRTimelineEvent)existing;
                    }
                    GHPRTimelineMergedSimpleEvents gHPRTimelineMergedSimpleEvents = new GHPRTimelineMergedSimpleEvents();
                    boolean bl = false;
                    boolean bl2 = false;
                    GHPRTimelineMergedSimpleEvents $this$apply = gHPRTimelineMergedSimpleEvents;
                    boolean bl3 = false;
                    $this$apply.add((GHPRTimelineEvent)existing);
                    $this$apply.add((GHPRTimelineEvent)gHPRTimelineItem);
                    return gHPRTimelineMergedSimpleEvents;
                }
                if (existing instanceof GHPRTimelineEvent.State && gHPRTimelineItem instanceof GHPRTimelineEvent.State) {
                    if (existing instanceof GHPRTimelineMergedStateEvents) {
                        ((GHPRTimelineMergedStateEvents)existing).add((GHPRTimelineEvent)gHPRTimelineItem);
                        return (GHPRTimelineEvent)existing;
                    }
                    GHPRTimelineMergedStateEvents gHPRTimelineMergedStateEvents = new GHPRTimelineMergedStateEvents((GHPRTimelineEvent.State)existing);
                    boolean bl = false;
                    boolean bl4 = false;
                    GHPRTimelineMergedStateEvents $this$apply = gHPRTimelineMergedStateEvents;
                    boolean bl5 = false;
                    $this$apply.add((GHPRTimelineEvent)gHPRTimelineItem);
                    return gHPRTimelineMergedStateEvents;
                }
            }
            return null;
        }

        private final boolean isCollapsedMerge(GHPRTimelineItem event) {
            return event instanceof GHPRTimelineMergedEvents && !((GHPRTimelineMergedEvents)event).hasAnyChanges();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

