/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFileHistory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMutableLinearFileHistory;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFileHistory;", "commitHashes", "", "", "(Ljava/util/List;)V", "firstKnownFilePath", "getFirstKnownFilePath", "()Ljava/lang/String;", "history", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMutableLinearFileHistory$Entry;", "lastKnownFilePath", "getLastKnownFilePath", "append", "", "commitSha", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "compare", "", "commitSha1", "commitSha2", "contains", "", "filePath", "getPatches", "parent", "child", "includeFirstKnownPatch", "includeLastPatch", "Companion", "Entry", "intellij.vcs.github"})
public final class GHPRMutableLinearFileHistory
implements GHPRFileHistory {
    private final Map<String, Entry> history;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getFirstKnownFilePath() {
        Entry entry;
        Object v0;
        boolean bl;
        Object object;
        block2: {
            object = this.history.values();
            bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                Entry it = (Entry)t;
                boolean bl3 = false;
                if (!(it.getPatch() != null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((entry = (Entry)v0) == null || (entry = entry.getPatch()) == null) {
            object = "Empty history";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return entry.getBeforeName();
    }

    @Nullable
    public final String getLastKnownFilePath() {
        Object object = this.history.values();
        boolean bl = false;
        Iterable iterable = object;
        boolean bl2 = false;
        Object var6_5 = null;
        for (Object t : iterable) {
            Entry it = (Entry)t;
            boolean bl3 = false;
            if (!(it.getPatch() != null)) continue;
            var6_5 = t;
        }
        Entry entry = var6_5;
        if (entry == null || (entry = entry.getPatch()) == null) {
            object = "Empty history";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        String lastFilePath = entry.getAfterName();
        String string = lastFilePath;
        if (string == null) {
            string = this.getFirstKnownFilePath();
        }
        return string;
    }

    public final void append(@NotNull String commitSha, @NotNull TextFilePatch patch) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Entry entry = this.history.get(commitSha);
        boolean bl = entry != null && entry.getPatch() == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.history.put(commitSha, new Entry(patch));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(@NotNull String commitSha, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String lastPath = null;
        Object object = this.history;
        boolean bl = false;
        Iterator<Map.Entry<String, Entry>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void sha;
            Map.Entry<String, Entry> entry;
            Map.Entry<String, Entry> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Entry entry3 = entry2.getValue();
            String entryPath = entry3.getFilePath();
            if (entryPath != null) {
                lastPath = entryPath;
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)commitSha) || !Intrinsics.areEqual((Object)lastPath, (Object)filePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(@NotNull String commitSha1, @NotNull String commitSha2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)commitSha1, (String)"commitSha1");
        Intrinsics.checkNotNullParameter((Object)commitSha2, (String)"commitSha2");
        if (Intrinsics.areEqual((Object)commitSha1, (Object)commitSha2)) {
            return 0;
        }
        Map<String, Entry> map = this.history;
        boolean bl = false;
        Iterator<Map.Entry<String, Entry>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String sha = (String)object2.getKey();
            if (Intrinsics.areEqual((Object)sha, (Object)commitSha1)) {
                return -1;
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)commitSha2)) continue;
            return 1;
        }
        object = "Unknown commit sha";
        boolean bl3 = false;
        throw (Throwable)new IllegalStateException(object.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TextFilePatch> getPatches(@NotNull String parent, @NotNull String child, boolean includeFirstKnownPatch, boolean includeLastPatch) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean bl = false;
        List patches = new ArrayList();
        boolean foundParent = false;
        TextFilePatch lastFound = null;
        Object object = this.history;
        boolean bl2 = false;
        Iterator<Map.Entry<String, Entry>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            TextFilePatch it;
            boolean bl3;
            void sha;
            TextFilePatch textFilePatch;
            TextFilePatch textFilePatch2 = textFilePatch = iterator.next();
            boolean bl4 = false;
            object = textFilePatch2.getKey();
            textFilePatch2 = textFilePatch;
            bl4 = false;
            Entry entry = textFilePatch2.getValue();
            if (!foundParent) {
                if (entry.getPatch() != null) {
                    lastFound = entry.getPatch();
                }
                if (!Intrinsics.areEqual((Object)sha, (Object)parent)) continue;
                foundParent = true;
                if (includeFirstKnownPatch) continue;
                TextFilePatch textFilePatch3 = entry.getPatch();
                if (textFilePatch3 == null) {
                    textFilePatch3 = lastFound;
                }
                if (textFilePatch3 == null) {
                    String string = "Original patch was not found";
                    bl3 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                TextFilePatch patchToAdd = textFilePatch3;
                patches.add(patchToAdd);
                continue;
            }
            if (includeLastPatch) {
                if (Intrinsics.areEqual((Object)sha, (Object)child)) break;
                TextFilePatch textFilePatch4 = entry.getPatch();
                if (textFilePatch4 != null) {
                    textFilePatch2 = textFilePatch4;
                    bl4 = false;
                    bl3 = false;
                    it = textFilePatch2;
                    boolean bl5 = false;
                    patches.add(it);
                }
                continue;
            }
            TextFilePatch textFilePatch5 = entry.getPatch();
            if (textFilePatch5 != null) {
                textFilePatch2 = textFilePatch5;
                bl4 = false;
                bl3 = false;
                it = textFilePatch2;
                boolean bl6 = false;
                patches.add(it);
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)child)) continue;
            break;
        }
        return patches;
    }

    public GHPRMutableLinearFileHistory(@NotNull List<String> commitHashes) {
        Intrinsics.checkNotNullParameter(commitHashes, (String)"commitHashes");
        this.history = new LinkedHashMap();
        for (String sha : commitHashes) {
            this.history.put(sha, new Entry(null));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMutableLinearFileHistory$Entry;", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)V", "filePath", "", "getFilePath", "()Ljava/lang/String;", "getPatch", "()Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "intellij.vcs.github"})
    private static final class Entry {
        @Nullable
        private final String filePath;
        @Nullable
        private final TextFilePatch patch;

        @Nullable
        public final String getFilePath() {
            return this.filePath;
        }

        @Nullable
        public final TextFilePatch getPatch() {
            return this.patch;
        }

        public Entry(@Nullable TextFilePatch patch) {
            TextFilePatch textFilePatch = this.patch = patch;
            this.filePath = textFilePatch != null ? Companion.getFilePath(textFilePatch) : null;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMutableLinearFileHistory$Companion;", "", "()V", "filePath", "", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "getFilePath", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)Ljava/lang/String;", "intellij.vcs.github"})
    public static final class Companion {
        private final String getFilePath(TextFilePatch $this$filePath) {
            String string = $this$filePath.getAfterName();
            if (string == null) {
                string = $this$filePath.getBeforeName();
            }
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

