/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.AccountDetails;
import com.intellij.collaboration.auth.ui.LoadingAccountsDetailsProvider;
import com.intellij.collaboration.util.ProgressIndicatorsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.IconUtil;
import java.awt.Image;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsListModel;
import org.jetbrains.plugins.github.authentication.util.GHSecurityUtil;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.CachingGHUserAvatarLoader;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsDetailsProvider;", "Lcom/intellij/collaboration/auth/ui/LoadingAccountsDetailsProvider;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Lorg/jetbrains/plugins/github/api/data/GithubUserDetailed;", "progressIndicatorsProvider", "Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "accountsModel", "Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsListModel;", "(Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsListModel;)V", "defaultIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getDefaultIcon", "()Ljavax/swing/Icon;", "noScopes", "Lcom/intellij/collaboration/auth/ui/LoadingAccountsDetailsProvider$DetailsLoadingResult;", "noToken", "scheduleLoad", "Ljava/util/concurrent/CompletableFuture;", "account", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.vcs.github"})
public final class GHAccountsDetailsProvider
extends LoadingAccountsDetailsProvider<GithubAccount, GithubUserDetailed> {
    @NotNull
    private final Icon defaultIcon;
    private final GHAccountManager accountManager;
    private final GHAccountsListModel accountsModel;

    @NotNull
    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    @NotNull
    public CompletableFuture<LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed>> scheduleLoad(@NotNull GithubAccount account, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Map map = this.accountsModel.getNewCredentials();
        boolean bl = false;
        Object object = map.get((Object)account);
        if (object == null) {
            boolean bl2 = false;
            object = (String)this.accountManager.findCredentials((Account)account);
        }
        String string = (String)object;
        if (string == null) {
            CompletableFuture<LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed>> completableFuture = CompletableFuture.completedFuture(this.noToken());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(noToken())");
            return completableFuture;
        }
        String token = string;
        boolean $i$f$service = false;
        Class<GithubApiRequestExecutor.Factory> serviceClass$iv = GithubApiRequestExecutor.Factory.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        GithubApiRequestExecutor.WithTokenAuth executor = ((GithubApiRequestExecutor.Factory)object2).create(token);
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        return CompletableFutureUtil.INSTANCE.successOnEdt(CompletableFutureUtil.INSTANCE.submitIOTask(progressManager, (ProgressIndicator)new EmptyProgressIndicator(), (Function1)new Function1<ProgressIndicator, LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed>>(this, executor, account){
            final /* synthetic */ GHAccountsDetailsProvider this$0;
            final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $executor;
            final /* synthetic */ GithubAccount $account;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed> invoke(@NotNull ProgressIndicator it) {
                Image image;
                void details2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = GHSecurityUtil.loadCurrentUserWithScopes$intellij_vcs_github(this.$executor, it, this.$account.getServer());
                GithubAuthenticatedUser githubAuthenticatedUser = (GithubAuthenticatedUser)object.component1();
                String scopes = (String)object.component2();
                object = scopes;
                boolean bl = false;
                Object object2 = object;
                if (object2 == null) {
                    object2 = "";
                }
                if (!GHSecurityUtil.isEnoughScopes$intellij_vcs_github(object2)) {
                    return GHAccountsDetailsProvider.access$noScopes(this.this$0);
                }
                String string = details2.getAvatarUrl();
                if (string != null) {
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String url = string2;
                    boolean bl4 = false;
                    CachingGHUserAvatarLoader cachingGHUserAvatarLoader = CachingGHUserAvatarLoader.Companion.getInstance();
                    GithubApiRequestExecutor githubApiRequestExecutor = this.$executor;
                    String string3 = url;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"url");
                    image = cachingGHUserAvatarLoader.requestAvatar(githubApiRequestExecutor, string3).join();
                } else {
                    image = null;
                }
                Image image2 = image;
                return new LoadingAccountsDetailsProvider.DetailsLoadingResult((AccountDetails)details2, image2, null, false);
            }
            {
                this.this$0 = gHAccountsDetailsProvider;
                this.$executor = withTokenAuth;
                this.$account = githubAccount;
                super(1);
            }
        }), ModalityState.any(), (Function1)new Function1<LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed>, LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed>>(this, account){
            final /* synthetic */ GHAccountsDetailsProvider this$0;
            final /* synthetic */ GithubAccount $account;

            @NotNull
            public final LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed> invoke(@NotNull LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                GHAccountsDetailsProvider.access$getAccountsModel$p(this.this$0).getAccountsListModel().contentsChanged((Object)((Object)this.$account));
                return it;
            }
            {
                this.this$0 = gHAccountsDetailsProvider;
                this.$account = githubAccount;
                super(1);
            }
        });
    }

    private final LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed> noToken() {
        return new LoadingAccountsDetailsProvider.DetailsLoadingResult(null, null, GithubBundle.message("account.token.missing", new Object[0]), true);
    }

    private final LoadingAccountsDetailsProvider.DetailsLoadingResult<GithubUserDetailed> noScopes() {
        return new LoadingAccountsDetailsProvider.DetailsLoadingResult(null, null, GithubBundle.message("account.scopes.insufficient", new Object[0]), true);
    }

    public GHAccountsDetailsProvider(@NotNull ProgressIndicatorsProvider progressIndicatorsProvider, @NotNull GHAccountManager accountManager, @NotNull GHAccountsListModel accountsModel) {
        Intrinsics.checkNotNullParameter((Object)progressIndicatorsProvider, (String)"progressIndicatorsProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        Intrinsics.checkNotNullParameter((Object)accountsModel, (String)"accountsModel");
        super(progressIndicatorsProvider);
        this.accountManager = accountManager;
        this.accountsModel = accountsModel;
        Icon icon = IconUtil.resizeSquared((Icon)GithubIcons.DefaultAvatar, (int)40);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IconUtil.resizeSquared(G\u2026bIcons.DefaultAvatar, 40)");
        this.defaultIcon = icon;
    }

    public static final /* synthetic */ LoadingAccountsDetailsProvider.DetailsLoadingResult access$noScopes(GHAccountsDetailsProvider $this) {
        return $this.noScopes();
    }

    public static final /* synthetic */ GHAccountsListModel access$getAccountsModel$p(GHAccountsDetailsProvider $this) {
        return $this.accountsModel;
    }
}

