/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.language.codeinsight.quickfixes.EditorConfigSanitizeCharClassQuickFix;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigCharClass;
import org.editorconfig.language.psi.EditorConfigCharClassLetter;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigSanitizeCharClassQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "distinctLetters", "", "Lorg/editorconfig/language/psi/EditorConfigCharClassLetter;", "letters", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
public final class EditorConfigSanitizeCharClassQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.charclass.sanitize.description");
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (!(psiElement instanceof EditorConfigCharClass)) {
            psiElement = null;
        }
        EditorConfigCharClass editorConfigCharClass = (EditorConfigCharClass)psiElement;
        if (editorConfigCharClass == null) {
            return;
        }
        EditorConfigCharClass charClass = editorConfigCharClass;
        List<EditorConfigCharClassLetter> list = charClass.getCharClassLetterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"charClass.charClassLetterList");
        EditorConfigCharClassLetter first = (EditorConfigCharClassLetter)CollectionsKt.first(list);
        List<EditorConfigCharClassLetter> list2 = charClass.getCharClassLetterList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"charClass.charClassLetterList");
        EditorConfigCharClassLetter last = (EditorConfigCharClassLetter)CollectionsKt.last(list2);
        String string = charClass.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"charClass.text");
        String string2 = string;
        int n = 0;
        EditorConfigCharClassLetter editorConfigCharClassLetter = first;
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigCharClassLetter, (String)"first");
        int n2 = editorConfigCharClassLetter.getStartOffsetInParent();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String prefix = string4;
        String string5 = charClass.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"charClass.text");
        String string6 = string5;
        EditorConfigCharClassLetter editorConfigCharClassLetter2 = last;
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigCharClassLetter2, (String)"last");
        n2 = editorConfigCharClassLetter2.getStartOffsetInParent() + last.getTextLength();
        bl = false;
        String string7 = string6;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        String postfix = string8;
        List<EditorConfigCharClassLetter> list3 = charClass.getCharClassLetterList();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"charClass.charClassLetterList");
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.distinctLetters(list3)), (Function1)applyFix.newSource.1.INSTANCE);
        StringBuilder initial$iv = new StringBuilder(prefix);
        boolean $i$f$fold = false;
        StringBuilder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p2;
            String string9 = (String)element$iv;
            StringBuilder p1 = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = p1.append((String)p2);
        }
        String string10 = accumulator$iv.append(postfix).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"distinctLetters(charClas\u2026ostfix)\n      .toString()");
        String newSource2 = string10;
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigCharClass newCharClass = factory.createCharClass(newSource2);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(charClass, newCharClass){
            final /* synthetic */ EditorConfigCharClass $charClass;
            final /* synthetic */ EditorConfigCharClass $newCharClass;

            public final void run() {
                this.$charClass.replace(this.$newCharClass);
            }
            {
                this.$charClass = editorConfigCharClass;
                this.$newCharClass = editorConfigCharClass2;
            }
        });
    }

    private final List<EditorConfigCharClassLetter> distinctLetters(List<? extends EditorConfigCharClassLetter> letters) {
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = letters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl2;
            EditorConfigCharClassLetter it;
            block4: {
                it = (EditorConfigCharClassLetter)element$iv;
                boolean bl3 = false;
                Iterable $this$none$iv = result2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        PsiElement p1 = (PsiElement)element$iv2;
                        boolean bl4 = false;
                        if (!it.textMatches(p1)) continue;
                        bl2 = false;
                        break block4;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            result2.add(it);
        }
        return result2;
    }
}

