/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.ConfigEncodingManager;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="editorConfigEncodings", storages={@Storage(value="$CACHE_FILE$")})
public class EditorConfigEncodingCache
implements PersistentStateComponent<Element> {
    private static final String ENTRY_ELEMENT = "file";
    private static final String URL_ATTR = "url";
    private static final String CHARSET_ATTR = "charset";
    private final Map<String, CharsetData> myCharsetMap = new ConcurrentHashMap<String, CharsetData>();

    public static EditorConfigEncodingCache getInstance() {
        return (EditorConfigEncodingCache)ApplicationManager.getApplication().getService(EditorConfigEncodingCache.class);
    }

    @Nullable
    public Element getState() {
        Element root = new Element("encodings");
        for (String url : this.myCharsetMap.keySet()) {
            String charsetStr;
            CharsetData charsetData = this.myCharsetMap.get(url);
            if (charsetData == null || (charsetStr = ConfigEncodingManager.toString(charsetData.charset, charsetData.useBom)) == null) continue;
            Element entryElement = new Element(ENTRY_ELEMENT);
            Attribute urlAttr = new Attribute(URL_ATTR, url);
            Attribute charsetAttr = new Attribute(CHARSET_ATTR, charsetStr);
            entryElement.setAttribute(urlAttr);
            entryElement.setAttribute(charsetAttr);
            root.addContent(entryElement);
        }
        return root;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(0);
        }
        this.myCharsetMap.clear();
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        for (Element fileElement : state.getChildren(ENTRY_ELEMENT)) {
            VirtualFile vf;
            Attribute urlAttr = fileElement.getAttribute(URL_ATTR);
            Attribute charsetAttr = fileElement.getAttribute(CHARSET_ATTR);
            if (urlAttr == null || charsetAttr == null) continue;
            String url = urlAttr.getValue();
            String charsetStr = charsetAttr.getValue();
            Charset charset = ConfigEncodingManager.toCharset(charsetStr);
            boolean useBom = "utf-8-bom".equals(charsetStr);
            if (charset == null || (vf = vfManager.findFileByUrl(url)) == null) continue;
            this.myCharsetMap.put(url, new CharsetData(charset, useBom));
        }
    }

    public boolean getUseUtf8Bom(@Nullable Project project, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(1);
        }
        return (Boolean)ObjectUtils.notNull((Object)((Boolean)ObjectUtils.doIfNotNull((Object)this.getCharsetData(project, virtualFile), rec$ -> ((CharsetData)rec$).isUseBom())), (Object)false);
    }

    @Nullable
    public Charset getEncoding(@Nullable Project project, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(2);
        }
        return (Charset)ObjectUtils.doIfNotNull((Object)this.getCharsetData(project, virtualFile), CharsetData::getCharset);
    }

    @Nullable
    private CharsetData getCharsetData(@Nullable Project project, @NotNull VirtualFile virtualFile) {
        List<EditorConfig.OutPair> outPairs;
        String charsetStr;
        if (virtualFile == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(3);
        }
        if (!Utils.isApplicableTo(virtualFile) || Utils.isEditorConfigFile(virtualFile)) {
            return null;
        }
        CharsetData cached = this.getCachedCharsetData(virtualFile);
        if (cached != null) {
            return cached;
        }
        if (project != null && !(charsetStr = Utils.configValueForKey(outPairs = SettingsProviderComponent.getInstance().getOutPairs(project, virtualFile), CHARSET_ATTR)).isEmpty()) {
            Charset charset = ConfigEncodingManager.toCharset(charsetStr);
            boolean useBom = "utf-8-bom".equals(charsetStr);
            if (charset != null) {
                return new CharsetData(charset, useBom);
            }
        }
        return null;
    }

    private void cacheEncoding(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        CharsetData charsetData;
        String key;
        if (project == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(5);
        }
        if (!this.myCharsetMap.containsKey(key = EditorConfigEncodingCache.getKey(virtualFile)) && (charsetData = this.getCharsetData(project, virtualFile)) != null) {
            this.myCharsetMap.put(key, charsetData);
        }
    }

    @Nullable
    public Charset getCachedEncoding(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(6);
        }
        return (Charset)ObjectUtils.doIfNotNull((Object)this.getCachedCharsetData(virtualFile), CharsetData::getCharset);
    }

    @Nullable
    private CharsetData getCachedCharsetData(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(7);
        }
        return this.myCharsetMap.get(EditorConfigEncodingCache.getKey(virtualFile));
    }

    @NotNull
    private static String getKey(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(8);
        }
        String string = virtualFile.getUrl();
        if (string == null) {
            EditorConfigEncodingCache.$$$reportNull$$$0(9);
        }
        return string;
    }

    public final void reset() {
        this.myCharsetMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/EditorConfigEncodingCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigEncodingCache";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUseUtf8Bom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEncoding";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cacheEncoding";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedEncoding";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCharsetData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FileEditorListener
    implements FileEditorManagerListener {
        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                FileEditorListener.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FileEditorListener.$$$reportNull$$$0(1);
            }
            EditorConfigEncodingCache.getInstance().cacheEncoding(source.getProject(), file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = EditorConfigEncodingCache.ENTRY_ELEMENT;
                    break;
                }
            }
            objectArray[1] = "org/editorconfig/configmanagement/EditorConfigEncodingCache$FileEditorListener";
            objectArray[2] = "fileOpened";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CharsetData {
        private final Charset charset;
        private final boolean useBom;

        CharsetData(Charset charset, boolean useBom) {
            this.charset = charset;
            this.useBom = useBom;
        }

        Charset getCharset() {
            return this.charset;
        }

        private boolean isUseBom() {
            return this.useBom;
        }
    }
}

