/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.utils.filter;

import com.intellij.grazie.detector.utils.filter.TextFilter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grazie/detector/utils/filter/RegexTextFilter;", "Lcom/intellij/grazie/detector/utils/filter/TextFilter;", "regexes", "", "Lkotlin/text/Regex;", "([Lkotlin/text/Regex;)V", "", "(Ljava/util/List;)V", "filter", "", "text", "nlp-detector"})
public abstract class RegexTextFilter
implements TextFilter {
    private final List<Regex> regexes;

    @Override
    @NotNull
    public CharSequence filter(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence result = text;
        for (Regex regex : this.regexes) {
            result = regex.replace(result, " ");
        }
        return result;
    }

    public RegexTextFilter(@NotNull List<Regex> regexes) {
        Intrinsics.checkNotNullParameter(regexes, (String)"regexes");
        this.regexes = regexes;
    }

    public RegexTextFilter(Regex ... regexes) {
        Intrinsics.checkNotNullParameter((Object)regexes, (String)"regexes");
        this(ArraysKt.toList((Object[])regexes));
    }
}

