/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.model.alphabet;

import com.intellij.grazie.detector.model.alphabet.Alphabet$Companion$WhenMappings;
import com.intellij.grazie.detector.model.alphabet.NoneAlphabet;
import com.intellij.grazie.detector.model.alphabet.RegexAlphabet;
import com.intellij.grazie.detector.model.alphabet.SetBasedAlphabet;
import com.intellij.grazie.detector.utils.regex.AlphabetRegex;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b%\b&\u0018\u0000 \u00142\u00020\u0001:!\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006/"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet;", "", "group", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "(Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;)V", "getGroup", "()Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "matchAny", "", "input", "", "matchAnySpecial", "matchAnyUnique", "matchEntire", "ARABIC", "ASTURIAN", "BELARUSIAN", "BRETON", "CATALAN", "CHINESE", "Companion", "DANISH", "DUTCH", "ENGLISH", "ESPERANTO", "FRENCH", "GALICIAN", "GERMAN", "GREEK", "Group", "IRISH", "ITALIAN", "JAPANESE", "KHMER", "NONE", "PERSIAN", "POLISH", "PORTUGUESE", "ROMANIAN", "RUSSIAN", "SLOVAK", "SLOVENE", "SPANISH", "SWEDISH", "TAGALOG", "TAMIL", "UKRANIAN", "nlp-detector"})
public abstract class Alphabet {
    @NotNull
    private final Group group;
    @NotNull
    private static final LinkedHashSet<Alphabet> all;
    @NotNull
    private static final LinkedHashSet<SetBasedAlphabet> latin;
    @NotNull
    private static final LinkedHashSet<GREEK> greek;
    @NotNull
    private static final LinkedHashSet<KHMER> khmer;
    @NotNull
    private static final LinkedHashSet<TAMIL> tamil;
    @NotNull
    private static final LinkedHashSet<RegexAlphabet> arabic;
    @NotNull
    private static final LinkedHashSet<SetBasedAlphabet> cyrillic;
    @NotNull
    private static final LinkedHashSet<RegexAlphabet> asian;
    @NotNull
    public static final Companion Companion;

    public abstract boolean matchEntire(@NotNull CharSequence var1);

    public abstract boolean matchAny(@NotNull CharSequence var1);

    public abstract boolean matchAnySpecial(@NotNull CharSequence var1);

    public abstract boolean matchAnyUnique(@NotNull CharSequence var1);

    @NotNull
    public final Group getGroup() {
        return this.group;
    }

    public Alphabet(@NotNull Group group) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        this.group = group;
    }

    static {
        Companion = new Companion(null);
        all = SetsKt.linkedSetOf((Object[])new Alphabet[]{ENGLISH.INSTANCE, FRENCH.INSTANCE, GERMAN.INSTANCE, DUTCH.INSTANCE, ITALIAN.INSTANCE, POLISH.INSTANCE, PORTUGUESE.INSTANCE, ROMANIAN.INSTANCE, SLOVAK.INSTANCE, SLOVENE.INSTANCE, SWEDISH.INSTANCE, SPANISH.INSTANCE, TAGALOG.INSTANCE, ASTURIAN.INSTANCE, BRETON.INSTANCE, CATALAN.INSTANCE, DANISH.INSTANCE, ESPERANTO.INSTANCE, GALICIAN.INSTANCE, IRISH.INSTANCE, GREEK.INSTANCE, KHMER.INSTANCE, TAMIL.INSTANCE, ARABIC.INSTANCE, PERSIAN.INSTANCE, CHINESE.INSTANCE, JAPANESE.INSTANCE, RUSSIAN.INSTANCE, UKRANIAN.INSTANCE, BELARUSIAN.INSTANCE});
        latin = SetsKt.linkedSetOf((Object[])new SetBasedAlphabet[]{ENGLISH.INSTANCE, FRENCH.INSTANCE, GERMAN.INSTANCE, DUTCH.INSTANCE, ITALIAN.INSTANCE, POLISH.INSTANCE, PORTUGUESE.INSTANCE, ROMANIAN.INSTANCE, SLOVAK.INSTANCE, SLOVENE.INSTANCE, SWEDISH.INSTANCE, SPANISH.INSTANCE, TAGALOG.INSTANCE, ASTURIAN.INSTANCE, BRETON.INSTANCE, CATALAN.INSTANCE, DANISH.INSTANCE, ESPERANTO.INSTANCE, GALICIAN.INSTANCE, IRISH.INSTANCE});
        greek = SetsKt.linkedSetOf((Object[])new GREEK[]{GREEK.INSTANCE});
        khmer = SetsKt.linkedSetOf((Object[])new KHMER[]{KHMER.INSTANCE});
        tamil = SetsKt.linkedSetOf((Object[])new TAMIL[]{TAMIL.INSTANCE});
        arabic = SetsKt.linkedSetOf((Object[])new RegexAlphabet[]{ARABIC.INSTANCE, PERSIAN.INSTANCE});
        cyrillic = SetsKt.linkedSetOf((Object[])new SetBasedAlphabet[]{RUSSIAN.INSTANCE, UKRANIAN.INSTANCE, BELARUSIAN.INSTANCE});
        asian = SetsKt.linkedSetOf((Object[])new RegexAlphabet[]{CHINESE.INSTANCE, JAPANESE.INSTANCE});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u000b\b\u0086\u0001\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "", "regex", "Lkotlin/text/Regex;", "(Ljava/lang/String;ILkotlin/text/Regex;)V", "getRegex", "()Lkotlin/text/Regex;", "matchAny", "", "input", "", "matchEntire", "LATIN", "GREEK", "KHMER", "TAMIL", "ARABIC", "ASIAN", "CYRILLIC", "NONE", "Companion", "nlp-detector"})
    public static final class Group
    extends Enum<Group> {
        public static final /* enum */ Group LATIN;
        public static final /* enum */ Group GREEK;
        public static final /* enum */ Group KHMER;
        public static final /* enum */ Group TAMIL;
        public static final /* enum */ Group ARABIC;
        public static final /* enum */ Group ASIAN;
        public static final /* enum */ Group CYRILLIC;
        public static final /* enum */ Group NONE;
        private static final /* synthetic */ Group[] $VALUES;
        @NotNull
        private final Regex regex;
        @NotNull
        private static final List<Group> all;
        @NotNull
        private static final List<Group> withSpaces;
        @NotNull
        public static final Companion Companion;

        static {
            Group[] groupArray = new Group[8];
            Group[] groupArray2 = groupArray;
            groupArray[0] = LATIN = new Group(new Regex('[' + AlphabetRegex.INSTANCE.getLatin() + "]+"));
            groupArray[1] = GREEK = new Group(new Regex('[' + AlphabetRegex.INSTANCE.getGreek() + "]+"));
            groupArray[2] = KHMER = new Group(new Regex('[' + AlphabetRegex.INSTANCE.getKhmer() + "]+"));
            groupArray[3] = TAMIL = new Group(new Regex('[' + AlphabetRegex.INSTANCE.getTamil() + "]+"));
            groupArray[4] = ARABIC = new Group(new Regex('[' + AlphabetRegex.INSTANCE.getArabic() + "|\\u200C]+"));
            groupArray[5] = ASIAN = new Group(new Regex('[' + AlphabetRegex.INSTANCE.getHiragana() + '|' + AlphabetRegex.INSTANCE.getKatakana() + '|' + AlphabetRegex.INSTANCE.getHan() + "]+"));
            groupArray[6] = CYRILLIC = new Group(new Regex('[' + AlphabetRegex.INSTANCE.getCyrillic() + "]+"));
            groupArray[7] = NONE = new Group(new Regex(""));
            $VALUES = groupArray;
            Companion = new Companion(null);
            all = CollectionsKt.listOf((Object[])new Group[]{LATIN, GREEK, KHMER, TAMIL, ARABIC, ASIAN, CYRILLIC});
            withSpaces = CollectionsKt.listOf((Object[])new Group[]{LATIN, GREEK, CYRILLIC});
        }

        public final boolean matchAny(@NotNull CharSequence input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return this.regex.containsMatchIn(input);
        }

        public final boolean matchEntire(@NotNull CharSequence input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return this.regex.matches(input);
        }

        @NotNull
        public final Regex getRegex() {
            return this.regex;
        }

        private Group(Regex regex) {
            this.regex = regex;
        }

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String string) {
            return Enum.valueOf(Group.class, string);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group$Companion;", "", "()V", "all", "", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "getAll", "()Ljava/util/List;", "withSpaces", "getWithSpaces", "nlp-detector"})
        public static final class Companion {
            @NotNull
            public final List<Group> getAll() {
                return all;
            }

            @NotNull
            public final List<Group> getWithSpaces() {
                return withSpaces;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ENGLISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class ENGLISH
    extends SetBasedAlphabet {
        @NotNull
        public static final ENGLISH INSTANCE;

        private ENGLISH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz", "", "");
        }

        static {
            ENGLISH eNGLISH;
            INSTANCE = eNGLISH = new ENGLISH();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$FRENCH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class FRENCH
    extends SetBasedAlphabet {
        @NotNull
        public static final FRENCH INSTANCE;

        private FRENCH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff", "\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff", "\u0152");
        }

        static {
            FRENCH fRENCH;
            INSTANCE = fRENCH = new FRENCH();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$GERMAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class GERMAN
    extends SetBasedAlphabet {
        @NotNull
        public static final GERMAN INSTANCE;

        private GERMAN() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df", "\u00e4\u00f6\u00fc\u00df", "\u00df");
        }

        static {
            GERMAN gERMAN;
            INSTANCE = gERMAN = new GERMAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$DUTCH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class DUTCH
    extends SetBasedAlphabet {
        @NotNull
        public static final DUTCH INSTANCE;

        private DUTCH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00eb\u00ef\u0133", "\u00e0\u00e9\u00eb\u00ef\u0133", "\u0133");
        }

        static {
            DUTCH dUTCH;
            INSTANCE = dUTCH = new DUTCH();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ITALIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class ITALIAN
    extends SetBasedAlphabet {
        @NotNull
        public static final ITALIAN INSTANCE;

        private ITALIAN() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00e8\u00ec\u00f2\u00f9", "\u00e0\u00e9\u00e8\u00ec\u00f2\u00f9", "\u00ec");
        }

        static {
            ITALIAN iTALIAN;
            INSTANCE = iTALIAN = new ITALIAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$POLISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class POLISH
    extends SetBasedAlphabet {
        @NotNull
        public static final POLISH INSTANCE;

        private POLISH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u0105\u0142\u0144\u00f3\u017c\u0107\u0119\u015b\u017a", "\u0105\u0142\u0144\u00f3\u017c\u0107\u0119\u015b\u017a", "\u0105\u0142\u0144\u017c\u0107\u0119\u015b\u017a");
        }

        static {
            POLISH pOLISH;
            INSTANCE = pOLISH = new POLISH();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$PORTUGUESE;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class PORTUGUESE
    extends SetBasedAlphabet {
        @NotNull
        public static final PORTUGUESE INSTANCE;

        private PORTUGUESE() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e3\u00f5\u00e7\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00f4\u00e0", "\u00e3\u00f5\u00e7\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00f4\u00e0", "\u00e3\u00f5");
        }

        static {
            PORTUGUESE pORTUGUESE;
            INSTANCE = pORTUGUESE = new PORTUGUESE();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ROMANIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class ROMANIAN
    extends SetBasedAlphabet {
        @NotNull
        public static final ROMANIAN INSTANCE;

        private ROMANIAN() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u0103\u00ee\u00e2\u015f\u0163", "\u0103\u00ee\u00e2\u015f\u0163", "\u0103\u015f\u0163");
        }

        static {
            ROMANIAN rOMANIAN;
            INSTANCE = rOMANIAN = new ROMANIAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$SLOVAK;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class SLOVAK
    extends SetBasedAlphabet {
        @NotNull
        public static final SLOVAK INSTANCE;

        private SLOVAK() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u017e\u0161\u010d\u00e1\u00e4\u010f\u00e9\u00ed\u013e\u013a\u0148\u00f3\u00f4\u0155\u0165\u00fa\u00fd", "\u017e\u0161\u010d\u00e1\u00e4\u010f\u00e9\u00ed\u013e\u013a\u0148\u00f3\u00f4\u0155\u0165\u00fa\u00fd", "\u010f\u013e\u013a\u0148\u0155\u0165\u00fd");
        }

        static {
            SLOVAK sLOVAK;
            INSTANCE = sLOVAK = new SLOVAK();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$SPANISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class SPANISH
    extends SetBasedAlphabet {
        @NotNull
        public static final SPANISH INSTANCE;

        private SPANISH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00a1\u00bf", "\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00a1\u00bf", "\u00a1\u00bf");
        }

        static {
            SPANISH sPANISH;
            INSTANCE = sPANISH = new SPANISH();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ASTURIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class ASTURIAN
    extends SetBasedAlphabet {
        @NotNull
        public static final ASTURIAN INSTANCE;

        private ASTURIAN() {
            super(Group.LATIN, "abcdefghilmn\u00f1oprstuvxyz", "\u00f1", "");
        }

        static {
            ASTURIAN aSTURIAN;
            INSTANCE = aSTURIAN = new ASTURIAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$BRETON;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class BRETON
    extends SetBasedAlphabet {
        @NotNull
        public static final BRETON INSTANCE;

        private BRETON() {
            super(Group.LATIN, "abcdefghijklmnoprstuvwyz\u00e2\u00ea\u00ee\u00f4\u00fb\u00f9\u00fc\u00f1", "\u00e2\u00ea\u00ee\u00f4\u00fb\u00f9\u00fc\u00f1", "");
        }

        static {
            BRETON bRETON;
            INSTANCE = bRETON = new BRETON();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$CATALAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class CATALAN
    extends SetBasedAlphabet {
        @NotNull
        public static final CATALAN INSTANCE;

        private CATALAN() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00e8\u00ed\u00ef\u00f3\u00f2\u00fa\u00fc\u00e7", "\u00e0\u00e9\u00e8\u00ed\u00ef\u00f3\u00f2\u00fa\u00fc\u00e7", "");
        }

        static {
            CATALAN cATALAN;
            INSTANCE = cATALAN = new CATALAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$DANISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class DANISH
    extends SetBasedAlphabet {
        @NotNull
        public static final DANISH INSTANCE;

        private DANISH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e6\u00f8\u00e5", "\u00e6\u00f8\u00e5", "\u00e6\u00f8");
        }

        static {
            DANISH dANISH;
            INSTANCE = dANISH = new DANISH();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ESPERANTO;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class ESPERANTO
    extends SetBasedAlphabet {
        @NotNull
        public static final ESPERANTO INSTANCE;

        private ESPERANTO() {
            super(Group.LATIN, "abc\u0109defg\u011dh\u0125ij\u0135klmnoprs\u015dtu\u016dvz", "\u0109\u011d\u0125\u0135\u015d\u016d", "\u0109\u011d\u0125\u0135\u015d\u016d");
        }

        static {
            ESPERANTO eSPERANTO;
            INSTANCE = eSPERANTO = new ESPERANTO();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$GALICIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class GALICIAN
    extends SetBasedAlphabet {
        @NotNull
        public static final GALICIAN INSTANCE;

        private GALICIAN() {
            super(Group.LATIN, "abcdefghilmn\u00f1opqrstuvxz", "\u00f1", "");
        }

        static {
            GALICIAN gALICIAN;
            INSTANCE = gALICIAN = new GALICIAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$IRISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class IRISH
    extends SetBasedAlphabet {
        @NotNull
        public static final IRISH INSTANCE;

        private IRISH() {
            super(Group.LATIN, "abcdefghilmnoprstu\u00e1\u00e9\u00ed\u00f3\u00fa", "\u00e1\u00e9\u00ed\u00f3\u00fa", "");
        }

        static {
            IRISH iRISH;
            INSTANCE = iRISH = new IRISH();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$SLOVENE;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class SLOVENE
    extends SetBasedAlphabet {
        @NotNull
        public static final SLOVENE INSTANCE;

        private SLOVENE() {
            super(Group.LATIN, "abc\u010ddefghijklmnoprs\u0161tuvz\u017e", "\u010d\u0161\u017e", "");
        }

        static {
            SLOVENE sLOVENE;
            INSTANCE = sLOVENE = new SLOVENE();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$SWEDISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class SWEDISH
    extends SetBasedAlphabet {
        @NotNull
        public static final SWEDISH INSTANCE;

        private SWEDISH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6", "\u00e5\u00e4\u00f6", "");
        }

        static {
            SWEDISH sWEDISH;
            INSTANCE = sWEDISH = new SWEDISH();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$TAGALOG;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class TAGALOG
    extends SetBasedAlphabet {
        @NotNull
        public static final TAGALOG INSTANCE;

        private TAGALOG() {
            super(Group.LATIN, "abcdefghijklmn\u00f1opqrstuvwxyz", "\u00f1", "");
        }

        static {
            TAGALOG tAGALOG;
            INSTANCE = tAGALOG = new TAGALOG();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$GREEK;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "nlp-detector"})
    public static final class GREEK
    extends RegexAlphabet {
        @NotNull
        public static final GREEK INSTANCE;

        private GREEK() {
            super(Group.GREEK, new Regex('[' + AlphabetRegex.INSTANCE.getGreek() + "]+"), null, null, 12, null);
        }

        static {
            GREEK gREEK;
            INSTANCE = gREEK = new GREEK();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$KHMER;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "nlp-detector"})
    public static final class KHMER
    extends RegexAlphabet {
        @NotNull
        public static final KHMER INSTANCE;

        private KHMER() {
            super(Group.KHMER, new Regex('[' + AlphabetRegex.INSTANCE.getKhmer() + "]+"), null, null, 12, null);
        }

        static {
            KHMER kHMER;
            INSTANCE = kHMER = new KHMER();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$TAMIL;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "nlp-detector"})
    public static final class TAMIL
    extends RegexAlphabet {
        @NotNull
        public static final TAMIL INSTANCE;

        private TAMIL() {
            super(Group.TAMIL, new Regex('[' + AlphabetRegex.INSTANCE.getTamil() + "]+"), null, null, 12, null);
        }

        static {
            TAMIL tAMIL;
            INSTANCE = tAMIL = new TAMIL();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ARABIC;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "nlp-detector"})
    public static final class ARABIC
    extends RegexAlphabet {
        @NotNull
        public static final ARABIC INSTANCE;

        private ARABIC() {
            super(Group.ARABIC, new Regex('[' + AlphabetRegex.INSTANCE.getArabic() + "]+"), null, null);
        }

        static {
            ARABIC aRABIC;
            INSTANCE = aRABIC = new ARABIC();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$PERSIAN;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "nlp-detector"})
    public static final class PERSIAN
    extends RegexAlphabet {
        @NotNull
        public static final PERSIAN INSTANCE;

        private PERSIAN() {
            super(Group.ARABIC, new Regex('[' + AlphabetRegex.INSTANCE.getArabic() + "\\u200C]+"), new Regex("\\u200C"), new Regex("\\u200C"));
        }

        static {
            PERSIAN pERSIAN;
            INSTANCE = pERSIAN = new PERSIAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$CHINESE;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "nlp-detector"})
    public static final class CHINESE
    extends RegexAlphabet {
        @NotNull
        public static final CHINESE INSTANCE;

        private CHINESE() {
            super(Group.ASIAN, new Regex('[' + AlphabetRegex.INSTANCE.getHan() + "]+"), null, null, 12, null);
        }

        static {
            CHINESE cHINESE;
            INSTANCE = cHINESE = new CHINESE();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$JAPANESE;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "nlp-detector"})
    public static final class JAPANESE
    extends RegexAlphabet {
        @NotNull
        public static final JAPANESE INSTANCE;

        private JAPANESE() {
            super(Group.ASIAN, new Regex('[' + AlphabetRegex.INSTANCE.getHiragana() + AlphabetRegex.INSTANCE.getKatakana() + AlphabetRegex.INSTANCE.getHan() + "]+"), null, null, 12, null);
        }

        static {
            JAPANESE jAPANESE;
            INSTANCE = jAPANESE = new JAPANESE();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$RUSSIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class RUSSIAN
    extends SetBasedAlphabet {
        @NotNull
        public static final RUSSIAN INSTANCE;

        private RUSSIAN() {
            super(Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", "\u0451\u0439\u044a\u044b\u044d", "\u044a");
        }

        static {
            RUSSIAN rUSSIAN;
            INSTANCE = rUSSIAN = new RUSSIAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$UKRANIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class UKRANIAN
    extends SetBasedAlphabet {
        @NotNull
        public static final UKRANIAN INSTANCE;

        private UKRANIAN() {
            super(Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0491\u0434\u0435\u0454\u0436\u0437\u0438\u0456\u0457\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044c\u044e\u044f", "\u0454\u0456\u0457\u0491", "\u0457\u0491");
        }

        static {
            UKRANIAN uKRANIAN;
            INSTANCE = uKRANIAN = new UKRANIAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$BELARUSIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "nlp-detector"})
    public static final class BELARUSIAN
    extends SetBasedAlphabet {
        @NotNull
        public static final BELARUSIAN INSTANCE;

        private BELARUSIAN() {
            super(Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0456\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u045e\u0444\u0445\u0446\u0447\u0448\u044b\u044c\u044d\u044e\u044f", "\u0451\u0439\u0454\u044b\u0456\u045e", "\u045e");
        }

        static {
            BELARUSIAN bELARUSIAN;
            INSTANCE = bELARUSIAN = new BELARUSIAN();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$NONE;", "Lcom/intellij/grazie/detector/model/alphabet/NoneAlphabet;", "()V", "nlp-detector"})
    public static final class NONE
    extends NoneAlphabet {
        @NotNull
        public static final NONE INSTANCE;

        private NONE() {
        }

        static {
            NONE nONE;
            INSTANCE = nONE = new NONE();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\u001d\u001a\u00020\u001eR!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0004j\b\u0012\u0004\u0012\u00020\n`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0004j\b\u0012\u0004\u0012\u00020\n`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0004j\b\u0012\u0004\u0012\u00020\u000f`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0004j\b\u0012\u0004\u0012\u00020\u0012`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0004j\b\u0012\u0004\u0012\u00020\u0015`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR!\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0004j\b\u0012\u0004\u0012\u00020\u000f`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR!\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0004j\b\u0012\u0004\u0012\u00020\u001a`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Companion;", "", "()V", "all", "Ljava/util/LinkedHashSet;", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet;", "Lkotlin/collections/LinkedHashSet;", "getAll", "()Ljava/util/LinkedHashSet;", "arabic", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "getArabic", "asian", "getAsian", "cyrillic", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "getCyrillic", "greek", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$GREEK;", "getGreek", "khmer", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$KHMER;", "getKhmer", "latin", "getLatin", "tamil", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$TAMIL;", "getTamil", "byGroup", "group", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "nlp-detector"})
    public static final class Companion {
        @NotNull
        public final LinkedHashSet<Alphabet> getAll() {
            return all;
        }

        @NotNull
        public final LinkedHashSet<SetBasedAlphabet> getLatin() {
            return latin;
        }

        @NotNull
        public final LinkedHashSet<GREEK> getGreek() {
            return greek;
        }

        @NotNull
        public final LinkedHashSet<KHMER> getKhmer() {
            return khmer;
        }

        @NotNull
        public final LinkedHashSet<TAMIL> getTamil() {
            return tamil;
        }

        @NotNull
        public final LinkedHashSet<RegexAlphabet> getArabic() {
            return arabic;
        }

        @NotNull
        public final LinkedHashSet<SetBasedAlphabet> getCyrillic() {
            return cyrillic;
        }

        @NotNull
        public final LinkedHashSet<RegexAlphabet> getAsian() {
            return asian;
        }

        @NotNull
        public final LinkedHashSet<? extends Alphabet> byGroup(@NotNull Group group) {
            LinkedHashSet<Alphabet> linkedHashSet;
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            switch (Alphabet$Companion$WhenMappings.$EnumSwitchMapping$0[group.ordinal()]) {
                case 1: {
                    linkedHashSet = this.getLatin();
                    break;
                }
                case 2: {
                    linkedHashSet = this.getGreek();
                    break;
                }
                case 3: {
                    linkedHashSet = this.getKhmer();
                    break;
                }
                case 4: {
                    linkedHashSet = this.getTamil();
                    break;
                }
                case 5: {
                    linkedHashSet = this.getArabic();
                    break;
                }
                case 6: {
                    linkedHashSet = this.getAsian();
                    break;
                }
                case 7: {
                    linkedHashSet = this.getCyrillic();
                    break;
                }
                case 8: {
                    linkedHashSet = SetsKt.linkedSetOf((Object[])new NONE[]{NONE.INSTANCE});
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return linkedHashSet;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

