/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.heuristics.list;

import com.intellij.grazie.detector.LanguageDetector;
import com.intellij.grazie.detector.heuristics.list.ListDetector;
import com.intellij.grazie.detector.heuristics.list.impl.ListProfile;
import com.intellij.grazie.detector.heuristics.list.impl.ListProfileReader;
import com.intellij.grazie.detector.model.DetectedLanguage;
import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.utils.StatisticsKt;
import com.intellij.grazie.detector.utils.UtilsKt;
import com.intellij.grazie.detector.utils.resources.ResourceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B%\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grazie/detector/heuristics/list/ListDetector;", "Lcom/intellij/grazie/detector/LanguageDetector;", "", "languages", "Ljava/util/LinkedHashSet;", "Lcom/intellij/grazie/detector/model/Language;", "Lkotlin/collections/LinkedHashSet;", "loader", "Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;", "(Ljava/util/LinkedHashSet;Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;)V", "getLanguages", "()Ljava/util/LinkedHashSet;", "getLoader", "()Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;", "profiles", "", "Lkotlin/Pair;", "Lcom/intellij/grazie/detector/heuristics/list/impl/ListProfile;", "detect", "Lcom/intellij/grazie/detector/LanguageDetector$DetectionResult;", "input", "isReliable", "", "Companion", "Text", "nlp-detector"})
public final class ListDetector
implements LanguageDetector<CharSequence> {
    private final List<Pair<Language, ListProfile>> profiles;
    @NotNull
    private final LinkedHashSet<Language> languages;
    @NotNull
    private final ResourceLoader loader;
    public static final double MINIMAL_MEANINGFUL = 0.5;
    public static final double MINIMAL_TO_DETECT = 0.6;
    @NotNull
    private static final List<Language> supported;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LanguageDetector.DetectionResult detect(@NotNull CharSequence input, boolean isReliable) {
        Map map;
        void $this$mapValues$iv;
        Map probs;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List<String> words = UtilsKt.wordsLower(input);
        if (isReliable && (words.size() < 3 || words.size() == 1 && input.length() < 10)) {
            return LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.List);
        }
        double minimalMeaningfulSize = (double)words.size() * 0.5;
        double minimalToDetectSize = (double)words.size() * 0.6;
        HashMap<void, Integer> langCounts = new HashMap<void, Integer>(this.languages.size());
        HashMap<void, Double> langWeights = new HashMap<void, Double>(this.languages.size());
        for (Pair<Language, ListProfile> pair : this.profiles) {
            Language language = (Language)((Object)pair.component1());
            ListProfile profile = (ListProfile)pair.component2();
            for (String string : words) {
                void lang;
                if (!profile.match(string)) continue;
                langCounts.merge(lang, 1, detect.1.INSTANCE);
                langWeights.merge(lang, profile.weight(string), detect.2.INSTANCE);
            }
        }
        Map $this$filterValues$iv = langCounts;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry : map2.entrySet()) {
            int n = ((Number)entry.getValue()).intValue();
            boolean bl2 = false;
            if (!((double)n >= minimalMeaningfulSize)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map $this$filterValues$iv2 = probs = (Map)result$iv;
        boolean $i$f$filterValues232 = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Map map3 = $this$filterValues$iv2;
        boolean bl2 = false;
        for (Map.Entry entry : map3.entrySet()) {
            int it = ((Number)entry.getValue()).intValue();
            boolean bl4 = false;
            if (!((double)it >= minimalToDetectSize)) continue;
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        $this$filterValues$iv2 = linkedHashMap;
        Comparator $i$f$filterValues232 = new Comparator<Map.Entry<? extends Language, ? extends Integer>>(langWeights){
            final /* synthetic */ HashMap $langWeights;

            public final int compare(Map.Entry<? extends Language, Integer> t, Map.Entry<? extends Language, Integer> t2) {
                int n;
                if (((Number)t.getValue()).intValue() != ((Number)t2.getValue()).intValue()) {
                    n = ((Number)t.getValue()).intValue() - ((Number)t2.getValue()).intValue();
                } else if (Intrinsics.areEqual((Object)((Double)this.$langWeights.get((Object)((Object)t.getKey()))), (Object)((Double)this.$langWeights.get((Object)((Object)t2.getKey())))) ^ true) {
                    V v = this.$langWeights.get((Object)((Object)t.getKey()));
                    Intrinsics.checkNotNull(v);
                    double d = ((Number)v).doubleValue();
                    V v2 = this.$langWeights.get((Object)((Object)t2.getKey()));
                    Intrinsics.checkNotNull(v2);
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"langWeights[t2.key]!!");
                    n = Double.compare(d, ((Number)v2).doubleValue());
                } else {
                    n = t.getKey().getIso().compareTo((Enum)t2.getKey().getIso());
                }
                return n;
            }
            {
                this.$langWeights = hashMap;
            }
        };
        boolean bl3 = false;
        Map.Entry pref2 = (Map.Entry)CollectionsKt.maxWithOrNull((Iterable)$this$filterValues$iv2.entrySet(), (Comparator)$i$f$filterValues232);
        Object object = pref2;
        if (object == null || (object = (Language)((Object)object.getKey())) == null) {
            object = Language.UNKNOWN;
        }
        $this$filterValues$iv2 = probs;
        Object object2 = object;
        LanguageDetector.Type type = LanguageDetector.Type.List;
        boolean $i$f$mapValues = false;
        void var14_21 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = var14_21.entrySet();
        boolean bl4 = false;
        for (Object element$iv$iv$iv : iterable) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl5 = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map4;
            boolean bl6 = false;
            Object v = langWeights.get(it.getKey());
            Intrinsics.checkNotNull(v);
            Double d = (Double)v;
            map.put(k2, d);
        }
        map = destination$iv$iv;
        LinkedHashSet<DetectedLanguage> linkedHashSet = StatisticsKt.toDetected(map);
        Object object3 = object2;
        LanguageDetector.Type type2 = type;
        return new LanguageDetector.DetectionResult(type2, (Language)((Object)object3), linkedHashSet);
    }

    @NotNull
    public final LinkedHashSet<Language> getLanguages() {
        return this.languages;
    }

    @NotNull
    public final ResourceLoader getLoader() {
        return this.loader;
    }

    /*
     * WARNING - void declaration
     */
    public ListDetector(@NotNull LinkedHashSet<Language> languages, @NotNull ResourceLoader loader) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Language it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        this.languages = languages;
        this.loader = loader;
        Iterable iterable = this.languages;
        ListDetector listDetector = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            if (!supported.contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Pair> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Language)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((Object)it), (Object)ListProfileReader.INSTANCE.getProfile(it, this.loader));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        listDetector.profiles = collection;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$filterNot$iv = Language.Companion.getAll();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            if (SetsKt.setOf((Object[])new Language[]{Language.CHINESE, Language.JAPANESE, Language.GREEK, Language.KHMER, Language.ASTURIAN}).contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        supported = (List)var3_3;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/grazie/detector/heuristics/list/ListDetector$Text;", "", "text", "", "words", "", "(Ljava/lang/String;Ljava/util/List;)V", "getText", "()Ljava/lang/String;", "getWords", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "nlp-detector"})
    public static final class Text {
        @NotNull
        private final String text;
        @NotNull
        private final List<String> words;

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<String> getWords() {
            return this.words;
        }

        public Text(@NotNull String text, @NotNull List<String> words) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(words, (String)"words");
            this.text = text;
            this.words = words;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<String> component2() {
            return this.words;
        }

        @NotNull
        public final Text copy(@NotNull String text, @NotNull List<String> words) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(words, (String)"words");
            return new Text(text, words);
        }

        public static /* synthetic */ Text copy$default(Text text, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = text.text;
            }
            if ((n & 2) != 0) {
                list = text.words;
            }
            return text.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "Text(text=" + this.text + ", words=" + this.words + ")";
        }

        public int hashCode() {
            String string = this.text;
            List<String> list = this.words;
            return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Text)) break block3;
                    Text text = (Text)object;
                    if (!Intrinsics.areEqual((Object)this.text, (Object)text.text) || !Intrinsics.areEqual(this.words, text.words)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grazie/detector/heuristics/list/ListDetector$Companion;", "", "()V", "MINIMAL_MEANINGFUL", "", "MINIMAL_TO_DETECT", "supported", "", "Lcom/intellij/grazie/detector/model/Language;", "getSupported", "()Ljava/util/List;", "nlp-detector"})
    public static final class Companion {
        @NotNull
        public final List<Language> getSupported() {
            return supported;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

