/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.chain;

import com.intellij.grazie.detector.ChainLanguageDetector;
import com.intellij.grazie.detector.LanguageDetector;
import com.intellij.grazie.detector.LanguageFilter;
import com.intellij.grazie.detector.heuristics.list.ListDetector;
import com.intellij.grazie.detector.heuristics.rule.RuleDetector;
import com.intellij.grazie.detector.heuristics.rule.RuleFilter;
import com.intellij.grazie.detector.model.DetectedLanguage;
import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.ngram.NgramDetector;
import com.intellij.grazie.detector.ngram.NgramDetectorBuilder;
import com.intellij.grazie.detector.utils.StatisticsKt;
import com.intellij.grazie.detector.utils.UtilsKt;
import com.intellij.grazie.detector.utils.filter.TextFilter;
import com.intellij.grazie.detector.utils.resources.ResourceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B%\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/grazie/detector/chain/ChainDetectorImpl;", "Lcom/intellij/grazie/detector/ChainLanguageDetector;", "", "languages", "Ljava/util/LinkedHashSet;", "Lcom/intellij/grazie/detector/model/Language;", "Lkotlin/collections/LinkedHashSet;", "loader", "Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;", "(Ljava/util/LinkedHashSet;Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;)V", "filter", "Lcom/intellij/grazie/detector/heuristics/rule/RuleFilter;", "list", "Lcom/intellij/grazie/detector/heuristics/list/ListDetector;", "ngram", "Lcom/intellij/grazie/detector/ngram/NgramDetector;", "rule", "Lcom/intellij/grazie/detector/heuristics/rule/RuleDetector;", "detectWithDetails", "Lcom/intellij/grazie/detector/ChainLanguageDetector$ChainDetectionResult;", "input", "isReliable", "", "Companion", "nlp-detector"})
public final class ChainDetectorImpl
implements ChainLanguageDetector<CharSequence> {
    private final RuleDetector rule;
    private final ListDetector list;
    private final RuleFilter filter;
    private final NgramDetector ngram;
    private final LinkedHashSet<Language> languages;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ChainLanguageDetector.ChainDetectionResult detectWithDetails(@NotNull CharSequence input, boolean isReliable) {
        boolean bl;
        LanguageFilter.FilterResult ruleFiltering;
        LanguageDetector.DetectionResult freqDetection;
        LanguageDetector.DetectionResult rulesDetection;
        LinkedHashSet<LanguageDetector.DetectionResult> all2;
        CharSequence textWithoutPrefix;
        CharSequence text;
        block6: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            text = isReliable ? TextFilter.Companion.getReliable().filter(input) : TextFilter.Companion.getDefault().filter(input);
            textWithoutPrefix = UtilsKt.dropPrefix(text);
            List<String> words = UtilsKt.wordsLower(text);
            List<String> wordsWithoutPrefix = UtilsKt.wordsLower(textWithoutPrefix);
            all2 = new LinkedHashSet<LanguageDetector.DetectionResult>();
            rulesDetection = this.rule.detect(isReliable ? wordsWithoutPrefix : words, isReliable);
            Collection collection = all2;
            boolean bl2 = false;
            collection.add(rulesDetection);
            if (rulesDetection.getPreferred() != Language.UNKNOWN) {
                return new ChainLanguageDetector.ChainDetectionResult(rulesDetection, all2);
            }
            freqDetection = this.list.detect(isReliable ? textWithoutPrefix : text, isReliable);
            Collection collection2 = all2;
            boolean bl3 = false;
            collection2.add(freqDetection);
            if (freqDetection.getPreferred() != Language.UNKNOWN) {
                return new ChainLanguageDetector.ChainDetectionResult(freqDetection, all2);
            }
            ruleFiltering = this.filter.filter(isReliable ? wordsWithoutPrefix : words);
            Iterable $this$all$iv = ruleFiltering.getDetected();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DetectedLanguage it = (DetectedLanguage)element$iv;
                    boolean bl4 = false;
                    if (!this.languages.contains((Object)it.getLang())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return new ChainLanguageDetector.ChainDetectionResult(freqDetection, all2);
        }
        Map<Language, Double> weights = StatisticsKt.toMap(CollectionsKt.toList((Iterable)StatisticsKt.unite(rulesDetection.getDetected(), freqDetection.getDetected(), ruleFiltering.getDetected())));
        LanguageDetector.DetectionResult ngramDetection = this.ngram.detect(isReliable ? textWithoutPrefix : text, isReliable, weights);
        Collection collection = all2;
        boolean bl5 = false;
        collection.add(ngramDetection);
        return new ChainLanguageDetector.ChainDetectionResult(ngramDetection, all2);
    }

    public ChainDetectorImpl(@NotNull LinkedHashSet<Language> languages, @NotNull ResourceLoader loader) {
        Language it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        this.languages = languages;
        Iterable iterable = this.languages;
        ChainDetectorImpl chainDetectorImpl = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            if (!RuleDetector.Companion.getSupported().contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        LinkedHashSet<Language> linkedHashSet = com.intellij.grazie.detector.utils.collections.UtilsKt.toLinkedSet(list);
        chainDetectorImpl.rule = new RuleDetector(linkedHashSet);
        $this$filter$iv = this.languages;
        chainDetectorImpl = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            if (!ListDetector.Companion.getSupported().contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        ResourceLoader resourceLoader = loader;
        LinkedHashSet<Language> linkedHashSet2 = com.intellij.grazie.detector.utils.collections.UtilsKt.toLinkedSet(list);
        chainDetectorImpl.list = new ListDetector(linkedHashSet2, resourceLoader);
        this.filter = new RuleFilter(this.languages);
        $this$filter$iv = this.languages;
        ResourceLoader resourceLoader2 = loader;
        NgramDetectorBuilder.Companion companion = NgramDetectorBuilder.Companion;
        chainDetectorImpl = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            if (!NgramDetector.Companion.getSupported().contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        chainDetectorImpl.ngram = companion.standardForLanguage(resourceLoader2, com.intellij.grazie.detector.utils.collections.UtilsKt.toLinkedSet(list));
    }

    @Override
    @NotNull
    public LanguageDetector.DetectionResult detect(@NotNull CharSequence input, boolean isReliable) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return ChainLanguageDetector.DefaultImpls.detect(this, input, isReliable);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/grazie/detector/chain/ChainDetectorImpl$Companion;", "", "()V", "create", "Lcom/intellij/grazie/detector/ChainLanguageDetector;", "", "languages", "Ljava/util/LinkedHashSet;", "Lcom/intellij/grazie/detector/model/Language;", "Lkotlin/collections/LinkedHashSet;", "loader", "Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;", "nlp-detector"})
    public static final class Companion {
        @NotNull
        public final ChainLanguageDetector<CharSequence> create(@NotNull LinkedHashSet<Language> languages, @NotNull ResourceLoader loader) {
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            return new ChainDetectorImpl(languages, loader);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

