/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.enumerating;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.LineEnumeratorFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class KotlinDefaultArgsBranchFilter
extends LineEnumeratorFilter {
    private int myMaxMaskIndex = -1;
    private int myMinMaskIndex = -1;
    private boolean myIgnoreNextIf = false;
    private boolean myAndVisited = false;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return (access & 0x1000) != 0 && KotlinUtils.isKotlinClass(context) && name.endsWith("$default");
    }

    static int sourceParametersCount(int z) {
        return z - 1 - (z - 1 + 32) / 33;
    }

    public void visitCode() {
        super.visitCode();
        Type[] parameters = Type.getType(this.myContext.getDescriptor()).getArgumentTypes();
        int sourceCount = KotlinDefaultArgsBranchFilter.sourceParametersCount(parameters.length);
        int size = 0;
        for (int i = 0; i < parameters.length - 2; ++i) {
            size += parameters[i].getSize();
            if (i != sourceCount - 1) continue;
            this.myMinMaskIndex = size;
        }
        this.myMaxMaskIndex = size;
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.myIgnoreNextIf = this.myMinMaskIndex <= var && var <= this.myMaxMaskIndex;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.myAndVisited |= this.myIgnoreNextIf && opcode == 126;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (opcode == 153 && this.myIgnoreNextIf) {
            if (this.myAndVisited) {
                this.myContext.getBranchData().removeLastJump();
            }
            this.myIgnoreNextIf = false;
            this.myAndVisited = false;
        }
    }
}

