/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.THashSet;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR45Util {
    private static final String FILE_SECTION = "*F\n";
    private static final String LINE_SECTION = "*L\n";
    private static final String SECTION_SEPARATOR = "*";
    private static final LineMapData[] EMPTY_LINE_MAP = new LineMapData[0];

    private static String checkSMAP(String debug) {
        return debug.startsWith("SMAP") ? debug.substring(4) : null;
    }

    public static FileMapData[] extractLineMapping(String debug, String className) {
        if ((debug = JSR45Util.checkSMAP(debug)) != null) {
            TIntObjectHashMap linesMap = new TIntObjectHashMap();
            int fileSectionIdx = debug.indexOf(FILE_SECTION);
            int lineInfoIdx = debug.indexOf(LINE_SECTION);
            TIntObjectHashMap<String> fileNames = JSR45Util.parseFileNames(debug, fileSectionIdx, lineInfoIdx, className);
            int lineInfoStart = lineInfoIdx + LINE_SECTION.length();
            int lineInfoEnd = debug.indexOf(SECTION_SEPARATOR, lineInfoStart);
            String lineInfo = debug.substring(lineInfoStart, lineInfoEnd);
            String[] lines = lineInfo.split("\n");
            int fileId = 1;
            for (String line : lines) {
                int startOutLine;
                int startSrcLine;
                int repeat = 1;
                int outLineInc = 1;
                int idx = line.indexOf(":");
                String srcLine = line.substring(0, idx);
                String outLine = line.substring(idx + 1);
                int srcCommaIdx = srcLine.indexOf(44);
                int sharpIdx = srcLine.indexOf("#");
                if (sharpIdx > -1) {
                    startSrcLine = Integer.parseInt(srcLine.substring(0, sharpIdx));
                    if (srcCommaIdx > -1) {
                        repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                        fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1, srcCommaIdx));
                    } else {
                        fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1));
                    }
                } else if (srcCommaIdx > -1) {
                    repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                    startSrcLine = Integer.parseInt(srcLine.substring(0, srcCommaIdx));
                } else {
                    startSrcLine = Integer.parseInt(srcLine);
                }
                int outCommaIdx = outLine.indexOf(44);
                if (outCommaIdx > -1) {
                    outLineInc = Integer.parseInt(outLine.substring(outCommaIdx + 1));
                    startOutLine = Integer.parseInt(outLine.substring(0, outCommaIdx));
                } else {
                    startOutLine = Integer.parseInt(outLine);
                }
                THashSet<LineMapData> currentFile = (THashSet<LineMapData>)linesMap.get(fileId);
                if (currentFile == null) {
                    currentFile = new THashSet<LineMapData>();
                    linesMap.put(fileId, currentFile);
                }
                for (int r = 0; r < repeat; ++r) {
                    currentFile.add(new LineMapData(startSrcLine + r, startOutLine + r * outLineInc, startOutLine + (r + 1) * outLineInc - 1));
                }
            }
            ArrayList<FileMapData> result = new ArrayList<FileMapData>();
            int[] keys = linesMap.keys();
            Arrays.sort(keys);
            for (int key : keys) {
                result.add(new FileMapData(fileNames.get(key), JSR45Util.getLinesMapping((THashSet)linesMap.get(key))));
            }
            return result.toArray(FileMapData.EMPTY_FILE_MAP);
        }
        return null;
    }

    private static String[] getFileSectionLines(String debug, int fileSectionIdx, int lineInfoIdx) {
        String fileSection = debug.substring(fileSectionIdx + FILE_SECTION.length(), lineInfoIdx);
        if ((fileSection = fileSection.trim()).endsWith("\n")) {
            fileSection = fileSection.substring(0, fileSection.length() - 1);
        }
        return fileSection.split("\n");
    }

    private static TIntObjectHashMap<String> parseFileNames(String debug, int fileSectionIdx, int lineInfoIdx, String className) {
        final String defaultPrefix = JSR45Util.getClassPackageName(className);
        String[] fileNameIdx = JSR45Util.getFileSectionLines(debug, fileSectionIdx, lineInfoIdx);
        TIntObjectHashMap<String> result = new TIntObjectHashMap<String>();
        boolean generatedPrefix = true;
        for (int i = 0; i < fileNameIdx.length; ++i) {
            String fileName;
            String idAndName = fileName = fileNameIdx[i];
            String path = null;
            if (fileName.startsWith("+ ")) {
                idAndName = fileName.substring(2);
                path = fileNameIdx[++i];
            }
            int idx = idAndName.indexOf(" ");
            int key = Integer.parseInt(idAndName.substring(0, idx));
            String currentClassName = idAndName.substring(idx + 1);
            path = path == null ? currentClassName : JSR45Util.processRelative(path);
            int lastDot = path.lastIndexOf(".");
            String fileNameWithDots = lastDot < 0 ? path : path.substring(0, lastDot) + "_" + path.substring(lastDot + 1);
            fileNameWithDots = ClassNameUtil.convertToFQName(fileNameWithDots);
            generatedPrefix &= !fileNameWithDots.startsWith(defaultPrefix);
            currentClassName = fileNameWithDots;
            result.put(key, currentClassName);
        }
        if (generatedPrefix) {
            result.transformValues(new TObjectFunction<String, String>(){

                @Override
                public String execute(String selfValue) {
                    return defaultPrefix + selfValue;
                }
            });
        }
        return result;
    }

    public static String processRelative(String fileName) {
        int idx;
        while ((idx = fileName.indexOf("..")) > -1) {
            String rest = fileName.substring(idx + "..".length());
            String start = fileName.substring(0, idx);
            if (!start.endsWith("/")) {
                return fileName;
            }
            int endIndex = (start = start.substring(0, start.length() - 1)).lastIndexOf(47);
            if (endIndex > -1) {
                fileName = start.substring(0, endIndex) + rest;
                continue;
            }
            fileName = rest.startsWith("/") ? rest.substring(1) : rest;
        }
        return fileName;
    }

    public static String getClassPackageName(String className) {
        String generatePrefix = "";
        int fqnLastDotIdx = className.lastIndexOf(".");
        if (fqnLastDotIdx > -1) {
            generatePrefix = className.substring(0, fqnLastDotIdx + 1);
        }
        return generatePrefix;
    }

    private static LineMapData[] getLinesMapping(THashSet<LineMapData> linesMap) {
        LineMapData[] result = linesMap.toArray(EMPTY_LINE_MAP);
        Arrays.sort(result, new Comparator<LineMapData>(){

            @Override
            public int compare(LineMapData o1, LineMapData o2) {
                int compareSource = o1.getSourceLineNumber() - o2.getSourceLineNumber();
                if (compareSource == 0) {
                    int compareMin = o1.getTargetMinLine() - o2.getTargetMinLine();
                    if (compareMin == 0) {
                        return o1.getTargetMaxLine() - o2.getTargetMaxLine();
                    }
                    return compareMin;
                }
                return compareSource;
            }
        });
        return result;
    }

    public static List<String> parseSourcePaths(String debug) {
        if ((debug = JSR45Util.checkSMAP(debug)) != null) {
            String[] fileNameIdx = JSR45Util.getFileSectionLines(debug, debug.indexOf(FILE_SECTION), debug.indexOf(LINE_SECTION));
            ArrayList<String> paths = new ArrayList<String>();
            for (int i = 0; i < fileNameIdx.length; ++i) {
                String fileName;
                String idAndName = fileName = fileNameIdx[i];
                String path = null;
                if (fileName.startsWith("+ ")) {
                    idAndName = fileName.substring(2);
                    path = fileNameIdx[++i];
                }
                int idx = idAndName.indexOf(" ");
                String currentClassName = idAndName.substring(idx + 1);
                if (path == null) {
                    path = currentClassName;
                } else {
                    int lastSlashIdx = (path = JSR45Util.processRelative(path)).lastIndexOf("/");
                    if (lastSlashIdx > 0) {
                        path = path.substring(0, ++lastSlashIdx) + currentClassName;
                    }
                }
                paths.add(path);
            }
            return paths;
        }
        return Collections.emptyList();
    }
}

