/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchesDashboardUtil;
import git4idea.ui.branch.dashboard.IncomingOutgoing;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0004J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0004J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u001f\u001a\u00020\u000fJ\u0014\u0010 \u001a\u0004\u0018\u00010\u001e*\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000f\u00a8\u0006!"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardUtil;", "", "()V", "checkIsMyBranchesSynchronously", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "log", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "branchesToCheck", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findExclusiveCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "branchName", "", "repo", "Lgit4idea/repo/GitRepository;", "findMyCommits", "", "getLocalBranches", "project", "Lcom/intellij/openapi/project/Project;", "rootsToFilter", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRemoteBranches", "isMyBranch", "", "myCommits", "anyIncomingOutgoingState", "Lgit4idea/ui/branch/dashboard/IncomingOutgoing;", "localBranchName", "getIncomingOutgoingState", "intellij.vcs.git"})
public final class BranchesDashboardUtil {
    @NotNull
    public static final BranchesDashboardUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getLocalBranches(@NotNull Project project, @Nullable Set<? extends VirtualFile> rootsToFilter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = false;
        Map localMap = new LinkedHashMap();
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
        for (GitRepository repo : gitRepositoryManager.getRepositories()) {
            if (rootsToFilter != null) {
                GitRepository gitRepository = repo;
                Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                if (!rootsToFilter.contains(gitRepository.getRoot())) continue;
            }
            GitRepository gitRepository = repo;
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
            GitBranchesCollection gitBranchesCollection = gitRepository.getBranches();
            Intrinsics.checkNotNullExpressionValue((Object)gitBranchesCollection, (String)"repo.branches");
            Iterator<GitLocalBranch> iterator = gitBranchesCollection.getLocalBranches().iterator();
            while (iterator.hasNext()) {
                GitLocalBranch branch;
                GitLocalBranch gitLocalBranch = branch = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)gitLocalBranch, (String)"branch");
                ((Set)localMap.computeIfAbsent(gitLocalBranch.getName(), getLocalBranches.1.INSTANCE)).add(repo);
            }
            GitLocalBranch currentBranch = repo.getCurrentBranch();
            if (currentBranch == null) continue;
            ((Set)localMap.computeIfAbsent(currentBranch.getName(), getLocalBranches.2.INSTANCE)).add(repo);
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitBranchManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        Map $this$map$iv = localMap;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var11_16 = $this$mapTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var11_16.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            boolean bl4;
            void var22_27;
            void branchName;
            boolean bl5;
            Set repos;
            Collection collection;
            block11: {
                GitRepository it;
                boolean bl6;
                Iterable $this$any$iv;
                boolean $i$f$any;
                block10: {
                    void $dstr$branchName$repos;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    Iterable iterable = $dstr$branchName$repos;
                    boolean bl8 = false;
                    String string = (String)iterable.getKey();
                    iterable = $dstr$branchName$repos;
                    bl8 = false;
                    repos = (Set)iterable.getValue();
                    iterable = repos;
                    bl5 = true;
                    var22_27 = branchName;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (GitRepository)element$iv;
                            boolean bl9 = false;
                            GitLocalBranch gitLocalBranch = it.getCurrentBranch();
                            if (!Intrinsics.areEqual((Object)(gitLocalBranch != null ? gitLocalBranch.getName() : null), (Object)branchName)) continue;
                            bl6 = true;
                            break block10;
                        }
                        bl6 = false;
                    }
                }
                bl4 = bl6;
                $this$any$iv = repos;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (GitRepository)element$iv;
                        boolean bl10 = false;
                        if (!gitBranchManager.isFavorite(GitBranchType.LOCAL, it, (String)branchName)) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
            }
            boolean bl11 = bl3;
            List list2 = CollectionsKt.toList((Iterable)repos);
            IncomingOutgoing incomingOutgoing = INSTANCE.anyIncomingOutgoingState(repos, (String)branchName);
            boolean bl12 = bl11;
            boolean bl13 = bl4;
            boolean bl14 = bl5;
            void var38_41 = var22_27;
            BranchInfo branchInfo = new BranchInfo((String)var38_41, bl14, bl13, bl12, incomingOutgoing, list2);
            collection.add(branchInfo);
        }
        HashSet local = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        return local;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getRemoteBranches(@NotNull Project project, @Nullable Set<? extends VirtualFile> rootsToFilter) {
        void $this$mapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = false;
        Map remoteMap = new LinkedHashMap();
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
        for (GitRepository repo : gitRepositoryManager.getRepositories()) {
            if (rootsToFilter != null) {
                GitRepository gitRepository = repo;
                Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                if (!rootsToFilter.contains(gitRepository.getRoot())) continue;
            }
            GitRepository gitRepository = repo;
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
            GitBranchesCollection gitBranchesCollection = gitRepository.getBranches();
            Intrinsics.checkNotNullExpressionValue((Object)gitBranchesCollection, (String)"repo.branches");
            object = gitBranchesCollection.getRemoteBranches().iterator();
            while (object.hasNext()) {
                GitRemoteBranch remoteBranch;
                GitRemoteBranch gitRemoteBranch = remoteBranch = (GitRemoteBranch)object.next();
                Intrinsics.checkNotNullExpressionValue((Object)gitRemoteBranch, (String)"remoteBranch");
                ((List)remoteMap.computeIfAbsent(gitRemoteBranch.getName(), getRemoteBranches.1.INSTANCE)).add(repo);
            }
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object2 = $this$service$iv.getService(GitBranchManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object2);
        Map $this$map$iv = remoteMap;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var10_13 = $this$mapTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var10_13.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            void var22_25;
            boolean bl4;
            boolean bl5;
            List repos;
            Collection collection;
            block7: {
                void $this$any$iv;
                void branchName;
                void $dstr$branchName$repos;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl6 = false;
                Iterable iterable = $dstr$branchName$repos;
                boolean bl7 = false;
                String string = (String)iterable.getKey();
                iterable = $dstr$branchName$repos;
                bl7 = false;
                repos = (List)iterable.getValue();
                iterable = repos;
                bl5 = false;
                bl4 = false;
                var22_25 = branchName;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl8 = false;
                        if (!gitBranchManager.isFavorite(GitBranchType.REMOTE, it, (String)branchName)) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
            }
            boolean bl9 = bl3;
            List list2 = repos;
            IncomingOutgoing incomingOutgoing = null;
            boolean bl10 = bl9;
            boolean bl11 = bl5;
            boolean bl12 = bl4;
            void var37_38 = var22_25;
            BranchInfo branchInfo = new BranchInfo((String)var37_38, bl12, bl11, bl10, incomingOutgoing, list2);
            collection.add(branchInfo);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> checkIsMyBranchesSynchronously(@NotNull VcsProjectLog log, @NotNull Collection<BranchInfo> branchesToCheck, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(branchesToCheck, (String)"branchesToCheck");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Set<Integer> myCommits = this.findMyCommits(log);
        Collection collection = myCommits;
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            return SetsKt.emptySet();
        }
        indicator.setIndeterminate(false);
        bl = false;
        HashSet<BranchInfo> myBranches = new HashSet<BranchInfo>();
        bl = false;
        for (BranchInfo branch : (Iterable)branchesToCheck) {
            void step;
            indicator.setFraction((double)step / (double)branchesToCheck.size());
            for (GitRepository repo : branch.getRepositories()) {
                indicator.checkCanceled();
                if (!this.isMyBranch(log, branch.getBranchName(), repo, myCommits)) continue;
                myBranches.add(branch);
            }
            ++step;
        }
        return myBranches;
    }

    @Nullable
    public final IncomingOutgoing anyIncomingOutgoingState(@NotNull Collection<? extends GitRepository> $this$anyIncomingOutgoingState, @NotNull String localBranchName) {
        Intrinsics.checkNotNullParameter($this$anyIncomingOutgoingState, (String)"$this$anyIncomingOutgoingState");
        Intrinsics.checkNotNullParameter((Object)localBranchName, (String)"localBranchName");
        for (GitRepository gitRepository : $this$anyIncomingOutgoingState) {
            IncomingOutgoing incomingOutgoingState = this.getIncomingOutgoingState(gitRepository, localBranchName);
            if (incomingOutgoingState == null) continue;
            return incomingOutgoingState;
        }
        return null;
    }

    @Nullable
    public final IncomingOutgoing getIncomingOutgoingState(@NotNull GitRepository $this$getIncomingOutgoingState, @NotNull String localBranchName) {
        Intrinsics.checkNotNullParameter((Object)$this$getIncomingOutgoingState, (String)"$this$getIncomingOutgoingState");
        Intrinsics.checkNotNullParameter((Object)localBranchName, (String)"localBranchName");
        Project project = $this$getIncomingOutgoingState.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitBranchIncomingOutgoingManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        GitBranchIncomingOutgoingManager $this$with = (GitBranchIncomingOutgoingManager)object2;
        boolean bl3 = false;
        GitRepository repo = $this$getIncomingOutgoingState;
        boolean hasIncoming = $this$with.hasIncomingFor(repo, localBranchName);
        boolean hasOutgoing = $this$with.hasOutgoingFor(repo, localBranchName);
        return hasIncoming && hasOutgoing ? IncomingOutgoing.INCOMING_AND_OUTGOING : (hasIncoming ? IncomingOutgoing.INCOMING : (hasOutgoing ? IncomingOutgoing.OUTGOING : null));
    }

    private final Set<Integer> findMyCommits(VcsProjectLog log) {
        Collection collection = CollectionsKt.listOf((Object)"*");
        VcsLogData vcsLogData = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"log.dataManager!!");
        VcsLogUserFilter filterByMe = VcsLogFilterObject.fromUserNames((Collection)collection, (VcsLogData)vcsLogData);
        VcsLogData vcsLogData2 = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData2);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData2, (String)"log.dataManager!!");
        VcsLogIndex vcsLogIndex = vcsLogData2.getIndex();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"log.dataManager!!.index");
        IndexDataGetter indexDataGetter = vcsLogIndex.getDataGetter();
        Intrinsics.checkNotNull((Object)indexDataGetter);
        Set set = indexDataGetter.filter(CollectionsKt.listOf((Object)filterByMe));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"log.dataManager!!.index.\u2026ilter(listOf(filterByMe))");
        return set;
    }

    private final boolean isMyBranch(VcsProjectLog log, String branchName, GitRepository repo, Set<Integer> myCommits) {
        IntSet intSet = this.findExclusiveCommits(log, branchName, repo);
        if (intSet == null) {
            return false;
        }
        IntSet exclusiveCommits = intSet;
        if (exclusiveCommits.isEmpty()) {
            return false;
        }
        for (Integer commit : exclusiveCommits) {
            if (myCommits.contains(commit)) continue;
            return false;
        }
        return true;
    }

    private final IntSet findExclusiveCommits(VcsProjectLog log, String branchName, GitRepository repo) {
        VcsLogData vcsLogData = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"log.dataManager!!");
        DataPack dataPack = vcsLogData.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"log.dataManager!!.dataPack");
        DataPack dataPack2 = dataPack;
        VirtualFile virtualFile = repo.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
        VcsRef vcsRef = DataPackUtilKt.findBranch((DataPack)dataPack2, (String)branchName, (VirtualFile)virtualFile);
        if (vcsRef == null) {
            return null;
        }
        VcsRef ref = vcsRef;
        VcsRefType vcsRefType = ref.getType();
        Intrinsics.checkNotNullExpressionValue((Object)vcsRefType, (String)"ref.type");
        if (!vcsRefType.isBranch()) {
            return null;
        }
        RefsModel refsModel = dataPack2.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
        VcsLogData vcsLogData2 = log.getDataManager();
        Intrinsics.checkNotNull((Object)vcsLogData2);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData2, (String)"log.dataManager!!");
        VcsLogStorage vcsLogStorage = vcsLogData2.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"log.dataManager!!.storage");
        return DataPackUtilKt.exclusiveCommits((DataPack)dataPack2, (VcsRef)ref, (RefsModel)refsModel, (VcsLogStorage)vcsLogStorage);
    }

    private BranchesDashboardUtil() {
    }

    static {
        BranchesDashboardUtil branchesDashboardUtil;
        INSTANCE = branchesDashboardUtil = new BranchesDashboardUtil();
    }
}

