/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import git4idea.stash.ui.GitStashDiffPreview;
import git4idea.stash.ui.GitStashEditorDiffPreview;
import git4idea.stash.ui.GitStashTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001eB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u0007R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgit4idea/stash/ui/GitStashUi;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "isEditorDiffPreview", "", "disposable", "(Lcom/intellij/openapi/project/Project;ZLcom/intellij/openapi/Disposable;)V", "diffPreviewProcessor", "Lgit4idea/stash/ui/GitStashDiffPreview;", "editorTabPreview", "Lcom/intellij/openapi/vcs/changes/EditorTabPreview;", "toolbar", "Ljavax/swing/JComponent;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "treeDiffSplitter", "Lcom/intellij/ui/OnePixelSplitter;", "buildToolbar", "dispose", "", "getData", "", "dataId", "", "setDiffPreviewInEditor", "isInEditor", "force", "Companion", "intellij.vcs.git"})
public final class GitStashUi
extends JPanel
implements Disposable,
DataProvider {
    private final ChangesTree tree;
    private final OnePixelSplitter treeDiffSplitter;
    private final JComponent toolbar;
    private GitStashDiffPreview diffPreviewProcessor;
    private EditorTabPreview editorTabPreview;
    private final Project project;
    @NotNull
    public static final String GIT_STASH_UI_PLACE = "GitStashUiPlace";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final JComponent buildToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Git.Stash.Toolbar"));
        toolbarGroup.addSeparator();
        toolbarGroup.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        toolbarGroup.addSeparator();
        toolbarGroup.addAll((Collection)TreeActionsToolbarPanel.createTreeActions((ChangesTree)this.tree));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(GIT_STASH_UI_PLACE, (ActionGroup)toolbarGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026LACE, toolbarGroup, true)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent((JComponent)this.tree);
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"toolbar.component");
        return jComponent;
    }

    public final void setDiffPreviewInEditor(boolean isInEditor, boolean force) {
        if (!force && isInEditor == (this.editorTabPreview != null)) {
            return;
        }
        if (this.diffPreviewProcessor != null) {
            GitStashDiffPreview gitStashDiffPreview = this.diffPreviewProcessor;
            Intrinsics.checkNotNull((Object)((Object)gitStashDiffPreview));
            Disposer.dispose((Disposable)((Disposable)gitStashDiffPreview));
        }
        GitStashDiffPreview gitStashDiffPreview = this.diffPreviewProcessor = new GitStashDiffPreview(this.project, this.tree, isInEditor, this);
        Intrinsics.checkNotNull((Object)((Object)gitStashDiffPreview));
        gitStashDiffPreview.getToolbarWrapper().setVerticalSizeReferent(this.toolbar);
        if (isInEditor) {
            GitStashDiffPreview gitStashDiffPreview2 = this.diffPreviewProcessor;
            Intrinsics.checkNotNull((Object)((Object)gitStashDiffPreview2));
            this.editorTabPreview = new GitStashEditorDiffPreview(gitStashDiffPreview2, this.tree, this);
            this.treeDiffSplitter.setSecondComponent((JComponent)null);
        } else {
            this.editorTabPreview = null;
            GitStashDiffPreview gitStashDiffPreview3 = this.diffPreviewProcessor;
            Intrinsics.checkNotNull((Object)((Object)gitStashDiffPreview3));
            this.treeDiffSplitter.setSecondComponent(gitStashDiffPreview3.getComponent());
        }
    }

    public static /* synthetic */ void setDiffPreviewInEditor$default(GitStashUi gitStashUi, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        gitStashUi.setDiffPreviewInEditor(bl, bl2);
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW.is(dataId)) {
            return this.editorTabPreview;
        }
        return null;
    }

    public GitStashUi(@NotNull Project project, boolean isEditorDiffPreview, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(new BorderLayout());
        this.project = project;
        this.tree = new GitStashTree(this.project, this);
        PopupHandler.installPopupMenu((JComponent)((JComponent)this.tree), (String)"Git.Stash.ContextMenu", (String)GIT_STASH_UI_PLACE);
        this.toolbar = this.buildToolbar();
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)this.toolbar, "North");
        treePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.tree), (int)2), "Center");
        this.treeDiffSplitter = new OnePixelSplitter("git.stash.diff.splitter", 0.5f);
        this.treeDiffSplitter.setFirstComponent((JComponent)treePanel);
        this.setDiffPreviewInEditor(isEditorDiffPreview, true);
        this.add((Component)this.treeDiffSplitter, "Center");
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/stash/ui/GitStashUi$Companion;", "", "()V", "GIT_STASH_UI_PLACE", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

