/*
 * Decompiled with CFR 0.152.
 */
package git4idea.fetch;

import com.intellij.dvcs.MultiMessage;
import com.intellij.dvcs.MultiRootMessage;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRestrictingAuthenticationGate;
import git4idea.config.GitConfigUtil;
import git4idea.fetch.GitFetchHandler;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.fetch.GitFetchSupportImpl;
import git4idea.fetch.GitFetchSupportImplKt;
import git4idea.fetch.GitRemoteOperationQueueImpl;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0005=>?@AB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000b\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001eH\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0016\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0016J\u0016\u0010%\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0016J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020'0 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010*\u001a\u00020+2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$2\u0006\u0010,\u001a\u00020+H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u0019H\u0002J\b\u0010/\u001a\u000200H\u0016J\u0016\u00101\u001a\u0002002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0002J\u001a\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001032\u0006\u00105\u001a\u00020\u0013H\u0002J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00130 2\f\u00107\u001a\b\u0012\u0004\u0012\u00020'0 H\u0002J!\u00108\u001a\u0002H9\"\u0004\b\u0000\u001092\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H90;H\u0002\u00a2\u0006\u0002\u0010<R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl;", "Lgit4idea/fetch/GitFetchSupport;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fetchQueue", "Lgit4idea/fetch/GitRemoteOperationQueueImpl;", "fetchRequestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "git", "Lgit4idea/commands/GitImpl;", "getGit", "()Lgit4idea/commands/GitImpl;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "Lorg/jetbrains/annotations/NotNull;", "getProgressManager", "()Lcom/intellij/openapi/progress/ProgressManager;", "doFetch", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "refspec", "", "authenticationGate", "Lgit4idea/commands/GitAuthenticationGate;", "fetch", "Lgit4idea/fetch/GitFetchResult;", "Lorg/jetbrains/annotations/NonNls;", "arguments", "", "Lgit4idea/fetch/GitFetchSupportImpl$RemoteRefCoordinates;", "fetchAllRemotes", "repositories", "", "fetchDefaultRemote", "fetchInParallel", "Lgit4idea/fetch/GitFetchSupportImpl$FetchTask;", "remotes", "getDefaultRemoteToFetch", "getMaxThreads", "", "numberOfRemotes", "getPrunedRef", "line", "isFetchRunning", "", "isStoreCredentialsHelperUsed", "mergeRepoResults", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "firstResult", "secondResult", "waitForFetchTasks", "tasks", "withIndicator", "T", "operation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "FetchResultImpl", "FetchTask", "RemoteRefCoordinates", "RepoResult", "SingleRemoteResult", "intellij.vcs.git"})
public final class GitFetchSupportImpl
implements GitFetchSupport {
    private final GitRemoteOperationQueueImpl fetchQueue;
    private final AtomicInteger fetchRequestCounter;
    private final Project project;

    private final GitImpl getGit() {
        Git git = Git.getInstance();
        if (git == null) {
            throw new NullPointerException("null cannot be cast to non-null type git4idea.commands.GitImpl");
        }
        return (GitImpl)git;
    }

    private final ProgressManager getProgressManager() {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        return progressManager;
    }

    @Override
    @Nullable
    public GitRemote getDefaultRemoteToFetch(@NotNull GitRepository repository) {
        Comparable<GitReference> comparable;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Collection<GitRemote> collection = repository.getRemotes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.remotes");
        Collection<GitRemote> remotes = collection;
        if (remotes.isEmpty()) {
            comparable = null;
        } else if (remotes.size() == 1) {
            comparable = (GitRemote)CollectionsKt.first((Iterable)remotes);
        } else {
            comparable = repository.getCurrentBranch();
            if (comparable == null || (comparable = ((GitLocalBranch)comparable).findTrackedBranch(repository)) == null || (comparable = ((GitRemoteBranch)comparable).getRemote()) == null) {
                comparable = GitUtil.findRemoteByName(repository, "origin");
            }
        }
        return comparable;
    }

    @NotNull
    public GitFetchResult fetchDefaultRemote(@NotNull Collection<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        boolean bl = false;
        List remotesToFetch = new ArrayList();
        for (GitRepository gitRepository : repositories) {
            GitRemote remote = this.getDefaultRemoteToFetch(gitRepository);
            if (remote != null) {
                remotesToFetch.add(new RemoteRefCoordinates(gitRepository, remote, null, 4, null));
                continue;
            }
            GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
        }
        return this.fetch(remotesToFetch);
    }

    @NotNull
    public GitFetchResult fetchAllRemotes(@NotNull Collection<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        boolean bl = false;
        List remotesToFetch = new ArrayList();
        for (GitRepository gitRepository : repositories) {
            if (gitRepository.getRemotes().isEmpty()) {
                GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
                continue;
            }
            Iterator<GitRemote> iterator = gitRepository.getRemotes().iterator();
            while (iterator.hasNext()) {
                GitRemote remote;
                GitRemote gitRemote = remote = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)gitRemote, (String)"remote");
                remotesToFetch.add(new RemoteRefCoordinates(gitRepository, gitRemote, null, 4, null));
            }
        }
        return this.fetch(remotesToFetch);
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return this.fetch(CollectionsKt.listOf((Object)new RemoteRefCoordinates(repository, remote, null, 4, null)));
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String refspec) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)refspec, (String)"refspec");
        return this.fetch(CollectionsKt.listOf((Object)new RemoteRefCoordinates(repository, remote, refspec)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GitFetchResult fetch(List<RemoteRefCoordinates> arguments) {
        try {
            this.fetchRequestCounter.incrementAndGet();
            GitFetchResult gitFetchResult = (GitFetchResult)this.withIndicator((Function0)new Function0<FetchResultImpl>(this, arguments){
                final /* synthetic */ GitFetchSupportImpl this$0;
                final /* synthetic */ List $arguments;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final FetchResultImpl invoke() {
                    void $this$groupByTo$iv$iv;
                    StructuredIdeActivity activity = IdeActivityDefinition.started$default((IdeActivityDefinition)VcsStatisticsCollector.FETCH_ACTIVITY, (Project)GitFetchSupportImpl.access$getProject$p(this.this$0), null, (int)2, null);
                    List tasks = GitFetchSupportImpl.access$fetchInParallel(this.this$0, this.$arguments);
                    List results = GitFetchSupportImpl.access$waitForFetchTasks(this.this$0, tasks);
                    boolean bl = false;
                    Map mergedResults = new LinkedHashMap<K, V>();
                    boolean bl2 = false;
                    List succeedResults = new ArrayList<E>();
                    for (SingleRemoteResult result2 : results) {
                        RepoResult res = (RepoResult)mergedResults.get(result2.getRepository());
                        mergedResults.put(result2.getRepository(), GitFetchSupportImpl.access$mergeRepoResults(this.this$0, res, result2));
                        if (!result2.success()) continue;
                        succeedResults.add(result2);
                    }
                    Iterable $this$groupBy$iv = succeedResults;
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        void it;
                        Object object;
                        SingleRemoteResult it2 = (SingleRemoteResult)element$iv$iv;
                        boolean $i$a$-groupBy-GitFetchSupportImpl$fetch$1$successFetchesMap$32 = false;
                        GitRepository key$iv$iv = it2.getRepository();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl3 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        SingleRemoteResult $i$a$-groupBy-GitFetchSupportImpl$fetch$1$successFetchesMap$32 = (SingleRemoteResult)element$iv$iv;
                        List list2 = list$iv$iv;
                        boolean bl4 = false;
                        GitRemote gitRemote = it.getRemote();
                        list2.add(gitRemote);
                    }
                    Map successFetchesMap = destination$iv$iv;
                    Map map2 = successFetchesMap;
                    boolean bl5 = false;
                    if (!map2.isEmpty()) {
                        Project project = GitFetchSupportImpl.access$getProject$p(this.this$0);
                        ProgressIndicator progressIndicator = GitFetchSupportImpl.access$getProgressManager$p(this.this$0).getProgressIndicator();
                        if (progressIndicator == null) {
                            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                        }
                        GitFetchHandler.Companion.afterSuccessfulFetch(project, successFetchesMap, progressIndicator);
                    }
                    StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                    Project project = GitFetchSupportImpl.access$getProject$p(this.this$0);
                    VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)GitFetchSupportImpl.access$getProject$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"VcsNotifier.getInstance(project)");
                    return new FetchResultImpl(project, vcsNotifier, mergedResults);
                }
                {
                    this.this$0 = gitFetchSupportImpl;
                    this.$arguments = list2;
                    super(0);
                }
            });
            return gitFetchResult;
        }
        finally {
            this.fetchRequestCounter.decrementAndGet();
        }
    }

    private final RepoResult mergeRepoResults(RepoResult firstResult, SingleRemoteResult secondResult) {
        if (firstResult == null) {
            return new RepoResult(MapsKt.mapOf((Pair)TuplesKt.to((Object)secondResult.getRemote(), (Object)secondResult)));
        }
        return new RepoResult(MapsKt.plus(firstResult.getResults(), (Pair)TuplesKt.to((Object)secondResult.getRemote(), (Object)secondResult)));
    }

    @Override
    public boolean isFetchRunning() {
        return this.fetchRequestCounter.get() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FetchTask> fetchInParallel(List<RemoteRefCoordinates> remotes) {
        GitRepository it;
        void var14_16;
        void destination$iv;
        void $this$mapTo$iv;
        boolean bl = false;
        List tasks = new ArrayList();
        Iterable iterable = remotes;
        Collection collection = new HashSet();
        GitFetchSupportImpl gitFetchSupportImpl = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            RemoteRefCoordinates remoteRefCoordinates = (RemoteRefCoordinates)item$iv;
            var14_16 = destination$iv;
            boolean bl2 = false;
            GitRepository gitRepository = ((RemoteRefCoordinates)((Object)it)).getRepository();
            var14_16.add(gitRepository);
        }
        var14_16 = destination$iv;
        int maxThreads = gitFetchSupportImpl.getMaxThreads((Collection<? extends GitRepository>)var14_16, remotes.size());
        GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remotes + " using " + maxThreads + " threads");
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GitFetch pool", (int)maxThreads);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026tFetch pool\", maxThreads)");
        ExecutorService executor = executorService;
        ProgressIndicator progressIndicator = this.getProgressManager().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator commonIndicator = progressIndicator;
        GitRestrictingAuthenticationGate authenticationGate = new GitRestrictingAuthenticationGate();
        for (RemoteRefCoordinates remoteRefCoordinates : remotes) {
            Future<SingleRemoteResult> future2;
            void repository;
            void remote;
            it = remoteRefCoordinates.component1();
            GitRemote bl2 = remoteRefCoordinates.component2();
            String refspec = remoteRefCoordinates.component3();
            GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remote + " in " + repository);
            Intrinsics.checkNotNullExpressionValue(executor.submit(new Callable(this, commonIndicator, (GitRepository)repository, (GitRemote)remote, refspec, authenticationGate){
                final /* synthetic */ GitFetchSupportImpl this$0;
                final /* synthetic */ ProgressIndicator $commonIndicator;
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ GitRemote $remote;
                final /* synthetic */ String $refspec;
                final /* synthetic */ GitRestrictingAuthenticationGate $authenticationGate;

                /*
                 * WARNING - void declaration
                 */
                public final SingleRemoteResult call() {
                    void result2;
                    this.$commonIndicator.checkCanceled();
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    objectRef.element = null;
                    ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(this, (Ref.ObjectRef)result2){
                        final /* synthetic */ fetchInParallel.future.1 this$0;
                        final /* synthetic */ Ref.ObjectRef $result;

                        public final void run() {
                            this.this$0.$commonIndicator.checkCanceled();
                            this.$result.element = (SingleRemoteResult)GitFetchSupportImpl.access$getFetchQueue$p(this.this$0.this$0).executeForRemote(this.this$0.$repository, this.this$0.$remote, (Function0)new Function0<SingleRemoteResult>(this){
                                final /* synthetic */ fetchInParallel.future.1 this$0;

                                @NotNull
                                public final SingleRemoteResult invoke() {
                                    return GitFetchSupportImpl.access$doFetch(this.this$0.this$0.this$0, this.this$0.this$0.$repository, this.this$0.this$0.$remote, this.this$0.this$0.$refspec, this.this$0.this$0.$authenticationGate);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = objectRef;
                        }
                    }, this.$commonIndicator);
                    Object object = result2.element;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"result");
                    }
                    return (SingleRemoteResult)object;
                }
                {
                    this.this$0 = gitFetchSupportImpl;
                    this.$commonIndicator = progressIndicator;
                    this.$repository = gitRepository;
                    this.$remote = gitRemote;
                    this.$refspec = string;
                    this.$authenticationGate = gitRestrictingAuthenticationGate;
                }
            }), (String)"executor.submit<SingleRe\u2026r)\n        result\n      }");
            tasks.add(new FetchTask((GitRepository)repository, (GitRemote)remote, future2));
        }
        return tasks;
    }

    private final int getMaxThreads(Collection<? extends GitRepository> repositories, int numberOfRemotes) {
        int maxThreads;
        int config = Registry.intValue((String)"git.parallel.fetch.threads");
        int n = config > 0 ? config : (config == -1 ? Runtime.getRuntime().availableProcessors() : (config == -2 ? numberOfRemotes : (maxThreads = config == -3 ? Math.min(numberOfRemotes, Runtime.getRuntime().availableProcessors() * 2) : 1)));
        if (this.isStoreCredentialsHelperUsed(repositories)) {
            return 1;
        }
        return Math.min(maxThreads, 10);
    }

    private final boolean isStoreCredentialsHelperUsed(Collection<? extends GitRepository> repositories) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = repositories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)GitConfigUtil.getValue(this.project, it.getRoot(), "credential.helper"), (String)"store", (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<SingleRemoteResult> waitForFetchTasks(List<FetchTask> tasks) {
        boolean bl = false;
        List results = new ArrayList();
        for (FetchTask task2 : tasks) {
            try {
                SingleRemoteResult singleRemoteResult = task2.getFuture().get();
                Intrinsics.checkNotNullExpressionValue((Object)singleRemoteResult, (String)"task.future.get()");
                results.add(singleRemoteResult);
            }
            catch (CancellationException e) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    Throwable throwable = e.getCause();
                    if (throwable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.progress.ProcessCanceledException");
                    }
                    throw (Throwable)((ProcessCanceledException)throwable);
                }
                GitRepository gitRepository = task2.getRepository();
                GitRemote gitRemote = task2.getRemote();
                Object object = e.getCause();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    String string = GitBundle.message("error.dialog.title", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"error.dialog.title\")");
                }
                results.add(new SingleRemoteResult(gitRepository, gitRemote, (String)object, CollectionsKt.emptyList()));
                GitFetchSupportImplKt.access$getLOG$p().error((Throwable)e);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withIndicator(Function0<? extends T> operation) {
        ProgressIndicator indicator;
        ProgressIndicator progressIndicator = indicator = this.getProgressManager().getProgressIndicator();
        String prevText = progressIndicator != null ? progressIndicator.getText() : null;
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(GitBundle.message("git.fetch.progress", new Object[0]));
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            block4: {
                ProgressIndicator progressIndicator3 = indicator;
                if (progressIndicator3 == null) break block4;
                progressIndicator3.setText(prevText);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SingleRemoteResult doFetch(GitRepository repository, GitRemote remote, String refspec, GitAuthenticationGate authenticationGate) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray;
        String recurseSubmodules = "--recurse-submodules=no";
        if (refspec == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = recurseSubmodules;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = refspec;
            stringArray = stringArray3;
            stringArray3[1] = recurseSubmodules;
        }
        String[] params = stringArray;
        GitCommandResult gitCommandResult = this.getGit().fetch(repository, remote, (List<? extends GitLineHandlerListener>)CollectionsKt.emptyList(), authenticationGate, Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"git.fetch(repository, re\u2026henticationGate, *params)");
        GitCommandResult result2 = gitCommandResult;
        List<String> list2 = result2.getOutput();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"result.output");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
            if (this.getPrunedRef(string2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pruned = (List)destination$iv$iv;
        if (result2.success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)repository.getProject(), GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
            repository.update();
        }
        String error = result2.success() ? null : result2.getErrorOutputAsJoinedString();
        return new SingleRemoteResult(repository, remote, error, pruned);
    }

    static /* synthetic */ SingleRemoteResult doFetch$default(GitFetchSupportImpl gitFetchSupportImpl, GitRepository gitRepository, GitRemote gitRemote, String string, GitAuthenticationGate gitAuthenticationGate, int n, Object object) {
        if ((n & 8) != 0) {
            gitAuthenticationGate = null;
        }
        return gitFetchSupportImpl.doFetch(gitRepository, gitRemote, string, gitAuthenticationGate);
    }

    private final String getPrunedRef(String line) {
        Matcher matcher = GitFetchSupportImplKt.access$getPRUNE_PATTERN$p().matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    public GitFetchSupportImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fetchQueue = new GitRemoteOperationQueueImpl();
        this.fetchRequestCounter = new AtomicInteger();
    }

    public static final /* synthetic */ Project access$getProject$p(GitFetchSupportImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ List access$fetchInParallel(GitFetchSupportImpl $this, List remotes) {
        return $this.fetchInParallel(remotes);
    }

    public static final /* synthetic */ List access$waitForFetchTasks(GitFetchSupportImpl $this, List tasks) {
        return $this.waitForFetchTasks(tasks);
    }

    public static final /* synthetic */ RepoResult access$mergeRepoResults(GitFetchSupportImpl $this, RepoResult firstResult, SingleRemoteResult secondResult) {
        return $this.mergeRepoResults(firstResult, secondResult);
    }

    public static final /* synthetic */ ProgressManager access$getProgressManager$p(GitFetchSupportImpl $this) {
        return $this.getProgressManager();
    }

    public static final /* synthetic */ GitRemoteOperationQueueImpl access$getFetchQueue$p(GitFetchSupportImpl $this) {
        return $this.fetchQueue;
    }

    public static final /* synthetic */ SingleRemoteResult access$doFetch(GitFetchSupportImpl $this, GitRepository repository, GitRemote remote, String refspec, GitAuthenticationGate authenticationGate) {
        return $this.doFetch(repository, remote, refspec, authenticationGate);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$RemoteRefCoordinates;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "refspec", "", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/lang/String;)V", "getRefspec", "()Ljava/lang/String;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class RemoteRefCoordinates {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @Nullable
        private final String refspec;

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @Nullable
        public final String getRefspec() {
            return this.refspec;
        }

        public RemoteRefCoordinates(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String refspec) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            this.repository = repository;
            this.remote = remote;
            this.refspec = refspec;
        }

        public /* synthetic */ RemoteRefCoordinates(GitRepository gitRepository, GitRemote gitRemote, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = null;
            }
            this(gitRepository, gitRemote, string);
        }

        @NotNull
        public final GitRepository component1() {
            return this.repository;
        }

        @NotNull
        public final GitRemote component2() {
            return this.remote;
        }

        @Nullable
        public final String component3() {
            return this.refspec;
        }

        @NotNull
        public final RemoteRefCoordinates copy(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String refspec) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            return new RemoteRefCoordinates(repository, remote, refspec);
        }

        public static /* synthetic */ RemoteRefCoordinates copy$default(RemoteRefCoordinates remoteRefCoordinates, GitRepository gitRepository, GitRemote gitRemote, String string, int n, Object object) {
            if ((n & 1) != 0) {
                gitRepository = remoteRefCoordinates.repository;
            }
            if ((n & 2) != 0) {
                gitRemote = remoteRefCoordinates.remote;
            }
            if ((n & 4) != 0) {
                string = remoteRefCoordinates.refspec;
            }
            return remoteRefCoordinates.copy(gitRepository, gitRemote, string);
        }

        @NotNull
        public String toString() {
            return "RemoteRefCoordinates(repository=" + this.repository + ", remote=" + this.remote + ", refspec=" + this.refspec + ")";
        }

        public int hashCode() {
            GitRepository gitRepository = this.repository;
            GitRemote gitRemote = this.remote;
            String string = this.refspec;
            return ((gitRepository != null ? gitRepository.hashCode() : 0) * 31 + (gitRemote != null ? ((Object)gitRemote).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RemoteRefCoordinates)) break block3;
                    RemoteRefCoordinates remoteRefCoordinates = (RemoteRefCoordinates)object;
                    if (!Intrinsics.areEqual((Object)this.repository, (Object)remoteRefCoordinates.repository) || !Intrinsics.areEqual((Object)this.remote, (Object)remoteRefCoordinates.remote) || !Intrinsics.areEqual((Object)this.refspec, (Object)remoteRefCoordinates.refspec)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchTask;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "future", "Ljava/util/concurrent/Future;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/util/concurrent/Future;)V", "getFuture", "()Ljava/util/concurrent/Future;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    private static final class FetchTask {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @NotNull
        private final Future<SingleRemoteResult> future;

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @NotNull
        public final Future<SingleRemoteResult> getFuture() {
            return this.future;
        }

        public FetchTask(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull Future<SingleRemoteResult> future2) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            Intrinsics.checkNotNullParameter(future2, (String)"future");
            this.repository = repository;
            this.remote = remote;
            this.future = future2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "", "results", "", "Lgit4idea/repo/GitRemote;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "(Ljava/util/Map;)V", "getResults", "()Ljava/util/Map;", "error", "", "multiRemoteMessage", "Lcom/intellij/dvcs/MultiMessage;", "remoteInPrefix", "", "prunedRefs", "totallySuccessful", "intellij.vcs.git"})
    private static final class RepoResult {
        @NotNull
        private final Map<GitRemote, SingleRemoteResult> results;

        public final boolean totallySuccessful() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.results.values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        SingleRemoteResult it = (SingleRemoteResult)element$iv;
                        boolean bl2 = false;
                        if (it.success()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String error() {
            MultiMessage<GitRemote> errorMessage = this.multiRemoteMessage(true);
            Object object = this.results;
            boolean bl = false;
            Iterator<Map.Entry<GitRemote, SingleRemoteResult>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void remote;
                Map.Entry<GitRemote, SingleRemoteResult> entry;
                Map.Entry<GitRemote, SingleRemoteResult> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                SingleRemoteResult result2 = entry2.getValue();
                if (result2.getError() == null) continue;
                errorMessage.append((Object)remote, result2.getError());
            }
            return errorMessage.asString();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String prunedRefs() {
            MultiMessage<GitRemote> prunedRefs = this.multiRemoteMessage(false);
            Object object = this.results;
            boolean bl = false;
            for (Map.Entry<GitRemote, SingleRemoteResult> entry : object.entrySet()) {
                void remote;
                Object object2 = entry;
                boolean bl2 = false;
                object = object2.getKey();
                object2 = entry;
                bl2 = false;
                SingleRemoteResult result2 = object2.getValue();
                object2 = result2.getPrunedRefs();
                bl2 = false;
                if (!(!object2.isEmpty())) continue;
                prunedRefs.append((Object)remote, CollectionsKt.joinToString$default((Iterable)result2.getPrunedRefs(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            return prunedRefs.asString();
        }

        private final MultiMessage<GitRemote> multiRemoteMessage(boolean remoteInPrefix) {
            return new MultiMessage((Collection)this.results.keySet(), (Function1)multiRemoteMessage.1.INSTANCE, (Function1)multiRemoteMessage.2.INSTANCE, remoteInPrefix, false, 16, null);
        }

        @NotNull
        public final Map<GitRemote, SingleRemoteResult> getResults() {
            return this.results;
        }

        public RepoResult(@NotNull Map<GitRemote, SingleRemoteResult> results) {
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.results = results;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0018\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "error", "", "Lorg/jetbrains/annotations/Nls;", "prunedRefs", "", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/lang/String;Ljava/util/List;)V", "getError", "()Ljava/lang/String;", "getPrunedRefs", "()Ljava/util/List;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "success", "", "intellij.vcs.git"})
    private static final class SingleRemoteResult {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @Nullable
        private final String error;
        @NotNull
        private final List<String> prunedRefs;

        public final boolean success() {
            return this.error == null;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final List<String> getPrunedRefs() {
            return this.prunedRefs;
        }

        public SingleRemoteResult(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String error, @NotNull List<String> prunedRefs) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            Intrinsics.checkNotNullParameter(prunedRefs, (String)"prunedRefs");
            this.repository = repository;
            this.remote = remote;
            this.error = error;
            this.prunedRefs = prunedRefs;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b2\r\u0010\u001c\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\u001bH\u0002J\u0019\u0010\u001d\u001a\u00020\u00142\u000f\b\u0002\u0010\u001c\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0015\u0010\u001f\u001a\u00020\f2\u000b\u0010 \u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0016J\b\u0010!\u001a\u00020\u0014H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchResultImpl;", "Lgit4idea/fetch/GitFetchResult;", "project", "Lcom/intellij/openapi/project/Project;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "results", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/VcsNotifier;Ljava/util/Map;)V", "isFailed", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResults", "()Ljava/util/Map;", "getVcsNotifier", "()Lcom/intellij/openapi/vcs/VcsNotifier;", "appendDetails", "", "sb", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "details", "Lcom/intellij/dvcs/MultiRootMessage;", "buildMessage", "", "Lorg/jetbrains/annotations/Nls;", "failureTitle", "doShowNotification", "showNotification", "showNotificationIfFailed", "title", "throwExceptionIfFailed", "intellij.vcs.git"})
    private static final class FetchResultImpl
    implements GitFetchResult {
        private final boolean isFailed;
        @NotNull
        private final Project project;
        @NotNull
        private final VcsNotifier vcsNotifier;
        @NotNull
        private final Map<GitRepository, RepoResult> results;

        @Override
        public void showNotification() {
            FetchResultImpl.doShowNotification$default(this, null, 1, null);
        }

        @Override
        public boolean showNotificationIfFailed() {
            if (this.isFailed) {
                this.doShowNotification(null);
            }
            return !this.isFailed;
        }

        @Override
        public boolean showNotificationIfFailed(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            if (this.isFailed) {
                this.doShowNotification(title);
            }
            return !this.isFailed;
        }

        private final void doShowNotification(String failureTitle) {
            NotificationType type = !this.isFailed ? NotificationType.INFORMATION : NotificationType.ERROR;
            String message = this.buildMessage(failureTitle);
            Notification notification2 = VcsNotifier.STANDARD_NOTIFICATION.createNotification(message, type);
            this.vcsNotifier.notify(notification2);
        }

        static /* synthetic */ void doShowNotification$default(FetchResultImpl fetchResultImpl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            fetchResultImpl.doShowNotification(string);
        }

        @Override
        public void throwExceptionIfFailed() {
            if (this.isFailed) {
                throw (Throwable)new VcsException(this.buildMessage(null));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final String buildMessage(String failureTitle) {
            Object repo;
            Object item$iv$iv22;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.results.keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv22 : $this$mapTo$iv$iv) {
                void it;
                GitRepository gitRepository = (GitRepository)item$iv$iv22;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile = it.getRoot();
                collection.add(virtualFile);
            }
            List roots = (List)destination$iv$iv;
            MultiRootMessage errorMessage = new MultiRootMessage(this.project, (Collection)roots, true, false, 8, null);
            MultiRootMessage prunedRefs = new MultiRootMessage(this.project, (Collection)roots, false, false, 12, null);
            Map.Entry<Object, Object> $this$filterValues$iv = this.results;
            boolean $i$f$filterValues = false;
            Object result$iv = new LinkedHashMap();
            item$iv$iv22 = $this$filterValues$iv;
            boolean bl = false;
            for (Map.Entry entry$iv : item$iv$iv22.entrySet()) {
                RepoResult it = (RepoResult)entry$iv.getValue();
                boolean bl2 = false;
                if (!(!it.totallySuccessful())) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map failed = (Map)result$iv;
            result$iv = failed;
            boolean item$iv$iv22 = false;
            Iterator<Map.Entry<Object, Object>> iterator = result$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = $this$filterValues$iv = iterator.next();
                boolean bl3 = false;
                result$iv = (GitRepository)entry.getKey();
                entry = $this$filterValues$iv;
                bl3 = false;
                RepoResult result2 = (RepoResult)entry.getValue();
                if (result2.error() == null) continue;
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                String string = result2.error();
                Intrinsics.checkNotNull((Object)string);
                errorMessage.append((Object)virtualFile, string);
            }
            repo = this.results;
            boolean result2 = false;
            iterator = repo.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = $this$filterValues$iv = iterator.next();
                boolean bl4 = false;
                repo = (GitRepository)entry.getKey();
                entry = $this$filterValues$iv;
                bl4 = false;
                RepoResult result3 = (RepoResult)entry.getValue();
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                prunedRefs.append((Object)virtualFile, result3.prunedRefs());
            }
            HtmlBuilder sb = new HtmlBuilder();
            if (!this.isFailed) {
                sb.append((HtmlChunk)HtmlChunk.text((String)GitBundle.message("notification.title.fetch.success", new Object[0])).bold());
            } else {
                String string = failureTitle;
                if (string == null) {
                    String string2 = GitBundle.message("notification.title.fetch.failure", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"notif\u2026ion.title.fetch.failure\")");
                }
                sb.append((HtmlChunk)HtmlChunk.text((String)string).bold());
                if (failed.size() != roots.size()) {
                    sb.append(GitUtil.mention(failed.keySet()));
                }
            }
            this.appendDetails(sb, errorMessage);
            this.appendDetails(sb, prunedRefs);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        private final void appendDetails(HtmlBuilder sb, MultiRootMessage details) {
            String text = details.asString();
            CharSequence charSequence = text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                sb.br().append(text);
            }
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VcsNotifier getVcsNotifier() {
            return this.vcsNotifier;
        }

        @NotNull
        public final Map<GitRepository, RepoResult> getResults() {
            return this.results;
        }

        /*
         * WARNING - void declaration
         */
        public FetchResultImpl(@NotNull Project project, @NotNull VcsNotifier vcsNotifier, @NotNull Map<GitRepository, RepoResult> results) {
            boolean bl;
            boolean bl2;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)vcsNotifier, (String)"vcsNotifier");
                Intrinsics.checkNotNullParameter(results, (String)"results");
                this.project = project;
                this.vcsNotifier = vcsNotifier;
                this.results = results;
                Iterable iterable = this.results.values();
                FetchResultImpl fetchResultImpl = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RepoResult it = (RepoResult)element$iv;
                        boolean bl3 = false;
                        if (!(!it.totallySuccessful())) continue;
                        bl2 = true;
                        break block3;
                    }
                    bl2 = false;
                }
            }
            fetchResultImpl.isFailed = bl = bl2;
        }
    }
}

