/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.actions.VcsQuickActionsToolbarPopup;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBInsets;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class GitQuickActionsToolbarPopup
extends VcsQuickActionsToolbarPopup {
    private static final Key<Boolean> KEY_ICON_WITH_TEXT = Key.create((String)"KEY_ICON_WITH_TEXT");

    GitQuickActionsToolbarPopup() {
        this.getTemplatePresentation().setText(GitBundle.message("action.Vcs.ShowMoreActions.text", new Object[0]));
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            GitQuickActionsToolbarPopup.$$$reportNull$$$0(0);
        }
        if (place == null) {
            GitQuickActionsToolbarPopup.$$$reportNull$$$0(1);
        }
        return new MyActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitQuickActionsToolbarPopup.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null || project.isDisposed() || !project.isOpen()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        GitRepository repo = GitBranchUtil.getCurrentRepository(project);
        if (repo == null) {
            presentation.putClientProperty(KEY_ICON_WITH_TEXT, (Object)true);
            presentation.setIcon(AllIcons.Vcs.BranchNode);
        } else {
            Icon icon = AllIcons.Actions.More;
            if (icon.getIconWidth() < ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width) {
                icon = IconUtil.toSize((Icon)icon, (int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width, (int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height);
            }
            presentation.putClientProperty(KEY_ICON_WITH_TEXT, (Object)false);
            presentation.setIcon(icon);
        }
        super.update(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "git4idea/actions/GitQuickActionsToolbarPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyActionButtonWithText
    extends ActionButtonWithText {
        private MyActionButtonWithText(AnAction action, Presentation presentation, String place, Dimension minimumSize) {
            super(action, presentation, place, minimumSize);
        }

        @NotNull
        @NlsActions.ActionText
        public String getText() {
            boolean iconWithText = (Boolean)this.myPresentation.getClientProperty(KEY_ICON_WITH_TEXT);
            if (iconWithText) {
                String string = super.getText() + " ";
                if (string == null) {
                    MyActionButtonWithText.$$$reportNull$$$0(0);
                }
                return string;
            }
            return "";
        }

        public Color getInactiveTextColor() {
            return this.getForeground();
        }

        public Insets getInsets() {
            return new JBInsets(0, 0, 0, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitQuickActionsToolbarPopup$MyActionButtonWithText", "getText"));
        }
    }
}

