/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.vcs.log.Hash;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J*\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0017"}, d2={"Lgit4idea/GitPushUtil;", "", "()V", "findOrPushRemoteBranch", "Ljava/util/concurrent/CompletableFuture;", "Lgit4idea/GitRemoteBranch;", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "localBranch", "Lgit4idea/GitLocalBranch;", "dialogMessages", "Lgit4idea/GitPushUtil$BranchNameInputDialogMessages;", "findPushTarget", "Lgit4idea/push/GitPushTarget;", "branch", "inputPushTarget", "BranchNameInputDialogMessages", "intellij.vcs.git"})
public final class GitPushUtil {
    @NotNull
    public static final GitPushUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final CompletableFuture<GitRemoteBranch> findOrPushRemoteBranch(@NotNull Project project, @NotNull ProgressIndicator progressIndicator, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GitLocalBranch localBranch, @NotNull BranchNameInputDialogMessages dialogMessages) {
        Hash remoteHash;
        Hash localHash;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)localBranch, (String)"localBranch");
        Intrinsics.checkNotNullParameter((Object)dialogMessages, (String)"dialogMessages");
        PushSupport pushSupport = DvcsUtil.getPushSupport((AbstractVcs)GitVcs.getInstance(project));
        if (!(pushSupport instanceof GitPushSupport)) {
            pushSupport = null;
        }
        GitPushSupport gitPushSupport = (GitPushSupport)pushSupport;
        if (gitPushSupport == null) {
            CompletableFuture<GitRemoteBranch> completableFuture = CompletableFuture.failedFuture(new ProcessCanceledException());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failed\u2026ocessCanceledException())");
            return completableFuture;
        }
        GitPushSupport gitPushSupport2 = gitPushSupport;
        GitPushTarget existingPushTarget = GitPushUtil.findPushTarget(repository, remote, localBranch);
        if (existingPushTarget != null && Intrinsics.areEqual((Object)(localHash = repository.getBranches().getHash(localBranch)), (Object)(remoteHash = repository.getBranches().getHash(existingPushTarget.getBranch())))) {
            CompletableFuture<GitRemoteBranch> completableFuture = CompletableFuture.completedFuture(existingPushTarget.getBranch());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.comple\u2026xistingPushTarget.branch)");
            return completableFuture;
        }
        GitPushTarget gitPushTarget = existingPushTarget;
        if (gitPushTarget == null) {
            gitPushTarget = INSTANCE.inputPushTarget(repository, remote, localBranch, dialogMessages);
        }
        if (gitPushTarget == null) {
            CompletableFuture<GitRemoteBranch> completableFuture = CompletableFuture.failedFuture(new ProcessCanceledException());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failed\u2026ocessCanceledException())");
            return completableFuture;
        }
        GitPushTarget pushTarget = gitPushTarget;
        CompletableFuture<GitRemoteBranch> future2 = new CompletableFuture<GitRemoteBranch>();
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(localBranch, pushTarget, repository, gitPushSupport2, future2, repository.getProject(), DvcsBundle.message((String)"push.process.pushing", (Object[])new Object[0]), true){
            final /* synthetic */ GitLocalBranch $localBranch;
            final /* synthetic */ GitPushTarget $pushTarget;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitPushSupport $gitPushSupport;
            final /* synthetic */ CompletableFuture $future;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(DvcsBundle.message((String)"push.process.pushing", (Object[])new Object[0]));
                PushSpec pushSpec = new PushSpec((PushSource)GitPushSource.create(this.$localBranch), (PushTarget)this.$pushTarget);
                GitPushResult gitPushResult = new GitPushOperation(this.$repository.getProject(), this.$gitPushSupport, (Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>>)MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$repository, (Object)pushSpec)), null, false, false).execute();
                Intrinsics.checkNotNullExpressionValue((Object)gitPushResult, (String)"GitPushOperation(reposit\u2026               .execute()");
                GitPushRepoResult gitPushRepoResult = gitPushResult.getResults().get(this.$repository);
                if (gitPushRepoResult == null) {
                    String string = "Missing push result";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                GitPushRepoResult pushResult = gitPushRepoResult;
                boolean bl = pushResult.getError() == null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    Object[] objectArray = new Object[1];
                    String string = pushResult.getError();
                    boolean bl5 = false;
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "";
                    }
                    objectArray[0] = string2;
                    String string3 = GitBundle.message("push.failed.error.message", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GitBundle.message(\"push.\u2026shResult.error.orEmpty())");
                    String string4 = string3;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
            }

            public void onSuccess() {
                this.$future.complete(this.$pushTarget.getBranch());
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$future.completeExceptionally(error);
            }

            public void onCancel() {
                this.$future.completeExceptionally(new ProcessCanceledException());
            }
            {
                this.$localBranch = $captured_local_variable$0;
                this.$pushTarget = $captured_local_variable$1;
                this.$repository = $captured_local_variable$2;
                this.$gitPushSupport = $captured_local_variable$3;
                this.$future = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        }, progressIndicator);
        return future2;
    }

    private final GitPushTarget inputPushTarget(GitRepository repository, GitRemote remote, GitLocalBranch localBranch, BranchNameInputDialogMessages dialogMessages) {
        String string = MessagesService.Companion.getInstance().showInputDialog(repository.getProject(), null, dialogMessages.getInputMessage(), dialogMessages.getTitle(), null, localBranch.getName(), null, null, dialogMessages.getInputComment());
        if (string == null) {
            return null;
        }
        String branchName = string;
        return new GitPushTarget(new GitStandardRemoteBranch(remote, GitRefNameValidator.getInstance().cleanUpBranchName(branchName)), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final GitPushTarget findPushTarget(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GitLocalBranch branch) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        GitPushTarget gitPushTarget = GitPushTarget.getFromPushSpec(repository, remote, branch);
        if (gitPushTarget != null) return gitPushTarget;
        GitBranchTrackInfo gitBranchTrackInfo = GitBranchUtil.getTrackInfoForBranch(repository, branch);
        GitBranchTrackInfo gitBranchTrackInfo2 = gitBranchTrackInfo;
        if (gitBranchTrackInfo == null) return null;
        GitBranchTrackInfo gitBranchTrackInfo3 = gitBranchTrackInfo2;
        boolean bl = false;
        boolean bl2 = false;
        GitBranchTrackInfo it = gitBranchTrackInfo3;
        boolean bl3 = false;
        GitBranchTrackInfo gitBranchTrackInfo4 = it;
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchTrackInfo4, (String)"it");
        if (!Intrinsics.areEqual((Object)gitBranchTrackInfo4.getRemote(), (Object)remote)) return null;
        GitBranchTrackInfo gitBranchTrackInfo5 = gitBranchTrackInfo3;
        gitBranchTrackInfo2 = gitBranchTrackInfo5;
        if (gitBranchTrackInfo5 == null) return null;
        gitBranchTrackInfo3 = gitBranchTrackInfo2;
        bl = false;
        bl2 = false;
        it = gitBranchTrackInfo3;
        boolean bl4 = false;
        GitBranchTrackInfo gitBranchTrackInfo6 = it;
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchTrackInfo6, (String)"it");
        GitRemoteBranch gitRemoteBranch = gitBranchTrackInfo6.getRemoteBranch();
        Intrinsics.checkNotNullExpressionValue((Object)gitRemoteBranch, (String)"it.remoteBranch");
        if (!Intrinsics.areEqual((Object)gitRemoteBranch.getNameForRemoteOperations(), (Object)branch.getName())) return null;
        GitBranchTrackInfo gitBranchTrackInfo7 = gitBranchTrackInfo3;
        gitBranchTrackInfo2 = gitBranchTrackInfo7;
        if (gitBranchTrackInfo7 == null) return null;
        gitBranchTrackInfo3 = gitBranchTrackInfo2;
        bl = false;
        bl2 = false;
        it = gitBranchTrackInfo3;
        boolean bl5 = false;
        GitBranchTrackInfo gitBranchTrackInfo8 = it;
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchTrackInfo8, (String)"it");
        gitPushTarget = new GitPushTarget(gitBranchTrackInfo8.getRemoteBranch(), false);
        return gitPushTarget;
    }

    private GitPushUtil() {
    }

    static {
        GitPushUtil gitPushUtil;
        INSTANCE = gitPushUtil = new GitPushUtil();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lgit4idea/GitPushUtil$BranchNameInputDialogMessages;", "", "title", "", "inputMessage", "inputComment", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getInputComment", "()Ljava/lang/String;", "getInputMessage", "getTitle", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    public static final class BranchNameInputDialogMessages {
        @NotNull
        private final String title;
        @NotNull
        private final String inputMessage;
        @NotNull
        private final String inputComment;

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getInputMessage() {
            return this.inputMessage;
        }

        @NotNull
        public final String getInputComment() {
            return this.inputComment;
        }

        public BranchNameInputDialogMessages(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String inputMessage, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String inputComment) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)inputMessage, (String)"inputMessage");
            Intrinsics.checkNotNullParameter((Object)inputComment, (String)"inputComment");
            this.title = title;
            this.inputMessage = inputMessage;
            this.inputComment = inputComment;
        }

        @NotNull
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final String component2() {
            return this.inputMessage;
        }

        @NotNull
        public final String component3() {
            return this.inputComment;
        }

        @NotNull
        public final BranchNameInputDialogMessages copy(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String inputMessage, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String inputComment) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)inputMessage, (String)"inputMessage");
            Intrinsics.checkNotNullParameter((Object)inputComment, (String)"inputComment");
            return new BranchNameInputDialogMessages(title, inputMessage, inputComment);
        }

        public static /* synthetic */ BranchNameInputDialogMessages copy$default(BranchNameInputDialogMessages branchNameInputDialogMessages, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = branchNameInputDialogMessages.title;
            }
            if ((n & 2) != 0) {
                string2 = branchNameInputDialogMessages.inputMessage;
            }
            if ((n & 4) != 0) {
                string3 = branchNameInputDialogMessages.inputComment;
            }
            return branchNameInputDialogMessages.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "BranchNameInputDialogMessages(title=" + this.title + ", inputMessage=" + this.inputMessage + ", inputComment=" + this.inputComment + ")";
        }

        public int hashCode() {
            String string = this.title;
            String string2 = this.inputMessage;
            String string3 = this.inputComment;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BranchNameInputDialogMessages)) break block3;
                    BranchNameInputDialogMessages branchNameInputDialogMessages = (BranchNameInputDialogMessages)object;
                    if (!Intrinsics.areEqual((Object)this.title, (Object)branchNameInputDialogMessages.title) || !Intrinsics.areEqual((Object)this.inputMessage, (Object)branchNameInputDialogMessages.inputMessage) || !Intrinsics.areEqual((Object)this.inputComment, (Object)branchNameInputDialogMessages.inputComment)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

