/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.el;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_el extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MST",
               "\u038f\u03c1\u03b1 \u039c\u03cc\u03c3\u03c7\u03b1\u03c2",
               "MT",
            };
        final String[] Argentina = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "AST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "AST",
               "\u038f\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "AT",
            };
        final String[] Hovd = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HST",
               "\u038f\u03c1\u03b1 \u03a7\u03bf\u03b2\u03bd\u03c4",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03ac\u03b3\u03ba\u03b1\u03bd\u03c4\u03b1\u03bd",
               "MST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03b1\u03b3\u03ba\u03b1\u03bd\u03c4\u03ac\u03bd",
               "MST",
               "\u038f\u03c1\u03b1 \u039c\u03ac\u03b3\u03ba\u03b1\u03bd\u03c4\u03b1\u03bd",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWDT",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03bf\u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CEST",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "SST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "SST",
               "\u038f\u03c1\u03b1 \u03a3\u03b1\u03c7\u03b1\u03bb\u03af\u03bd\u03b7\u03c2",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "\u038f\u03c1\u03b1 \u039c\u03b1\u03ba\u03bf\u03c5\u03ac\u03c1\u03b9",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "EST",
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "EDT",
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HAST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HADT",
               "\u038f\u03c1\u03b1 \u03a7\u03b1\u03b2\u03ac\u03b7\u03c2-\u0391\u03bb\u03b5\u03bf\u03cd\u03c4\u03b9\u03c9\u03bd \u03bd\u03ae\u03c3\u03c9\u03bd",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "ACDT",
               "\u038f\u03c1\u03b1 \u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHDT",
               "\u038f\u03c1\u03b1 \u039b\u03bf\u03c1\u03bd\u03c4 \u03a7\u03ac\u03bf\u03c5",
               "LHT",
            };
        final String[] Yakutsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YST",
               "\u038f\u03c1\u03b1 \u0393\u03b9\u03b1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd",
               "PST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd",
               "PDT",
               "\u038f\u03c1\u03b1 \u0395\u03b9\u03c1\u03b7\u03bd\u03b9\u03ba\u03bf\u03cd",
               "PT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Europe_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WEST",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "WET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EET",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EEST",
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0395\u03c5\u03c1\u03ce\u03c0\u03b7\u03c2",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NDT",
               "\u038f\u03c1\u03b1 \u039d\u03ad\u03b1\u03c2 \u0393\u03b7\u03c2",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "\u038f\u03c1\u03b1 \u03b4\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "WAST",
               "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "WAST",
               "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0391\u03c1\u03b3\u03b5\u03bd\u03c4\u03b9\u03bd\u03ae\u03c2",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "AST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "ADT",
               "\u038f\u03c1\u03b1 \u0391\u03c4\u03bb\u03b1\u03bd\u03c4\u03b9\u03ba\u03bf\u03cd",
               "AT",
            };
        final String[] Africa_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "WAST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "WAST",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "WAT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b5\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0393\u03b5\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YST",
               "\u038f\u03c1\u03b1 \u0393\u03b5\u03ba\u03b1\u03c4\u03b5\u03c1\u03af\u03bd\u03bc\u03c0\u03bf\u03c5\u03c1\u03b3\u03ba",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03bb\u03b3\u03ba\u03bf\u03b3\u03ba\u03c1\u03b1\u03bd\u03c4",
               "VST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03cc\u03bb\u03b3\u03ba\u03bf\u03b3\u03ba\u03c1\u03b1\u03bd\u03c4",
               "VST",
               "\u038f\u03c1\u03b1 \u0392\u03cc\u03bb\u03b3\u03ba\u03bf\u03b3\u03ba\u03c1\u03b1\u03bd\u03c4",
               "VT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1\u03c2",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "\u038f\u03c1\u03b1 \u039d\u03cc\u03c4\u03b9\u03b1\u03c2 \u0391\u03c6\u03c1\u03b9\u03ba\u03ae\u03c2",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "\u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1\u03c2",
               "EIT",
            };
        final String[] Omsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OST",
               "\u038f\u03c1\u03b1 \u039f\u03bc\u03c3\u03ba",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AWST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AWDT",
               "\u038f\u03c1\u03b1 \u0394\u03c5\u03c4\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "\u0394\u03c5\u03c4\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1 \u0399\u03bd\u03b4\u03bf\u03bd\u03b7\u03c3\u03af\u03b1\u03c2",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "UBST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "UBST",
               "\u038f\u03c1\u03b1 \u039f\u03c5\u03bb\u03ac\u03bd \u039c\u03c0\u03b1\u03c4\u03cc\u03c1",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "CST",
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "CDT",
               "\u039a\u03b5\u03bd\u03c4\u03c1\u03b9\u03ba\u03ae \u03ce\u03c1\u03b1",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AEST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "AEDT",
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03ae\u03c2 \u0391\u03c5\u03c3\u03c4\u03c1\u03b1\u03bb\u03af\u03b1\u03c2",
               "EAT",
            };
        final String[] America_Mountain = new String[] {
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03c7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "MST",
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03b8\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "MDT",
               "\u039f\u03c1\u03b5\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1",
               "MT",
            };
        final String[] Alaska = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKDT",
               "\u038f\u03c1\u03b1 \u0391\u03bb\u03ac\u03c3\u03ba\u03b1\u03c2",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NST",
               "\u038f\u03c1\u03b1 \u039d\u03bf\u03b2\u03bf\u03c3\u03b9\u03bc\u03c0\u03af\u03c1\u03c3\u03ba",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VST",
               "\u038f\u03c1\u03b1 \u0392\u03bb\u03b1\u03b4\u03b9\u03b2\u03bf\u03c3\u03c4\u03cc\u03ba",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IST",
               "\u038f\u03c1\u03b1 \u0399\u03c1\u03ba\u03bf\u03cd\u03c4\u03c3\u03ba",
               "IT",
            };
        final String[] Noronha = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNST",
               "\u038f\u03c1\u03b1 \u03a6\u03b5\u03c1\u03bd\u03ac\u03c1\u03bd\u03c4\u03bf \u03bd\u03c4\u03b5 \u039d\u03bf\u03c1\u03cc\u03bd\u03b9\u03b1",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CST",
               "\u038f\u03c1\u03b1 \u03a4\u03c3\u03bf\u03ca\u03bc\u03c0\u03b1\u03bb\u03c3\u03ac\u03bd",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BST",
               "\u038f\u03c1\u03b1 \u039c\u03c0\u03c1\u03b1\u03b6\u03af\u03bb\u03b9\u03b1",
               "BT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KST",
               "\u038f\u03c1\u03b1 \u039a\u03c1\u03b1\u03c3\u03bd\u03cc\u03b3\u03b9\u03b1\u03c1\u03c3\u03ba",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u038f\u03c1\u03b1 \u03b4\u03c5\u03c4\u03b9\u03ba\u03bf\u03cd \u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Amazon = new String[] {
               "\u03a7\u03b5\u03b9\u03bc\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AST",
               "\u0398\u03b5\u03c1\u03b9\u03bd\u03ae \u03ce\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AST",
               "\u038f\u03c1\u03b1 \u0391\u03bc\u03b1\u03b6\u03bf\u03bd\u03af\u03bf\u03c5",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u038f\u03c1\u03b1 \u0391\u03bd\u03b1\u03c4\u03bf\u03bb\u03b9\u03ba\u03bf\u03cd \u039a\u03b1\u03b6\u03b1\u03ba\u03c3\u03c4\u03ac\u03bd",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Europe/Bucharest", Europe_Eastern },
            { "America/Cuiaba", Amazon },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Libreville", Africa_Western },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/El_Aaiun", Europe_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Europe/Warsaw", Europe_Central },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Windhoek", Africa_Western },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "America/Manaus", Amazon },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Europe/Malta", Europe_Central },
            { "America/Resolute", America_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/Barbados", Atlantic },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Europe/Stockholm", Europe_Central },
            { "America/Tortola", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Asia/Yakutsk", Yakutsk },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Africa/Ceuta", Europe_Central },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Yakutat", Alaska },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
