/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.type;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.type.AbstractTypeFactoryProvider;
import org.jd.gui.util.exception.ExceptionUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassFileTypeFactoryProvider
extends AbstractTypeFactoryProvider {
    protected AbstractTypeFactoryProvider.Cache<URI, JavaType> cache = new AbstractTypeFactoryProvider.Cache();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.class");
    }

    @Override
    public Collection<Type> make(API api, Container.Entry entry) {
        return Collections.singletonList(this.make(api, entry, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Type make(API api, Container.Entry entry, String fragment) {
        JavaType type;
        URI key = entry.getUri();
        if (this.cache.containsKey(key)) {
            return (Type)this.cache.get(key);
        }
        try (InputStream is = entry.getInputStream();){
            ClassReader classReader = new ClassReader(is);
            if (fragment != null && fragment.length() > 0) {
                int index = fragment.indexOf(45);
                if (index != -1) {
                    fragment = fragment.substring(0, index);
                }
                if (!classReader.getClassName().equals(fragment)) {
                    String entryTypePath = classReader.getClassName() + ".class";
                    String fragmentTypePath = fragment + ".class";
                    while (true) {
                        if (entry.getPath().endsWith(entryTypePath)) {
                            Throwable throwable;
                            String pathToFound = entry.getPath().substring(0, entry.getPath().length() - entryTypePath.length()) + fragmentTypePath;
                            Container.Entry entryFound = null;
                            for (Container.Entry e : entry.getParent().getChildren()) {
                                if (!e.getPath().equals(pathToFound)) continue;
                                entryFound = e;
                                break;
                            }
                            if (entryFound == null) {
                                Iterator<Container.Entry> iterator = null;
                                return iterator;
                            }
                            entry = entryFound;
                            try {
                                throwable = null;
                                try (InputStream is2 = entry.getInputStream();){
                                    classReader = new ClassReader(is2);
                                    break;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                            catch (IOException e) {
                                assert (ExceptionUtil.printStackTrace(e));
                                throwable = null;
                                if (is == null) return throwable;
                                if (var7_7 == null) {
                                    is.close();
                                    return throwable;
                                }
                                try {
                                    is.close();
                                    return throwable;
                                }
                                catch (Throwable throwable3) {
                                    var7_7.addSuppressed(throwable3);
                                    return throwable;
                                }
                            }
                        }
                        int firstPackageSeparatorIndex = entryTypePath.indexOf(47);
                        if (firstPackageSeparatorIndex == -1) {
                            Type type2 = null;
                            return type2;
                        }
                        entryTypePath = entryTypePath.substring(firstPackageSeparatorIndex + 1);
                        fragmentTypePath = fragmentTypePath.substring(fragmentTypePath.indexOf(47) + 1);
                    }
                }
            }
            type = new JavaType(entry, classReader, -1);
        }
        catch (IOException e) {
            assert (ExceptionUtil.printStackTrace(e));
            type = null;
        }
        this.cache.put(key, type);
        return type;
    }

    static {
        block2: {
            try {
                Class.forName(JavaType.class.getName());
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block2;
                throw new AssertionError();
            }
        }
    }

    protected static class InnerClassVisitor
    extends ClassVisitor {
        protected String name;
        protected String outerName;
        protected String innerName;

        public InnerClassVisitor(String name) {
            super(458752);
            this.name = name;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (this.name.equals(name)) {
                this.outerName = outerName;
                this.innerName = innerName;
            }
        }

        public String getOuterName() {
            return this.outerName;
        }

        public String getInnerName() {
            return this.innerName;
        }
    }

    static class JavaType
    implements Type {
        protected Container.Entry entry;
        protected int access;
        protected String name;
        protected String superName;
        protected String outerName;
        protected String displayTypeName;
        protected String displayInnerTypeName;
        protected String displayPackageName;
        protected List<Type> innerTypes;
        protected List<Type.Field> fields = new ArrayList<Type.Field>();
        protected List<Type.Method> methods = new ArrayList<Type.Method>();

        protected JavaType(Container.Entry entry, ClassReader classReader, final int outerAccess) {
            this.entry = entry;
            ClassVisitor classAndInnerClassesVisitor = new ClassVisitor(458752){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    access = outerAccess == -1 ? access : outerAccess;
                    name = name;
                    superName = (access & 0x200) != 0 && "java/lang/Object".equals(superName) ? null : superName;
                }

                @Override
                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    block18: {
                        Container.Entry innerEntry;
                        if (name.equals(name)) {
                            outerName = outerName;
                            displayInnerTypeName = innerName;
                        } else if ((access & 0x1040) == 0 && name.equals(outerName) && (innerEntry = this.getEntry(name)) != null) {
                            try (InputStream is = innerEntry.getInputStream();){
                                ClassReader classReader = new ClassReader(is);
                                if (innerTypes == null) {
                                    innerTypes = new ArrayList<Type>();
                                }
                                innerTypes.add(new JavaType(innerEntry, classReader, access));
                            }
                            catch (IOException e) {
                                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block18;
                                throw new AssertionError();
                            }
                        }
                    }
                }
            };
            classReader.accept(classAndInnerClassesVisitor, 7);
            int lastPackageSeparatorIndex = this.name.lastIndexOf(47);
            if (lastPackageSeparatorIndex == -1) {
                this.displayPackageName = "";
                this.displayTypeName = this.outerName == null ? this.name : this.getDisplayTypeName(this.outerName, 0) + '.' + this.displayInnerTypeName;
            } else {
                this.displayPackageName = this.name.substring(0, lastPackageSeparatorIndex).replace('/', '.');
                this.displayTypeName = this.outerName == null ? this.name : this.getDisplayTypeName(this.outerName, lastPackageSeparatorIndex) + '.' + this.displayInnerTypeName;
                this.displayTypeName = this.displayTypeName.substring(lastPackageSeparatorIndex + 1);
            }
            ClassVisitor fieldsAndMethodsVisitor = new ClassVisitor(458752){

                @Override
                public FieldVisitor visitField(final int access, final String name, final String descriptor, String signature, Object value) {
                    if ((access & 0x5000) == 0) {
                        fields.add(new Type.Field(){

                            @Override
                            public int getFlags() {
                                return access;
                            }

                            @Override
                            public String getName() {
                                return name;
                            }

                            @Override
                            public String getDescriptor() {
                                return descriptor;
                            }

                            @Override
                            public Icon getIcon() {
                                return AbstractTypeFactoryProvider.getFieldIcon(access);
                            }

                            @Override
                            public String getDisplayName() {
                                StringBuilder sb = new StringBuilder();
                                sb.append(name).append(" : ");
                                AbstractTypeFactoryProvider.writeSignature(sb, descriptor, descriptor.length(), 0, false);
                                return sb.toString();
                            }
                        });
                    }
                    return null;
                }

                @Override
                public MethodVisitor visitMethod(final int access, final String name, final String descriptor, String signature, String[] exceptions) {
                    if ((access & 0x5040) == 0) {
                        methods.add(new Type.Method(){

                            @Override
                            public int getFlags() {
                                return access;
                            }

                            @Override
                            public String getName() {
                                return name;
                            }

                            @Override
                            public String getDescriptor() {
                                return descriptor;
                            }

                            @Override
                            public Icon getIcon() {
                                return AbstractTypeFactoryProvider.getMethodIcon(access);
                            }

                            @Override
                            public String getDisplayName() {
                                boolean isInnerClass = displayInnerTypeName != null;
                                String constructorName = isInnerClass ? displayInnerTypeName : displayTypeName;
                                StringBuilder sb = new StringBuilder();
                                AbstractTypeFactoryProvider.writeMethodSignature(sb, access, access, isInnerClass, constructorName, name, descriptor);
                                return sb.toString();
                            }
                        });
                    }
                    return null;
                }
            };
            classReader.accept(fieldsAndMethodsVisitor, 7);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String getDisplayTypeName(String name, int packageLength) {
            int indexDollar = name.lastIndexOf(36);
            if (indexDollar <= packageLength) return name;
            Container.Entry entry = this.getEntry(name);
            if (entry == null) return name;
            try (InputStream is = entry.getInputStream();){
                ClassReader classReader = new ClassReader(is);
                InnerClassVisitor classVisitor = new InnerClassVisitor(name);
                classReader.accept(classVisitor, 7);
                String outerName = classVisitor.getOuterName();
                if (outerName == null) return name;
                String string = this.getDisplayTypeName(outerName, packageLength) + '.' + classVisitor.getInnerName();
                return string;
            }
            catch (IOException e) {
                if ($assertionsDisabled) return name;
                if (ExceptionUtil.printStackTrace(e)) return name;
                throw new AssertionError();
            }
        }

        protected Container.Entry getEntry(String typeName) {
            String pathToFound = typeName + ".class";
            for (Container.Entry entry : this.entry.getParent().getChildren()) {
                if (!entry.getPath().equals(pathToFound)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSuperName() {
            return this.superName;
        }

        @Override
        public String getOuterName() {
            return this.outerName;
        }

        @Override
        public String getDisplayPackageName() {
            return this.displayPackageName;
        }

        @Override
        public String getDisplayTypeName() {
            return this.displayTypeName;
        }

        @Override
        public String getDisplayInnerTypeName() {
            return this.displayInnerTypeName;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getTypeIcon(this.access);
        }

        public List<Type> getInnerTypes() {
            return this.innerTypes;
        }

        public List<Type.Field> getFields() {
            return this.fields;
        }

        public List<Type.Method> getMethods() {
            return this.methods;
        }
    }
}

