/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tanukisoftware.wrapper.WrapperLicenseError;
import org.tanukisoftware.wrapper.WrapperManager;

public final class WrapperProcessConfig {
    public static final int POSIX_SPAWN = 1;
    public static final int FORK_EXEC = 2;
    public static final int VFORK_EXEC = 3;
    public static final int DYNAMIC = 4;
    private boolean m_isDetached;
    private boolean m_isInteractive;
    private File m_defdir;
    private int m_startType;
    private boolean m_isNewProcessGroup;
    private Map m_environment;
    private int m_softShutdownTimeout;

    private native String[] nativeGetEnv();

    private static native boolean isSupportedNative(int var0);

    public WrapperProcessConfig() {
        WrapperManager.assertProfessionalEdition();
        this.m_isDetached = false;
        this.m_defdir = null;
        this.m_startType = 4;
        this.m_isNewProcessGroup = true;
        this.m_environment = null;
        this.setSoftShutdownTimeout(5);
        this.m_isInteractive = false;
    }

    public static boolean isSupported(int startType) throws WrapperLicenseError, IllegalArgumentException {
        WrapperManager.assertProfessionalEdition();
        WrapperProcessConfig.verifyStartType(startType);
        if (WrapperManager.isNativeLibraryOk()) {
            return WrapperProcessConfig.isSupportedNative(startType);
        }
        return false;
    }

    public boolean isDetached() {
        return this.m_isDetached;
    }

    public WrapperProcessConfig setDetached(boolean detached) {
        this.m_isDetached = detached;
        return this;
    }

    public int getStartType() {
        return this.m_startType;
    }

    public WrapperProcessConfig setStartType(int startType) throws IllegalArgumentException {
        WrapperProcessConfig.verifyStartType(startType);
        this.m_startType = startType;
        return this;
    }

    public boolean isNewProcessGroup() {
        return this.m_isNewProcessGroup;
    }

    public WrapperProcessConfig setNewProcessGroup(boolean newProcessGroup) {
        this.m_isNewProcessGroup = newProcessGroup;
        return this;
    }

    public File getWorkingDirectory() {
        return this.m_defdir;
    }

    public WrapperProcessConfig setWorkingDirectory(File workingDirectory) throws IOException {
        if (workingDirectory != null) {
            if (!workingDirectory.exists()) {
                throw new IllegalArgumentException(WrapperManager.getRes().getString("Working directory does not exist."));
            }
            if (!workingDirectory.isDirectory()) {
                throw new IllegalArgumentException(WrapperManager.getRes().getString("Must be a directory."));
            }
        }
        this.m_defdir = workingDirectory.getCanonicalFile();
        return this;
    }

    public Map getEnvironment() throws WrapperLicenseError {
        if (this.m_environment == null) {
            this.m_environment = this.getDefaultEnvironment();
        }
        return this.m_environment;
    }

    public WrapperProcessConfig setEnvironment(Map environment) {
        if (environment != null) {
            Iterator iter = environment.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException(WrapperManager.getRes().getString("Map entry names must be Strings."));
                }
                if (((String)key).length() <= 0) {
                    throw new IllegalArgumentException(WrapperManager.getRes().getString("Map entry names must not be empty Strings."));
                }
                if (((String)key).indexOf(61) != -1) {
                    throw new IllegalArgumentException(WrapperManager.getRes().getString("Map entry names must not contain an equal sign (''='')."));
                }
                Object value = entry.getKey();
                if (value instanceof String) continue;
                throw new IllegalArgumentException(WrapperManager.getRes().getString("Map entry values must be Strings."));
            }
        }
        this.m_environment = environment;
        return this;
    }

    public int getSoftShutdownTimeout() {
        return this.m_softShutdownTimeout;
    }

    public WrapperProcessConfig setSoftShutdownTimeout(int softShutdownTimeout) {
        if (softShutdownTimeout < -1) {
            throw new IllegalArgumentException(WrapperManager.getRes().getString("{0} is not a valid value for a timeout.", new Integer(softShutdownTimeout)));
        }
        this.m_softShutdownTimeout = softShutdownTimeout;
        return this;
    }

    private static void verifyStartType(int startType) throws IllegalArgumentException {
        switch (startType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(WrapperManager.getRes().getString("Unknown start type: {0}", new Integer(startType)));
            }
        }
    }

    private Map getDefaultEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        if (WrapperManager.isNativeLibraryOk()) {
            String[] nativeEnv = this.nativeGetEnv();
            for (int i = 0; i < nativeEnv.length; ++i) {
                int pos = nativeEnv[i].indexOf(61);
                String name = nativeEnv[i].substring(0, pos);
                String value = nativeEnv[i].substring(pos + 1);
                environment.put(name, value);
            }
        }
        return environment;
    }

    private String[] getNativeEnv() {
        if (this.m_environment == null) {
            if (WrapperManager.isNativeLibraryOk()) {
                return this.nativeGetEnv();
            }
            return new String[0];
        }
        String[] nativeEnv = new String[this.m_environment.size()];
        Iterator iter = this.m_environment.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry pairs = iter.next();
            nativeEnv[i++] = pairs.getKey() + "=" + pairs.getValue();
        }
        return nativeEnv;
    }

    public WrapperProcessConfig setCreateForActiveUser(boolean isInteractive) {
        this.m_isInteractive = isInteractive && WrapperManager.isWindows() && WrapperManager.isLaunchedAsService();
        return this;
    }

    public boolean isCreateForActiveUser() {
        return this.m_isInteractive;
    }
}

