/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;

class PeerTestState {
    private final long _testNonce;
    private final Role _ourRole;
    private final boolean _isIPv6;
    private InetAddress _aliceIP;
    private int _alicePort;
    private InetAddress _bobIP;
    private int _bobPort;
    private InetAddress _charlieIP;
    private int _charliePort;
    private InetAddress _aliceIPFromCharlie;
    private int _alicePortFromCharlie;
    private SessionKey _aliceIntroKey;
    private SessionKey _charlieIntroKey;
    private SessionKey _bobCipherKey;
    private SessionKey _bobMACKey;
    private final long _beginTime;
    private long _lastSendTime;
    private long _receiveAliceTime;
    private long _receiveBobTime;
    private long _receiveCharlieTime;
    private final AtomicInteger _packetsRelayed = new AtomicInteger();

    public PeerTestState(Role role, boolean isIPv6, long nonce, long now) {
        this._ourRole = role;
        this._isIPv6 = isIPv6;
        this._testNonce = nonce;
        this._beginTime = now;
    }

    public long getNonce() {
        return this._testNonce;
    }

    public Role getOurRole() {
        return this._ourRole;
    }

    public boolean isIPv6() {
        return this._isIPv6;
    }

    public InetAddress getAliceIP() {
        return this._aliceIP;
    }

    public void setAliceIP(InetAddress ip) {
        this._aliceIP = ip;
    }

    public InetAddress getBobIP() {
        return this._bobIP;
    }

    public void setBobIP(InetAddress ip) {
        this._bobIP = ip;
    }

    public InetAddress getCharlieIP() {
        return this._charlieIP;
    }

    public void setCharlieIP(InetAddress ip) {
        this._charlieIP = ip;
    }

    public InetAddress getAliceIPFromCharlie() {
        return this._aliceIPFromCharlie;
    }

    public void setAliceIPFromCharlie(InetAddress ip) {
        this._aliceIPFromCharlie = ip;
    }

    public int getAlicePort() {
        return this._alicePort;
    }

    public void setAlicePort(int alicePort) {
        this._alicePort = alicePort;
    }

    public int getBobPort() {
        return this._bobPort;
    }

    public void setBobPort(int bobPort) {
        this._bobPort = bobPort;
    }

    public int getCharliePort() {
        return this._charliePort;
    }

    public void setCharliePort(int charliePort) {
        this._charliePort = charliePort;
    }

    public int getAlicePortFromCharlie() {
        return this._alicePortFromCharlie;
    }

    public void setAlicePortFromCharlie(int alicePortFromCharlie) {
        this._alicePortFromCharlie = alicePortFromCharlie;
    }

    public SessionKey getAliceIntroKey() {
        return this._aliceIntroKey;
    }

    public void setAliceIntroKey(SessionKey key) {
        this._aliceIntroKey = key;
    }

    public SessionKey getCharlieIntroKey() {
        return this._charlieIntroKey;
    }

    public void setCharlieIntroKey(SessionKey key) {
        this._charlieIntroKey = key;
    }

    public SessionKey getBobCipherKey() {
        return this._bobCipherKey;
    }

    public void setBobCipherKey(SessionKey key) {
        this._bobCipherKey = key;
    }

    public SessionKey getBobMACKey() {
        return this._bobMACKey;
    }

    public void setBobMACKey(SessionKey key) {
        this._bobMACKey = key;
    }

    public long getBeginTime() {
        return this._beginTime;
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public void setLastSendTime(long when) {
        this._lastSendTime = when;
    }

    public long getReceiveAliceTime() {
        return this._receiveAliceTime;
    }

    public void setReceiveAliceTime(long when) {
        this._receiveAliceTime = when;
    }

    public long getReceiveBobTime() {
        return this._receiveBobTime;
    }

    public void setReceiveBobTime(long when) {
        this._receiveBobTime = when;
    }

    public long getReceiveCharlieTime() {
        return this._receiveCharlieTime;
    }

    public void setReceiveCharlieTime(long when) {
        this._receiveCharlieTime = when;
    }

    public int incrementPacketsRelayed() {
        return this._packetsRelayed.incrementAndGet();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("PeerTest ").append(this._testNonce).append(this._isIPv6 ? " IPv6" : " IPv4").append(" started ").append(DataHelper.formatTime(this._beginTime)).append(" as ").append(this._ourRole.toString());
        if (this._aliceIP != null) {
            buf.append("; Alice: ").append(this._aliceIP).append(':').append(this._alicePort);
        }
        if (this._aliceIPFromCharlie != null) {
            buf.append(" (fromCharlie ").append(this._aliceIPFromCharlie).append(':').append(this._alicePortFromCharlie).append(')');
        }
        if (this._bobIP != null) {
            buf.append("; Bob: ").append(this._bobIP).append(':').append(this._bobPort);
        }
        if (this._charlieIP != null) {
            buf.append(" Charlie: ").append(this._charlieIP).append(':').append(this._charliePort);
        }
        if (this._lastSendTime > 0L) {
            buf.append("; last send after ").append(this._lastSendTime - this._beginTime);
        }
        if (this._receiveAliceTime > 0L) {
            buf.append("; rcvd from Alice after ").append(this._receiveAliceTime - this._beginTime);
        }
        if (this._receiveBobTime > 0L) {
            buf.append("; rcvd from Bob after ").append(this._receiveBobTime - this._beginTime);
        }
        if (this._receiveCharlieTime > 0L) {
            buf.append("; rcvd from Charlie after ").append(this._receiveCharlieTime - this._beginTime);
        }
        buf.append("; pkts relayed: ").append(this._packetsRelayed.get());
        return buf.toString();
    }

    public static enum Role {
        ALICE,
        BOB,
        CHARLIE;

    }
}

