/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.client.I2PSessionException;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.data.i2cp.SetDateMessage;
import net.i2p.internal.I2CPMessageQueue;
import net.i2p.router.ClientMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.ClientListenerRunner;
import net.i2p.router.client.I2CPMessageQueueImpl;
import net.i2p.router.client.QueuedClientConnectionRunner;
import net.i2p.router.client.SSLClientListenerRunner;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;

class ClientManager {
    private final Log _log;
    protected final List<ClientListenerRunner> _listeners;
    private final Map<Destination, ClientConnectionRunner> _runners;
    private final Map<Hash, ClientConnectionRunner> _runnersByHash;
    private final Set<ClientConnectionRunner> _pendingRunners;
    private final Set<SessionId> _runnerSessionIds;
    private final Set<Destination> _metaDests;
    private final Set<Hash> _metaHashes;
    protected final RouterContext _ctx;
    protected final int _port;
    protected volatile boolean _isStarted;
    protected volatile boolean _wasStarted;
    private final SimpleTimer2.TimedEvent _clientTimestamper;
    private static final String PROP_DISABLE_EXTERNAL = "i2cp.disableInterface";
    private static final String PROP_ENABLE_SSL = "i2cp.SSL";
    private static final String PROP_DISABLE_LOOPBACK = "i2cp.disableLoopback";
    private static final int INTERNAL_QUEUE_SIZE = 256;
    private static final long REQUEST_LEASESET_TIMEOUT = 60000L;
    private static final int MAX_SESSION_ID = 65534;
    private static final String PROP_MAX_SESSIONS = "i2cp.maxSessions";
    private static final int DEFAULT_MAX_SESSIONS = 100;
    public static final SessionId UNKNOWN_SESSION_ID = new SessionId(65535);

    public ClientManager(RouterContext context, int port) {
        this._ctx = context;
        this._log = context.logManager().getLog(ClientManager.class);
        this._listeners = new ArrayList<ClientListenerRunner>(4);
        this._runners = new ConcurrentHashMap<Destination, ClientConnectionRunner>(4);
        this._runnersByHash = new ConcurrentHashMap<Hash, ClientConnectionRunner>(4);
        this._pendingRunners = new HashSet<ClientConnectionRunner>(4);
        this._runnerSessionIds = new HashSet<SessionId>(4);
        this._metaDests = new ConcurrentHashSet<Destination>(4);
        this._metaHashes = new ConcurrentHashSet<Hash>(4);
        this._port = port;
        this._clientTimestamper = new ClientTimestamper();
        this._ctx.statManager().createRateStat("client.requestLeaseSetSuccess", "How frequently the router requests successfully a new leaseSet?", "ClientMessages", new long[]{3600000L});
        this._ctx.statManager().createRateStat("client.requestLeaseSetTimeout", "How frequently the router requests a new leaseSet but gets no reply?", "ClientMessages", new long[]{3600000L});
        this._ctx.statManager().createRateStat("client.requestLeaseSetDropped", "How frequently the router requests a new leaseSet but the client drops?", "ClientMessages", new long[]{3600000L});
    }

    public synchronized void start() {
        this.startListeners();
    }

    protected void startListeners() {
        ClientListenerRunner listener;
        if (SystemVersion.isAndroid()) {
            try {
                Class<ClientListenerRunner> clazz = Class.forName("net.i2p.router.client.DomainClientListenerRunner").asSubclass(ClientListenerRunner.class);
                Constructor<ClientListenerRunner> ctor = clazz.getDeclaredConstructor(RouterContext.class, ClientManager.class);
                listener = ctor.newInstance(this._ctx, this);
                I2PThread t = new I2PThread(listener, "DomainClientListener", true);
                ((Thread)t).start();
                this._listeners.add(listener);
            }
            catch (ClassNotFoundException e) {
                this._log.warn("Could not find DomainClientListenerRunner class", e);
            }
            catch (ClassCastException e) {
                this._log.error("Error creating DomainClientListenerRunner", e);
            }
            catch (NoSuchMethodException e) {
                this._log.error("Error creating DomainClientListenerRunner", e);
            }
            catch (InstantiationException e) {
                this._log.error("Error creating DomainClientListenerRunner", e);
            }
            catch (IllegalAccessException e) {
                this._log.error("Error creating DomainClientListenerRunner", e);
            }
            catch (InvocationTargetException e) {
                this._log.error("Error creating DomainClientListenerRunner", e);
            }
        }
        if (!this._ctx.getBooleanProperty(PROP_DISABLE_EXTERNAL)) {
            listener = this._ctx.getBooleanProperty(PROP_ENABLE_SSL) ? new SSLClientListenerRunner(this._ctx, this, this._port) : new ClientListenerRunner(this._ctx, this, this._port);
            I2PThread t = new I2PThread(listener, "ClientListener:" + this._port, true);
            ((Thread)t).start();
            this._listeners.add(listener);
            this._clientTimestamper.schedule(600000L);
        }
        this._isStarted = true;
        this._wasStarted = true;
        if (this._log.shouldInfo()) {
            this._log.info("Started the ClientManager");
        }
    }

    public synchronized void restart() {
        this.shutdown("Router restart");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(String msg) {
        this._isStarted = false;
        this._log.info("Shutting down the ClientManager");
        for (ClientListenerRunner listener : this._listeners) {
            listener.stopListening();
        }
        this._listeners.clear();
        HashSet<ClientConnectionRunner> runners = new HashSet<ClientConnectionRunner>();
        Iterator iterator = this._runners;
        synchronized (iterator) {
            for (ClientConnectionRunner runner : this._runners.values()) {
                runners.add(runner);
            }
        }
        iterator = this._pendingRunners;
        synchronized (iterator) {
            for (ClientConnectionRunner runner : this._pendingRunners) {
                runners.add(runner);
            }
        }
        for (ClientConnectionRunner runner : runners) {
            runner.disconnectClient(msg, 30);
        }
        this._runnersByHash.clear();
        this._clientTimestamper.cancel();
    }

    public I2CPMessageQueue internalConnect() throws I2PSessionException {
        if (!this._isStarted) {
            if (this._wasStarted) {
                throw new I2PSessionException("Router client manager is shut down");
            }
            int i = 0;
            do {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    throw new I2PSessionException("Router client manager interrupted", ie);
                }
            } while (!this._isStarted && i++ < 300);
            if (!this._isStarted) {
                throw new I2PSessionException("Router client manager failed to start");
            }
        }
        LinkedBlockingQueue<I2CPMessage> in = new LinkedBlockingQueue<I2CPMessage>(256);
        LinkedBlockingQueue<I2CPMessage> out = new LinkedBlockingQueue<I2CPMessage>(256);
        I2CPMessageQueueImpl myQueue = new I2CPMessageQueueImpl(in, out);
        I2CPMessageQueueImpl hisQueue = new I2CPMessageQueueImpl(out, in);
        QueuedClientConnectionRunner runner = new QueuedClientConnectionRunner(this._ctx, this, myQueue);
        this.registerConnection(runner);
        return hisQueue;
    }

    public synchronized boolean isAlive() {
        return this._isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnection(ClientConnectionRunner runner) {
        try {
            runner.startRunning();
            Set<ClientConnectionRunner> set = this._pendingRunners;
            synchronized (set) {
                this._pendingRunners.add(runner);
            }
        }
        catch (IOException ioe) {
            this._log.error("Error starting up the runner", ioe);
            runner.stopRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnection(ClientConnectionRunner runner) {
        Set<ClientConnectionRunner> set = this._pendingRunners;
        synchronized (set) {
            this._pendingRunners.remove(runner);
        }
        List<SessionId> ids = runner.getSessionIds();
        List<Destination> dests = runner.getDestinations();
        if (this._log.shouldLog(30)) {
            this._log.warn("Unregistering (dropping) a client connection with ids: " + ids);
        }
        Map<Destination, ClientConnectionRunner> map = this._runners;
        synchronized (map) {
            ClientConnectionRunner r;
            for (SessionId id : ids) {
                this._runnerSessionIds.remove(id);
            }
            for (Destination dest : dests) {
                this._runners.remove(dest);
                this._runnersByHash.remove(dest.calculateHash());
            }
            Iterator<ClientConnectionRunner> iter = this._runners.values().iterator();
            while (iter.hasNext()) {
                r = iter.next();
                if (!r.equals(runner)) continue;
                iter.remove();
            }
            iter = this._runnersByHash.values().iterator();
            while (iter.hasNext()) {
                r = iter.next();
                if (!r.equals(runner)) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSession(SessionId id, Destination dest) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Unregistering client session " + id);
        }
        Map<Destination, ClientConnectionRunner> map = this._runners;
        synchronized (map) {
            this._runnerSessionIds.remove(id);
            this._runners.remove(dest);
            this._runnersByHash.remove(dest.calculateHash());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEncryptedDestination(ClientConnectionRunner runner, Hash hash) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Unregistering encrypted LS " + hash.toBase32());
        }
        Map<Destination, ClientConnectionRunner> map = this._runners;
        synchronized (map) {
            this._runnersByHash.remove(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destinationEstablished(ClientConnectionRunner runner, Destination dest) {
        int rv;
        if (this._log.shouldLog(10)) {
            this._log.debug("DestinationEstablished called for destination " + dest.toBase32());
        }
        Set<ClientConnectionRunner> set = this._pendingRunners;
        synchronized (set) {
            this._pendingRunners.remove(runner);
        }
        Map<Destination, ClientConnectionRunner> map = this._runners;
        synchronized (map) {
            boolean fail = this._runnersByHash.containsKey(dest.calculateHash());
            if (fail) {
                rv = 5;
            } else {
                SessionId id = this.locked_getNextSessionId();
                if (id != null) {
                    Hash h = dest.calculateHash();
                    runner.setSessionId(h, id);
                    this._runners.put(dest, runner);
                    this._runnersByHash.put(h, runner);
                    rv = 1;
                } else {
                    rv = 4;
                }
            }
        }
        if (rv == 5) {
            this._log.log(50, "Client attempted to register duplicate destination " + dest.toBase32());
        } else if (rv == 4) {
            this._log.error("Max sessions exceeded " + dest.toBase32());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerEncryptedDestination(ClientConnectionRunner runner, Hash hash) {
        boolean rv;
        if (this._log.shouldLog(10)) {
            this._log.debug("New encrypted LS " + hash.toBase32());
        }
        Map<Destination, ClientConnectionRunner> map = this._runners;
        synchronized (map) {
            boolean bl = rv = !this._runnersByHash.containsKey(hash);
            if (rv) {
                this._runnersByHash.put(hash, runner);
            }
        }
        if (!rv) {
            this._log.error("Encrypted dest collision " + hash.toBase32());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMetaDest(Destination dest) throws I2PSessionException {
        Map<Destination, ClientConnectionRunner> map = this._runners;
        synchronized (map) {
            if (this._runners.containsKey(dest) || this._metaDests.contains(dest)) {
                String msg = "Client attempted to register duplicate destination " + dest.toBase32();
                this._log.error(msg);
                throw new I2PSessionException(msg);
            }
            this._metaDests.add(dest);
            this._metaHashes.add(dest.calculateHash());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMetaDest(Destination dest) {
        Map<Destination, ClientConnectionRunner> map = this._runners;
        synchronized (map) {
            this._metaDests.remove(dest);
            this._metaHashes.remove(dest.calculateHash());
        }
    }

    private SessionId locked_getNextSessionId() {
        int max = Math.max(1, Math.min(2048, this._ctx.getProperty(PROP_MAX_SESSIONS, 100)));
        if (this._runnerSessionIds.size() >= max) {
            this._log.logAlways(30, "Session refused, max is " + max + ", increase " + PROP_MAX_SESSIONS);
            return null;
        }
        for (int i = 0; i < 100; ++i) {
            SessionId id = new SessionId(this._ctx.random().nextInt(65535));
            if (!this._runnerSessionIds.add(id)) continue;
            return id;
        }
        this._log.logAlways(30, "Session refused, can't find id slot");
        return null;
    }

    void distributeMessage(Destination fromDest, Destination toDest, Payload payload, MessageId msgId, long messageNonce, long expiration, int flags) {
        ClientConnectionRunner runner = this._ctx.getBooleanProperty(PROP_DISABLE_LOOPBACK) ? null : this.getRunner(toDest);
        if (runner != null) {
            ClientConnectionRunner sender;
            if (this._log.shouldLog(10)) {
                this._log.debug("Message " + msgId + " is targeting a local destination.  distribute it as such");
            }
            if ((sender = this.getRunner(fromDest)) == null) {
                return;
            }
            DistributeLocal j = new DistributeLocal(toDest, runner, sender, fromDest, payload, msgId, messageNonce);
            j.runJob();
        } else if (!this._metaDests.isEmpty() && this._metaDests.contains(toDest)) {
            ClientConnectionRunner sender = this.getRunner(fromDest);
            if (sender == null) {
                return;
            }
            int rc = 19;
            sender.updateMessageDeliveryStatus(fromDest, msgId, messageNonce, rc);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Message " + msgId + " is targeting a REMOTE destination!  Added to the client message pool");
            }
            if ((runner = this.getRunner(fromDest)) == null) {
                return;
            }
            SessionConfig config = runner.getConfig(fromDest.calculateHash());
            if (config == null) {
                return;
            }
            ClientMessage msg = new ClientMessage(toDest, payload, config, fromDest, msgId, messageNonce, expiration, flags);
            this._ctx.clientMessagePool().add(msg, true);
        }
    }

    public void requestLeaseSet(Destination dest, LeaseSet set, long timeout, Job onCreateJob, Job onFailedJob) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Cannot request the lease set, as we can't find a client runner for " + dest.toBase32() + ".  disconnected?");
            }
            this._ctx.jobQueue().addJob(onFailedJob);
        } else {
            runner.requestLeaseSet(dest.calculateHash(), set, timeout, onCreateJob, onFailedJob);
        }
    }

    public void requestLeaseSet(Hash dest, LeaseSet ls) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            runner.requestLeaseSet(dest, ls, 60000L, null, null);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Cannot request the lease set, as we can't find a client runner for " + dest.toBase32() + ".  disconnected?");
        }
    }

    public boolean isLocal(Destination dest) {
        return this._runners.containsKey(dest) || this._metaDests.contains(dest);
    }

    public boolean isLocal(Hash destHash) {
        if (destHash == null) {
            return false;
        }
        return this._runnersByHash.containsKey(destHash) || this._metaHashes.contains(destHash);
    }

    public boolean shouldPublishLeaseSet(Hash destHash) {
        if (destHash == null) {
            return true;
        }
        ClientConnectionRunner runner = this.getRunner(destHash);
        if (runner == null) {
            return true;
        }
        SessionConfig config = runner.getConfig(destHash);
        if (config == null) {
            return true;
        }
        return !Boolean.parseBoolean(config.getOptions().getProperty("i2cp.dontPublishLeaseSet"));
    }

    public Set<Destination> listClients() {
        HashSet<Destination> rv = new HashSet<Destination>();
        rv.addAll(this._runners.keySet());
        return rv;
    }

    ClientConnectionRunner getRunner(Destination dest) {
        return this._runners.get(dest);
    }

    public SessionConfig getClientSessionConfig(Destination dest) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            return runner.getConfig(dest.calculateHash());
        }
        return null;
    }

    public SessionKeyManager getClientSessionKeyManager(Hash dest) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            return runner.getSessionKeyManager();
        }
        return null;
    }

    private ClientConnectionRunner getRunner(Hash destHash) {
        if (destHash == null) {
            return null;
        }
        return this._runnersByHash.get(destHash);
    }

    public void messageDeliveryStatusUpdate(Destination fromDest, MessageId id, long messageNonce, int status) {
        ClientConnectionRunner runner = this.getRunner(fromDest);
        if (runner != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Delivering status " + status + " to " + fromDest.toBase32() + " for message " + id);
            }
            runner.updateMessageDeliveryStatus(fromDest, id, messageNonce, status);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Cannot deliver status " + status + " to " + fromDest.toBase32() + " for message " + id);
        }
    }

    Set<Destination> getRunnerDestinations() {
        return Collections.unmodifiableSet(this._runners.keySet());
    }

    public void reportAbuse(Destination dest, String reason, int severity) {
        if (dest != null) {
            ClientConnectionRunner runner = this.getRunner(dest);
            if (runner != null) {
                runner.reportAbuse(dest, reason, severity);
            }
        } else {
            for (Destination d : this._runners.keySet()) {
                this.reportAbuse(d, reason, severity);
            }
        }
    }

    @Deprecated
    public void renderStatusHTML(Writer out) throws IOException {
    }

    public void messageReceived(ClientMessage msg) {
        new HandleJob(msg).runJob();
    }

    private class ClientTimestamper
    extends SimpleTimer2.TimedEvent {
        public static final long LOOP_TIME = 600000L;

        public ClientTimestamper() {
            super(ClientManager.this._ctx.simpleTimer2());
        }

        @Override
        public void timeReached() {
            if (!ClientManager.this._isStarted) {
                return;
            }
            for (ClientConnectionRunner runner : ClientManager.this._runners.values()) {
                SessionConfig cfg;
                if (runner instanceof QueuedClientConnectionRunner || runner.isDead() || (cfg = runner.getPrimaryConfig()) == null || runner.getLeaseSet(cfg.getDestination().calculateHash()) == null) continue;
                try {
                    runner.doSend(new SetDateMessage(runner.getClientVersion() != null ? "0.9.51" : null));
                }
                catch (I2CPMessageException i2CPMessageException) {}
            }
            if (ClientManager.this._isStarted) {
                this.schedule(600000L);
            }
        }
    }

    private class HandleJob
    extends JobImpl {
        private final ClientMessage _msg;

        public HandleJob(ClientMessage msg) {
            super(ClientManager.this._ctx);
            this._msg = msg;
        }

        @Override
        public String getName() {
            return "Handle Inbound Client Messages";
        }

        @Override
        public void runJob() {
            Destination dest = this._msg.getDestination();
            ClientConnectionRunner runner = dest != null ? ClientManager.this.getRunner(dest) : ClientManager.this.getRunner(this._msg.getDestinationHash());
            if (runner != null) {
                if (dest != null) {
                    runner.receiveMessage(dest, null, this._msg.getPayload());
                } else {
                    runner.receiveMessage(this._msg.getDestinationHash(), null, this._msg.getPayload());
                }
            } else if (ClientManager.this._log.shouldLog(30)) {
                ClientManager.this._log.warn("Message received but we don't have a connection to " + dest + "/" + this._msg.getDestinationHash().toBase32() + " currently.  DROPPED", new Exception());
            }
        }
    }

    private class DistributeLocal
    extends JobImpl {
        private final Destination _toDest;
        private final ClientConnectionRunner _to;
        private final ClientConnectionRunner _from;
        private final Destination _fromDest;
        private final Payload _payload;
        private final MessageId _msgId;
        private final long _messageNonce;

        public DistributeLocal(Destination toDest, ClientConnectionRunner to, ClientConnectionRunner from, Destination fromDest, Payload payload, MessageId id, long messageNonce) {
            super(ClientManager.this._ctx);
            this._toDest = toDest;
            this._to = to;
            this._from = from;
            this._fromDest = fromDest;
            this._payload = payload;
            this._msgId = id;
            this._messageNonce = messageNonce;
        }

        @Override
        public String getName() {
            return "Distribute local message";
        }

        @Override
        public void runJob() {
            boolean ok = this._to.receiveMessage(this._toDest, this._fromDest, this._payload);
            if (this._from != null) {
                int rc = ok ? 6 : 7;
                this._from.updateMessageDeliveryStatus(this._fromDest, this._msgId, this._messageNonce, rc);
            }
        }
    }
}

