/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.deliver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.deliver.DeliverEngineSettings;
import org.apache.ivy.core.deliver.DeliverOptions;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class DeliverEngine {
    private DeliverEngineSettings settings;

    public DeliverEngine(DeliverEngineSettings settings) {
        this.settings = settings;
    }

    public void deliver(String revision, String destIvyPattern, DeliverOptions options) throws IOException, ParseException {
        String resolveId = options.getResolveId();
        if (resolveId == null) {
            throw new IllegalArgumentException("A resolveId must be specified for delivering.");
        }
        File[] files = this.getCache().getConfigurationResolveReportsInCache(resolveId);
        if (files.length == 0) {
            throw new IllegalStateException("No previous resolve found for id '" + resolveId + "' Please resolve dependencies before delivering.");
        }
        XmlReportParser parser = new XmlReportParser();
        parser.parse(files[0]);
        ModuleRevisionId mrid = parser.getResolvedModule();
        this.deliver(mrid, revision, destIvyPattern, options);
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    public void deliver(ModuleRevisionId mrid, String revision, String destIvyPattern, DeliverOptions options) throws IOException, ParseException {
        Message.info(":: delivering :: " + mrid + " :: " + revision + " :: " + options.getStatus() + " :: " + options.getPubdate());
        Message.verbose("\toptions = " + options);
        long start = System.currentTimeMillis();
        destIvyPattern = this.settings.substitute(destIvyPattern);
        ModuleDescriptor md = this.getCache().getResolvedModuleDescriptor(mrid);
        md.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(md.getModuleRevisionId(), options.getPubBranch() == null ? mrid.getBranch() : options.getPubBranch(), revision));
        md.setResolvedPublicationDate(options.getPubdate());
        HashMap<ModuleRevisionId, String> resolvedRevisions = new HashMap<ModuleRevisionId, String>();
        HashMap<ModuleRevisionId, String> resolvedBranches = new HashMap<ModuleRevisionId, String>();
        HashMap<ModuleRevisionId, String> dependenciesStatus = new HashMap<ModuleRevisionId, String>();
        File ivyProperties = this.getCache().getResolvedIvyPropertiesInCache(mrid);
        if (!ivyProperties.exists()) {
            throw new IllegalStateException("ivy properties not found in cache for " + mrid + "; please resolve dependencies before delivering!");
        }
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(ivyProperties);
        props.load(in);
        in.close();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String depMridStr = (String)iter.next();
            String[] parts = props.getProperty(depMridStr).split(" ");
            ModuleRevisionId decodedMrid = ModuleRevisionId.decode(depMridStr);
            if (options.isResolveDynamicRevisions()) {
                resolvedRevisions.put(decodedMrid, parts[0]);
                if (parts.length >= 4 && parts[3] != null && !"null".equals(parts[3])) {
                    resolvedBranches.put(decodedMrid, parts[3]);
                }
            }
            dependenciesStatus.put(decodedMrid, parts[1]);
            if (!options.isReplaceForcedRevisions()) continue;
            if (parts.length <= 2) {
                throw new IllegalStateException("ivy properties file generated by an older version of Ivy which doesn't support replacing forced revisions!");
            }
            resolvedRevisions.put(decodedMrid, parts[2]);
        }
        HashMap<ModuleRevisionId, String> resolvedDependencies = new HashMap<ModuleRevisionId, String>();
        DependencyDescriptor[] dependencies = md.getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            String bra;
            String rev = (String)resolvedRevisions.get(dependencies[i].getDependencyRevisionId());
            if (rev == null) {
                rev = dependencies[i].getDependencyRevisionId().getRevision();
            }
            if ((bra = (String)resolvedBranches.get(dependencies[i].getDependencyRevisionId())) == null || "null".equals(bra)) {
                bra = dependencies[i].getDependencyRevisionId().getBranch();
            }
            String depStatus = (String)dependenciesStatus.get(dependencies[i].getDependencyRevisionId());
            ModuleRevisionId mrid2 = null;
            mrid2 = bra == null ? ModuleRevisionId.newInstance(dependencies[i].getDependencyRevisionId(), rev) : ModuleRevisionId.newInstance(dependencies[i].getDependencyRevisionId(), bra, rev);
            resolvedDependencies.put(dependencies[i].getDependencyRevisionId(), options.getPdrResolver().resolve(md, options.getStatus(), mrid2, depStatus));
        }
        File publishedIvy = this.settings.resolveFile(IvyPatternHelper.substitute(destIvyPattern, md.getResolvedModuleRevisionId()));
        Message.info("\tdelivering ivy file to " + publishedIvy);
        String[] confs = ConfigurationUtils.replaceWildcards(options.getConfs(), md);
        HashSet<String> confsToRemove = new HashSet<String>(Arrays.asList(md.getConfigurationsNames()));
        confsToRemove.removeAll(Arrays.asList(confs));
        try {
            UpdateOptions opts = new UpdateOptions().setSettings(this.settings).setResolvedRevisions(resolvedDependencies).setStatus(options.getStatus()).setRevision(revision).setBranch(options.getPubBranch()).setPubdate(options.getPubdate()).setGenerateRevConstraint(options.isGenerateRevConstraint()).setMerge(options.isMerge()).setMergedDescriptor(md).setConfsToExclude(confsToRemove.toArray(new String[confsToRemove.size()]));
            if (!resolvedBranches.isEmpty()) {
                opts = opts.setResolvedBranches(resolvedBranches);
            }
            Resource res = md.getResource();
            XmlModuleDescriptorUpdater.update(res.openStream(), res, publishedIvy, opts);
        }
        catch (SAXException ex) {
            throw new RuntimeException("bad ivy file in cache for " + mrid, ex);
        }
        Message.verbose("\tdeliver done (" + (System.currentTimeMillis() - start) + "ms)");
    }
}

