(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/misc/string#string-trim-prefix
    (lambda (_prefix709_ _string710_)
      (if (std/srfi/13#string-prefix?__0 _prefix709_ _string710_)
          (std/srfi/13#string-drop _string710_ (string-length _prefix709_))
          _string710_)))
  (define std/misc/string#string-split-prefix
    (lambda (_prefix704_ _string705_)
      (let ((_trimmed707_
             (std/misc/string#string-trim-prefix _prefix704_ _string705_)))
        (if (eq? _trimmed707_ _string705_)
            (values _string705_ '"")
            (values _trimmed707_ _prefix704_)))))
  (define std/misc/string#string-trim-suffix
    (lambda (_suffix701_ _string702_)
      (if (std/srfi/13#string-suffix?__0 _suffix701_ _string702_)
          (std/srfi/13#string-drop-right
           _string702_
           (string-length _suffix701_))
          _string702_)))
  (define std/misc/string#string-split-suffix
    (lambda (_suffix696_ _string697_)
      (let ((_trimmed699_
             (std/misc/string#string-trim-suffix _suffix696_ _string697_)))
        (if (eq? _trimmed699_ _string697_)
            (values _string697_ '"")
            (values _trimmed699_ _suffix696_)))))
  (define std/misc/string#+cr+ '"\r")
  (define std/misc/string#+lf+ '"\n")
  (define std/misc/string#+crlf+ '"\r\n")
  (define std/misc/string#string-trim-eol
    (lambda (_string598_)
      (let ((_trimmed687_
             (std/misc/string#string-trim-suffix
              std/misc/string#+crlf+
              _string598_)))
        (if (eq? _trimmed687_ _string598_)
            (let ((_trimmed690_
                   (std/misc/string#string-trim-suffix
                    std/misc/string#+lf+
                    _string598_)))
              (if (eq? _trimmed690_ _string598_)
                  (let ((_trimmed693_
                         (std/misc/string#string-trim-suffix
                          std/misc/string#+cr+
                          _string598_)))
                    (if (eq? _trimmed693_ _string598_)
                        _string598_
                        _trimmed693_))
                  _trimmed690_))
            _trimmed687_))))
  (define std/misc/string#string-split-eol
    (lambda (_string497_)
      (let ((_trimmed589_
             (std/misc/string#string-trim-suffix
              std/misc/string#+crlf+
              _string497_)))
        (if (eq? _trimmed589_ _string497_)
            (let ((_trimmed592_
                   (std/misc/string#string-trim-suffix
                    std/misc/string#+lf+
                    _string497_)))
              (if (eq? _trimmed592_ _string497_)
                  (let ((_trimmed595_
                         (std/misc/string#string-trim-suffix
                          std/misc/string#+cr+
                          _string497_)))
                    (if (eq? _trimmed595_ _string497_)
                        (values _string497_ '"")
                        (values _trimmed595_ std/misc/string#+cr+)))
                  (values _trimmed592_ std/misc/string#+lf+)))
            (values _trimmed589_ std/misc/string#+crlf+)))))
  (define std/misc/string#subst-helper-empty-old
    (lambda (_str478_ _new479_ _count480_)
      (declare (fixnum))
      (letrec* ((_len-str482_ (string-length _str478_)))
        (if (= _count480_ '1)
            (string-append _new479_ _str478_)
            (call-with-output-string
             (lambda (_port484_)
               (gerbil/gambit/ports#write-string__% _new479_ _port484_)
               (let ((_stop489_ (- _len-str482_ '1))
                     (_count490_
                      (if (or (negative? _count480_)
                              (> _count480_ _len-str482_))
                          (+ _len-str482_ '1)
                          _count480_)))
                 (let _loop492_ ((_i494_ '0) (_matches495_ '1))
                   (if (= _matches495_ _count490_)
                       (begin
                         (gerbil/gambit/ports#write-string__%
                          _new479_
                          _port484_)
                         (write-substring
                          _str478_
                          _i494_
                          _len-str482_
                          _port484_))
                       (if (= _i494_ _stop489_)
                           (begin
                             (if (zero? _i494_)
                                 '#!void
                                 (gerbil/gambit/ports#write-string__%
                                  _new479_
                                  _port484_))
                             (write-char
                              (string-ref _str478_ _i494_)
                              _port484_)
                             (gerbil/gambit/ports#write-string__%
                              _new479_
                              _port484_))
                           (begin
                             (if (zero? _i494_)
                                 '#!void
                                 (gerbil/gambit/ports#write-string__%
                                  _new479_
                                  _port484_))
                             (write-char
                              (string-ref _str478_ _i494_)
                              _port484_)
                             (_loop492_
                              (+ _i494_ '1)
                              (+ _matches495_ '1)))))))))))))
  (define std/misc/string#subst-helper-nonempty-old
    (lambda (_str460_ _old461_ _new462_ _count463_)
      (declare (fixnum))
      (letrec* ((_len-str465_ (string-length _str460_))
                (_size-old466_ (- (string-length _old461_) '1))
                (_size-str467_ (- (string-length _str460_) '1)))
        (call-with-output-string
         (lambda (_port469_)
           (let _loop471_ ((_i473_ '0)
                           (_matches474_ '0)
                           (_last475_ '0)
                           (_j476_ '0))
             (if (= _matches474_ _count463_)
                 (write-substring _str460_ _i473_ _len-str465_ _port469_)
                 (if (= _i473_ _size-str467_)
                     (if (and (eq? (string-ref _str460_ _i473_)
                                   (string-ref _old461_ _j476_))
                              (= _j476_ _size-old466_))
                         (gerbil/gambit/ports#write-string__%
                          _new462_
                          _port469_)
                         (write-substring
                          _str460_
                          _last475_
                          _len-str465_
                          _port469_))
                     (if (eq? (string-ref _str460_ _i473_)
                              (string-ref _old461_ _j476_))
                         (if (= _j476_ _size-old466_)
                             (begin
                               (gerbil/gambit/ports#write-string__%
                                _new462_
                                _port469_)
                               (_loop471_
                                (+ _i473_ '1)
                                (+ _matches474_ '1)
                                (+ _i473_ '1)
                                '0))
                             (_loop471_
                              (+ _i473_ '1)
                              _matches474_
                              _last475_
                              (+ _j476_ '1)))
                         (begin
                           (write-substring
                            _str460_
                            _last475_
                            (+ _i473_ '1)
                            _port469_)
                           (_loop471_
                            (+ _i473_ '1)
                            _matches474_
                            (+ _i473_ '1)
                            '0)))))))))))
  (define std/misc/string#string-subst__%
    (lambda (_g4309_ _count423426_ _str428_ _old429_ _new430_)
      (let ((_count432_
             (if (eq? _count423426_ absent-value) '#f _count423426_)))
        (declare (fixnum))
        (letrec* ((_g4310_ (let ((_g4311_ (if (or (not _count432_)
                                                  (fixnum? _count432_))
                                              '#!void
                                              (error '"Illegal argument; count must be a fixnum or #f, got:"
                                                     _count432_))))
                             #!void
                             _g4311_))
                  (_old-empty?437_ (string-empty? _old429_))
                  (_new-empty?438_ (string-empty? _new430_))
                  (_str-empty?439_ (string-empty? _str428_)))
          (if (or (and _old-empty?437_ _new-empty?438_)
                  (and _count432_ (<= _count432_ '0)))
              _str428_
              (let ((_count444_ (if (number? _count432_) _count432_ '-1)))
                (if _old-empty?437_
                    (std/misc/string#subst-helper-empty-old
                     _str428_
                     _new430_
                     _count444_)
                    (if _str-empty?439_
                        _str428_
                        (std/misc/string#subst-helper-nonempty-old
                         _str428_
                         _old429_
                         _new430_
                         _count444_)))))))))
  (define std/misc/string#string-subst__@
    (lambda (_keys422449_ . _args451_)
      (apply std/misc/string#string-subst__%
             _keys422449_
             (table-ref _keys422449_ 'count: absent-value)
             _args451_)))
  (define std/misc/string#string-subst
    (lambda _args424457_
      (apply keyword-dispatch
             '#(count:)
             std/misc/string#string-subst__@
             _args424457_)))
  (define std/misc/string#string-whitespace?
    (lambda (_s419_) (std/srfi/13#string-every__0 char-whitespace? _s419_)))
  (define std/misc/string#random-word-char
    (lambda ()
      (declare (not safe) (fixnum))
      (letrec* ((_n417_ (random-integer '63)))
        (integer->char
         (+ _n417_
            (if (< _n417_ '10)
                '48
                (if (< _n417_ '36) '55 (if (< _n417_ '62) '61 '33))))))))
  (define std/misc/string#random-string__%
    (lambda (_len398_)
      (declare (not safe) (fixnum))
      (begin
        (if (fixnum? _len398_) '#!void (error '"len must be a fixnum"))
        (if (> _len398_ '0)
            (let ((_str401_ (make-string _len398_)))
              (let _$loop403_ ((_i406_ '0))
                (if (= _i406_ _len398_)
                    '#!void
                    (begin
                      (string-set!
                       _str401_
                       _i406_
                       (std/misc/string#random-word-char))
                      (_$loop403_ (+ _i406_ '1)))))
              _str401_)
            '""))))
  (define std/misc/string#random-string__0
    (lambda ()
      (let ((_len412_ '10)) (std/misc/string#random-string__% _len412_))))
  (define std/misc/string#random-string
    (lambda _g4314_
      (let ((_g4313_ (let () (declare (not safe)) (##length _g4314_))))
        (cond ((let () (declare (not safe)) (##fx= _g4313_ 0))
               (apply std/misc/string#random-string__0 _g4314_))
              ((let () (declare (not safe)) (##fx= _g4313_ 1))
               (apply std/misc/string#random-string__% _g4314_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/misc/string#random-string
                _g4314_)))))))
